/* **********************************************************
 * Copyright (c) 2018-2021 Google, Inc.  All rights reserved.
 * **********************************************************/

/*
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * Neither the name of Google, Inc. nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL VMWARE, INC. OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

/* view tool creation */

#ifndef _VIEW_CREATE_H_
#define _VIEW_CREATE_H_ 1

#include "analysis_tool.h"

/**
 * @file drmemtrace/view_create.h
 * @brief DrMemtrace view trace analysis tool creation.
 */

/**
 * Creates an analysis tool which prints out the disassembled instructions from
 * the binary in the order they are present in the trace. This tool needs access
 * to the modules.log and original libraries and binaries from the traced execution.
 * It does not support online analysis.
 */
analysis_tool_t *
view_tool_create(const std::string &module_file_path, memref_tid_t thread,
                 uint64_t skip_refs, uint64_t sim_refs, const std::string &syntax,
                 unsigned int verbose = 0, const std::string &alt_module_dir = "");

#endif /* _OPCODE_MIX_CREATE_H_ */
