/*
    Copyright (C) 2014-2019 de4dot@gmail.com

    This file is part of dnSpy

    dnSpy is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    dnSpy is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with dnSpy.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace dnSpy.Contracts.Images {
	/// <summary>
	/// Image references to images used by dnSpy
	/// </summary>
	static class DsImageStrings {
#pragma warning disable CS1591 // Missing XML comment for publicly visible type or member
		public const string Add = nameof(Add);
		public const string AddReference = nameof(AddReference);
		public const string AdvancedBreakpointDisabled = nameof(AdvancedBreakpointDisabled);
		public const string AdvancedBreakpointEnabled = nameof(AdvancedBreakpointEnabled);
		public const string AdvancedTracepointDisabled = nameof(AdvancedTracepointDisabled);
		public const string AdvancedTracepointEnabled = nameof(AdvancedTracepointEnabled);
		public const string Assembly = nameof(Assembly);
		public const string AssemblyError = nameof(AssemblyError);
		public const string AssemblyExe = nameof(AssemblyExe);
		public const string AutoSizeOptimize = nameof(AutoSizeOptimize);
		public const string AutosWindow = nameof(AutosWindow);
		public const string Backwards = nameof(Backwards);
		public const string Binary = nameof(Binary);
		public const string BinaryFile = nameof(BinaryFile);
		public const string Bookmark = nameof(Bookmark);
		public const string BookmarkDisabled = nameof(BookmarkDisabled);
		public const string BookmarkGroupDisabled = nameof(BookmarkGroupDisabled);
		public const string BookmarkMainMenuItem = nameof(BookmarkMainMenuItem);
		public const string BoundBreakpoint = nameof(BoundBreakpoint);
		public const string Branch = nameof(Branch);
		public const string BreakpointDisabled = nameof(BreakpointDisabled);
		public const string BreakpointEnabled = nameof(BreakpointEnabled);
		public const string BreakpointError = nameof(BreakpointError);
		public const string BreakpointsWindow = nameof(BreakpointsWindow);
		public const string BreakpointWarning = nameof(BreakpointWarning);
		public const string BuildSolution = nameof(BuildSolution);
		public const string CallReturnInstructionPointer = nameof(CallReturnInstructionPointer);
		public const string CallReturnInstructionPointerAlert = nameof(CallReturnInstructionPointerAlert);
		public const string CallStackWindow = nameof(CallStackWindow);
		public const string Cancel = nameof(Cancel);
		public const string CheckDot = nameof(CheckDot);
		public const string ClassInternal = nameof(ClassInternal);
		public const string ClassPrivate = nameof(ClassPrivate);
		public const string ClassProtected = nameof(ClassProtected);
		public const string ClassPublic = nameof(ClassPublic);
		public const string ClassShortcut = nameof(ClassShortcut);
		public const string ClearBookmark = nameof(ClearBookmark);
		public const string ClearBreakpointGroup = nameof(ClearBreakpointGroup);
		public const string ClearWindowContent = nameof(ClearWindowContent);
		public const string CloseAll = nameof(CloseAll);
		public const string CloseDocumentGroup = nameof(CloseDocumentGroup);
		public const string CloseSolution = nameof(CloseSolution);
		public const string ConstantInternal = nameof(ConstantInternal);
		public const string ConstantPrivate = nameof(ConstantPrivate);
		public const string ConstantProtected = nameof(ConstantProtected);
		public const string ConstantPublic = nameof(ConstantPublic);
		public const string ConstantSealed = nameof(ConstantSealed);
		public const string ConstantShortcut = nameof(ConstantShortcut);
		public const string Copy = nameof(Copy);
		public const string CopyItem = nameof(CopyItem);
		public const string CSFileNode = nameof(CSFileNode);
		public const string CSInteractiveWindow = nameof(CSInteractiveWindow);
		public const string CSProjectNode = nameof(CSProjectNode);
		public const string CurrentInstructionPointer = nameof(CurrentInstructionPointer);
		public const string CurrentInstructionPointerPaused = nameof(CurrentInstructionPointerPaused);
		public const string CurrentInstructionPointerStopped = nameof(CurrentInstructionPointerStopped);
		public const string Cursor = nameof(Cursor);
		public const string Cut = nameof(Cut);
		public const string DelegateInternal = nameof(DelegateInternal);
		public const string DelegatePrivate = nameof(DelegatePrivate);
		public const string DelegateProtected = nameof(DelegateProtected);
		public const string DelegatePublic = nameof(DelegatePublic);
		public const string DelegateShortcut = nameof(DelegateShortcut);
		public const string DeleteBreakpoint = nameof(DeleteBreakpoint);
		public const string DeleteWatch = nameof(DeleteWatch);
		public const string Dialog = nameof(Dialog);
		public const string DisableAllBreakpoints = nameof(DisableAllBreakpoints);
		public const string DisassemblyWindow = nameof(DisassemblyWindow);
		public const string DownloadNoColor = nameof(DownloadNoColor);
		public const string DraggedCurrentInstructionPointer = nameof(DraggedCurrentInstructionPointer);
		public const string DraggedInstructionPointerPaused = nameof(DraggedInstructionPointerPaused);
		public const string Edit = nameof(Edit);
		public const string Editor = nameof(Editor);
		public const string EnableAllBreakpoints = nameof(EnableAllBreakpoints);
		public const string EntryPoint = nameof(EntryPoint);
		public const string EnumerationInternal = nameof(EnumerationInternal);
		public const string EnumerationItemInternal = nameof(EnumerationItemInternal);
		public const string EnumerationItemPrivate = nameof(EnumerationItemPrivate);
		public const string EnumerationItemProtected = nameof(EnumerationItemProtected);
		public const string EnumerationItemPublic = nameof(EnumerationItemPublic);
		public const string EnumerationItemSealed = nameof(EnumerationItemSealed);
		public const string EnumerationItemShortcut = nameof(EnumerationItemShortcut);
		public const string EnumerationPrivate = nameof(EnumerationPrivate);
		public const string EnumerationProtected = nameof(EnumerationProtected);
		public const string EnumerationPublic = nameof(EnumerationPublic);
		public const string EnumerationShortcut = nameof(EnumerationShortcut);
		public const string EventInternal = nameof(EventInternal);
		public const string EventPrivate = nameof(EventPrivate);
		public const string EventProtected = nameof(EventProtected);
		public const string EventPublic = nameof(EventPublic);
		public const string EventSealed = nameof(EventSealed);
		public const string EventShortcut = nameof(EventShortcut);
		public const string ExceptionInternal = nameof(ExceptionInternal);
		public const string ExceptionPrivate = nameof(ExceptionPrivate);
		public const string ExceptionProtected = nameof(ExceptionProtected);
		public const string ExceptionPublic = nameof(ExceptionPublic);
		public const string ExceptionSettings = nameof(ExceptionSettings);
		public const string ExceptionShortcut = nameof(ExceptionShortcut);
		public const string ExtensionMethod = nameof(ExtensionMethod);
		public const string FieldInternal = nameof(FieldInternal);
		public const string FieldPrivate = nameof(FieldPrivate);
		public const string FieldProtected = nameof(FieldProtected);
		public const string FieldPublic = nameof(FieldPublic);
		public const string FieldSealed = nameof(FieldSealed);
		public const string FieldShortcut = nameof(FieldShortcut);
		public const string FileSystemWatcher = nameof(FileSystemWatcher);
		public const string Fill = nameof(Fill);
		public const string Filter = nameof(Filter);
		public const string FolderClosed = nameof(FolderClosed);
		public const string FolderOpened = nameof(FolderOpened);
		public const string Forwards = nameof(Forwards);
		public const string GoToNext = nameof(GoToNext);
		public const string GoToNextInList = nameof(GoToNextInList);
		public const string GoToSourceCode = nameof(GoToSourceCode);
		public const string Image = nameof(Image);
		public const string Import = nameof(Import);
		public const string IntellisenseKeyword = nameof(IntellisenseKeyword);
		public const string InterfaceInternal = nameof(InterfaceInternal);
		public const string InterfacePrivate = nameof(InterfacePrivate);
		public const string InterfaceProtected = nameof(InterfaceProtected);
		public const string InterfacePublic = nameof(InterfacePublic);
		public const string InterfaceShortcut = nameof(InterfaceShortcut);
		public const string Label = nameof(Label);
		public const string Library = nameof(Library);
		public const string LocalsWindow = nameof(LocalsWindow);
		public const string LocalVariable = nameof(LocalVariable);
		public const string MarkupTag = nameof(MarkupTag);
		public const string MemoryWindow = nameof(MemoryWindow);
		public const string Metadata = nameof(Metadata);
		public const string MethodInternal = nameof(MethodInternal);
		public const string MethodPrivate = nameof(MethodPrivate);
		public const string MethodProtected = nameof(MethodProtected);
		public const string MethodPublic = nameof(MethodPublic);
		public const string MethodSealed = nameof(MethodSealed);
		public const string MethodShortcut = nameof(MethodShortcut);
		public const string ModuleFile = nameof(ModuleFile);
		public const string ModuleInternal = nameof(ModuleInternal);
		public const string ModulePrivate = nameof(ModulePrivate);
		public const string ModuleProtected = nameof(ModuleProtected);
		public const string ModulePublic = nameof(ModulePublic);
		public const string ModulesWindow = nameof(ModulesWindow);
		public const string MoveUp = nameof(MoveUp);
		public const string Namespace = nameof(Namespace);
		public const string NewClass = nameof(NewClass);
		public const string NewDocument = nameof(NewDocument);
		public const string NewEvent = nameof(NewEvent);
		public const string NewField = nameof(NewField);
		public const string NewImage = nameof(NewImage);
		public const string NewItem = nameof(NewItem);
		public const string NewMethod = nameof(NewMethod);
		public const string NewProperty = nameof(NewProperty);
		public const string NewWindow = nameof(NewWindow);
		public const string NextBookmark = nameof(NextBookmark);
		public const string NextBookmarkInFile = nameof(NextBookmarkInFile);
		public const string NextBookmarkInFolder = nameof(NextBookmarkInFolder);
		public const string NuGet = nameof(NuGet);
		public const string OneLevelUp = nameof(OneLevelUp);
		public const string Open = nameof(Open);
		public const string OpenFolder = nameof(OpenFolder);
		public const string OperatorInternal = nameof(OperatorInternal);
		public const string OperatorPrivate = nameof(OperatorPrivate);
		public const string OperatorProtected = nameof(OperatorProtected);
		public const string OperatorPublic = nameof(OperatorPublic);
		public const string OperatorSealed = nameof(OperatorSealed);
		public const string OperatorShortcut = nameof(OperatorShortcut);
		public const string Output = nameof(Output);
		public const string Parameter = nameof(Parameter);
		public const string Paste = nameof(Paste);
		public const string Pause = nameof(Pause);
		public const string PreviousBookmark = nameof(PreviousBookmark);
		public const string PreviousBookmarkInFile = nameof(PreviousBookmarkInFile);
		public const string PreviousBookmarkInFolder = nameof(PreviousBookmarkInFolder);
		public const string Process = nameof(Process);
		public const string Property = nameof(Property);
		public const string PropertyInternal = nameof(PropertyInternal);
		public const string PropertyPrivate = nameof(PropertyPrivate);
		public const string PropertyProtected = nameof(PropertyProtected);
		public const string PropertySealed = nameof(PropertySealed);
		public const string PropertyShortcut = nameof(PropertyShortcut);
		public const string QuestionMark = nameof(QuestionMark);
		public const string Redo = nameof(Redo);
		public const string Reference = nameof(Reference);
		public const string Refresh = nameof(Refresh);
		public const string RemoveCommand = nameof(RemoveCommand);
		public const string Restart = nameof(Restart);
		public const string Run = nameof(Run);
		public const string RunOutline = nameof(RunOutline);
		public const string Save = nameof(Save);
		public const string SaveAll = nameof(SaveAll);
		public const string Search = nameof(Search);
		public const string Select = nameof(Select);
		public const string Settings = nameof(Settings);
		public const string Snippet = nameof(Snippet);
		public const string Solution = nameof(Solution);
		public const string SortAscending = nameof(SortAscending);
		public const string SourceFileGroup = nameof(SourceFileGroup);
		public const string SplitScreenHorizontally = nameof(SplitScreenHorizontally);
		public const string SplitScreenVertically = nameof(SplitScreenVertically);
		public const string StatusError = nameof(StatusError);
		public const string StatusHelp = nameof(StatusHelp);
		public const string StatusHidden = nameof(StatusHidden);
		public const string StatusInformation = nameof(StatusInformation);
		public const string StatusWarning = nameof(StatusWarning);
		public const string StepInto = nameof(StepInto);
		public const string StepOut = nameof(StepOut);
		public const string StepOver = nameof(StepOver);
		public const string Stop = nameof(Stop);
		public const string String = nameof(String);
		public const string StructureInternal = nameof(StructureInternal);
		public const string StructurePrivate = nameof(StructurePrivate);
		public const string StructureProtected = nameof(StructureProtected);
		public const string StructurePublic = nameof(StructurePublic);
		public const string StructureShortcut = nameof(StructureShortcut);
		public const string TableViewNameOnly = nameof(TableViewNameOnly);
		public const string Template = nameof(Template);
		public const string TemplateInternal = nameof(TemplateInternal);
		public const string TemplatePrivate = nameof(TemplatePrivate);
		public const string TemplateProtected = nameof(TemplateProtected);
		public const string TemplateShortcut = nameof(TemplateShortcut);
		public const string TerminateProcess = nameof(TerminateProcess);
		public const string TextFile = nameof(TextFile);
		public const string Thread = nameof(Thread);
		public const string ToggleAllBreakpoints = nameof(ToggleAllBreakpoints);
		public const string ToolstripPanelBottom = nameof(ToolstripPanelBottom);
		public const string ToolstripPanelLeft = nameof(ToolstripPanelLeft);
		public const string ToolstripPanelRight = nameof(ToolstripPanelRight);
		public const string ToolstripPanelTop = nameof(ToolstripPanelTop);
		public const string TracepointDisabled = nameof(TracepointDisabled);
		public const string TracepointEnabled = nameof(TracepointEnabled);
		public const string TracepointError = nameof(TracepointError);
		public const string TracepointWarning = nameof(TracepointWarning);
		public const string Type = nameof(Type);
		public const string Undo = nameof(Undo);
		public const string UndoCheckBoxList = nameof(UndoCheckBoxList);
		public const string UserDefinedDataType = nameof(UserDefinedDataType);
		public const string VBFileNode = nameof(VBFileNode);
		public const string VBInteractiveWindow = nameof(VBInteractiveWindow);
		public const string VBProjectNode = nameof(VBProjectNode);
		public const string Watch = nameof(Watch);
		public const string WordWrap = nameof(WordWrap);
		public const string WPFFile = nameof(WPFFile);
		public const string XMLFile = nameof(XMLFile);
		public const string XMLSchema = nameof(XMLSchema);
		public const string XSLTransform = nameof(XSLTransform);
#pragma warning restore CS1591 // Missing XML comment for publicly visible type or member
	}
}
