/*
    Copyright (C) 2014-2019 de4dot@gmail.com

    This file is part of dnSpy

    dnSpy is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    dnSpy is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with dnSpy.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace dnSpy.Contracts.Disassembly {
	/// <summary>
	/// x86 register
	/// </summary>
	public enum X86Register {
#pragma warning disable CS1591 // Missing XML comment for publicly visible type or member
		None,
		AL,
		CL,
		DL,
		BL,
		AH,
		CH,
		DH,
		BH,
		SPL,
		BPL,
		SIL,
		DIL,
		R8L,
		R9L,
		R10L,
		R11L,
		R12L,
		R13L,
		R14L,
		R15L,
		AX,
		CX,
		DX,
		BX,
		SP,
		BP,
		SI,
		DI,
		R8W,
		R9W,
		R10W,
		R11W,
		R12W,
		R13W,
		R14W,
		R15W,
		EAX,
		ECX,
		EDX,
		EBX,
		ESP,
		EBP,
		ESI,
		EDI,
		R8D,
		R9D,
		R10D,
		R11D,
		R12D,
		R13D,
		R14D,
		R15D,
		RAX,
		RCX,
		RDX,
		RBX,
		RSP,
		RBP,
		RSI,
		RDI,
		R8,
		R9,
		R10,
		R11,
		R12,
		R13,
		R14,
		R15,
		EIP,
		RIP,
		ES,
		CS,
		SS,
		DS,
		FS,
		GS,
		XMM0,
		XMM1,
		XMM2,
		XMM3,
		XMM4,
		XMM5,
		XMM6,
		XMM7,
		XMM8,
		XMM9,
		XMM10,
		XMM11,
		XMM12,
		XMM13,
		XMM14,
		XMM15,
		XMM16,
		XMM17,
		XMM18,
		XMM19,
		XMM20,
		XMM21,
		XMM22,
		XMM23,
		XMM24,
		XMM25,
		XMM26,
		XMM27,
		XMM28,
		XMM29,
		XMM30,
		XMM31,
		YMM0,
		YMM1,
		YMM2,
		YMM3,
		YMM4,
		YMM5,
		YMM6,
		YMM7,
		YMM8,
		YMM9,
		YMM10,
		YMM11,
		YMM12,
		YMM13,
		YMM14,
		YMM15,
		YMM16,
		YMM17,
		YMM18,
		YMM19,
		YMM20,
		YMM21,
		YMM22,
		YMM23,
		YMM24,
		YMM25,
		YMM26,
		YMM27,
		YMM28,
		YMM29,
		YMM30,
		YMM31,
		ZMM0,
		ZMM1,
		ZMM2,
		ZMM3,
		ZMM4,
		ZMM5,
		ZMM6,
		ZMM7,
		ZMM8,
		ZMM9,
		ZMM10,
		ZMM11,
		ZMM12,
		ZMM13,
		ZMM14,
		ZMM15,
		ZMM16,
		ZMM17,
		ZMM18,
		ZMM19,
		ZMM20,
		ZMM21,
		ZMM22,
		ZMM23,
		ZMM24,
		ZMM25,
		ZMM26,
		ZMM27,
		ZMM28,
		ZMM29,
		ZMM30,
		ZMM31,
		K0,
		K1,
		K2,
		K3,
		K4,
		K5,
		K6,
		K7,
		BND0,
		BND1,
		BND2,
		BND3,
		CR0,
		CR1,
		CR2,
		CR3,
		CR4,
		CR5,
		CR6,
		CR7,
		CR8,
		CR9,
		CR10,
		CR11,
		CR12,
		CR13,
		CR14,
		CR15,
		DR0,
		DR1,
		DR2,
		DR3,
		DR4,
		DR5,
		DR6,
		DR7,
		DR8,
		DR9,
		DR10,
		DR11,
		DR12,
		DR13,
		DR14,
		DR15,
		ST0,
		ST1,
		ST2,
		ST3,
		ST4,
		ST5,
		ST6,
		ST7,
		MM0,
		MM1,
		MM2,
		MM3,
		MM4,
		MM5,
		MM6,
		MM7,
		TR0,
		TR1,
		TR2,
		TR3,
		TR4,
		TR5,
		TR6,
		TR7,
#pragma warning restore CS1591 // Missing XML comment for publicly visible type or member
	}
}
