/*
    Copyright (C) 2014-2019 de4dot@gmail.com

    This file is part of dnSpy

    dnSpy is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    dnSpy is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with dnSpy.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace dnSpy.Contracts.BackgroundImage {
	/// <summary>
	/// Image placement
	/// </summary>
	public enum ImagePlacement {
		/// <summary>
		/// Top left corner
		/// </summary>
		TopLeft,

		/// <summary>
		/// Top right corner
		/// </summary>
		TopRight,

		/// <summary>
		/// Bottom left corner
		/// </summary>
		BottomLeft,

		/// <summary>
		/// Bottom right corner
		/// </summary>
		BottomRight,

		/// <summary>
		/// Top
		/// </summary>
		Top,

		/// <summary>
		/// Left
		/// </summary>
		Left,

		/// <summary>
		/// Right
		/// </summary>
		Right,

		/// <summary>
		/// Bottom
		/// </summary>
		Bottom,

		/// <summary>
		/// Center
		/// </summary>
		Center,
	}
}
