/*
 * Decompiled with CFR 0.152.
 */
package lanchon.multidexlib2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import lanchon.multidexlib2.DexFileNameIterator;
import lanchon.multidexlib2.DexFileNamer;
import lanchon.multidexlib2.DexIO;
import lanchon.multidexlib2.DirectoryDexContainer;
import lanchon.multidexlib2.EmptyMultiDexContainerException;
import lanchon.multidexlib2.MultiDexContainerBackedDexFile;
import lanchon.multidexlib2.MultiDexDetectedException;
import lanchon.multidexlib2.RawDexIO;
import lanchon.multidexlib2.SingletonDexContainer;
import lanchon.multidexlib2.ZipFileDexContainer;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.MultiDexContainer;

public class MultiDexIO {
    public static final int DEFAULT_MAX_THREADS = 4;

    private MultiDexIO() {
    }

    public static DexFile readDexFile(boolean multiDex, File file, DexFileNamer namer, Opcodes opcodes, DexIO.Logger logger) throws IOException {
        MultiDexContainer<DexBackedDexFile> container = MultiDexIO.readMultiDexContainer(multiDex, file, namer, opcodes, logger);
        return new MultiDexContainerBackedDexFile<DexBackedDexFile>(container);
    }

    public static MultiDexContainer<DexBackedDexFile> readMultiDexContainer(boolean multiDex, File file, DexFileNamer namer, Opcodes opcodes, DexIO.Logger logger) throws IOException {
        MultiDexContainer<DexBackedDexFile> container = MultiDexIO.readMultiDexContainer(file, namer, opcodes, logger);
        int entries = container.getDexEntryNames().size();
        if (entries == 0) {
            throw new EmptyMultiDexContainerException(file.toString());
        }
        if (!multiDex && entries > 1) {
            throw new MultiDexDetectedException(file.toString());
        }
        return container;
    }

    public static MultiDexContainer<DexBackedDexFile> readMultiDexContainer(File file, DexFileNamer namer, Opcodes opcodes, DexIO.Logger logger) throws IOException {
        MultiDexContainer<DexBackedDexFile> container = MultiDexIO.readMultiDexContainer(file, namer, opcodes);
        if (logger != null) {
            for (String name : container.getDexEntryNames()) {
                logger.log(file, name, container.getEntry(name).getDexFile().getClasses().size());
            }
        }
        return container;
    }

    public static MultiDexContainer<DexBackedDexFile> readMultiDexContainer(File file, DexFileNamer namer, Opcodes opcodes) throws IOException {
        if (file.isDirectory()) {
            return new DirectoryDexContainer(file, namer, opcodes);
        }
        if (!file.isFile()) {
            throw new FileNotFoundException(file.toString());
        }
        if (ZipFileDexContainer.isZipFile(file)) {
            return new ZipFileDexContainer(file, namer, opcodes);
        }
        return new SingletonDexContainer<DexBackedDexFile>(RawDexIO.readRawDexFile(file, opcodes));
    }

    public static int writeDexFile(boolean multiDex, File file, DexFileNamer namer, DexFile dexFile, int maxDexPoolSize, DexIO.Logger logger) throws IOException {
        return MultiDexIO.writeDexFile(multiDex, 1, file, namer, dexFile, maxDexPoolSize, logger);
    }

    public static int writeDexFile(boolean multiDex, int threadCount, File file, DexFileNamer namer, DexFile dexFile, int maxDexPoolSize, DexIO.Logger logger) throws IOException {
        return MultiDexIO.writeDexFile(multiDex, threadCount, file, namer, dexFile, 0, false, maxDexPoolSize, logger);
    }

    public static int writeDexFile(boolean multiDex, File file, DexFileNamer namer, DexFile dexFile, int minMainDexClassCount, boolean minimalMainDex, int maxDexPoolSize, DexIO.Logger logger) throws IOException {
        return MultiDexIO.writeDexFile(multiDex, 1, file, namer, dexFile, minMainDexClassCount, minimalMainDex, maxDexPoolSize, logger);
    }

    public static int writeDexFile(boolean multiDex, int threadCount, File file, DexFileNamer namer, DexFile dexFile, int minMainDexClassCount, boolean minimalMainDex, int maxDexPoolSize, DexIO.Logger logger) throws IOException {
        if (file.isDirectory()) {
            return MultiDexIO.writeMultiDexDirectory(multiDex, threadCount, file, namer, dexFile, minMainDexClassCount, minimalMainDex, maxDexPoolSize, logger);
        }
        if (multiDex) {
            throw new UnsupportedOperationException("Must output to a directory if multi-dex mode is enabled");
        }
        RawDexIO.writeRawDexFile(file, dexFile, maxDexPoolSize, logger);
        return 1;
    }

    public static int writeMultiDexDirectory(boolean multiDex, int threadCount, File directory, DexFileNamer namer, DexFile dexFile, int minMainDexClassCount, boolean minimalMainDex, int maxDexPoolSize, DexIO.Logger logger) throws IOException {
        MultiDexIO.purgeMultiDexDirectory(multiDex, directory, namer);
        DexFileNameIterator nameIterator = new DexFileNameIterator(namer);
        if (threadCount <= 0 && (threadCount = Runtime.getRuntime().availableProcessors()) > 4) {
            threadCount = 4;
        }
        if (threadCount > 1 && multiDex && minMainDexClassCount == 0 && !minimalMainDex) {
            DexIO.writeMultiDexDirectoryMultiThread(threadCount, directory, nameIterator, dexFile, maxDexPoolSize, logger);
        } else {
            DexIO.writeMultiDexDirectorySingleThread(multiDex, directory, nameIterator, dexFile, minMainDexClassCount, minimalMainDex, maxDexPoolSize, logger);
        }
        return nameIterator.getCount();
    }

    public static void purgeMultiDexDirectory(boolean multiDex, File directory, DexFileNamer namer) throws IOException {
        List<String> names = new DirectoryDexContainer(directory, namer, null).getDexEntryNames();
        if (!multiDex && names.size() > 1) {
            throw new MultiDexDetectedException(directory.toString());
        }
        for (String name : names) {
            File existingFile = new File(directory, name);
            if (existingFile.delete()) continue;
            throw new IOException("Cannot delete file: " + existingFile.toString());
        }
    }
}

