/*
 * Decompiled with CFR 0.152.
 */
package lanchon.multidexlib2;

import com.google.common.collect.PeekingIterator;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayDeque;
import java.util.Iterator;

public class BatchedIterator<E>
extends UnmodifiableIterator<E>
implements PeekingIterator<E> {
    private final Iterator<? extends E> iterator;
    private final Object iteratorLock;
    private final int batchSize;
    private final ArrayDeque<E> batch;

    public BatchedIterator(Iterator<? extends E> iterator, Object iteratorLock, int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("batchSize");
        }
        this.iterator = iterator;
        this.iteratorLock = iteratorLock;
        this.batchSize = batchSize;
        this.batch = new ArrayDeque(batchSize);
        this.preloadBatch();
    }

    @Override
    public boolean hasNext() {
        return !this.batch.isEmpty();
    }

    @Override
    public E peek() {
        return this.batch.element();
    }

    @Override
    public E next() {
        E item = this.batch.remove();
        if (this.batch.isEmpty()) {
            this.preloadBatch();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preloadBatch() {
        Object object = this.iteratorLock;
        synchronized (object) {
            for (int n = this.batchSize - this.batch.size(); n > 0 && this.iterator.hasNext(); --n) {
                this.batch.add(this.iterator.next());
            }
        }
    }
}

