/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher.core.patcher;

import lanchon.dexpatcher.core.Action;
import lanchon.dexpatcher.core.PatchException;
import lanchon.dexpatcher.core.PatcherAnnotation;
import lanchon.dexpatcher.core.logger.Logger;
import lanchon.dexpatcher.core.patcher.AnnotatableSetPatcher;
import lanchon.dexpatcher.core.patcher.ClassSetPatcher;
import org.jf.dexlib2.iface.Member;

public abstract class MemberSetPatcher<T extends Member>
extends AnnotatableSetPatcher<T> {
    protected final Action explicitStaticConstructorAction;
    protected final Action resolvedStaticConstructorAction;
    protected final Action explicitDefaultAction;
    protected final Action resolvedDefaultAction;

    public MemberSetPatcher(ClassSetPatcher parent, PatcherAnnotation annotation) {
        super(parent);
        Action defaultAction = Action.NONE;
        Action sca = annotation.getStaticConstructorAction();
        Action da = annotation.getDefaultAction();
        this.explicitStaticConstructorAction = sca;
        this.explicitDefaultAction = da;
        this.resolvedDefaultAction = da != null ? da : defaultAction;
        this.resolvedStaticConstructorAction = sca != null ? sca : this.resolvedDefaultAction;
    }

    @Override
    protected int getAccessFlags(T item) {
        return item.getAccessFlags();
    }

    @Override
    protected Action getDefaultAction(String patchId, T patch) throws PatchException {
        if (this.resolvedDefaultAction == Action.NONE) {
            throw new PatchException("no action defined");
        }
        this.log(Logger.Level.INFO, "default " + this.resolvedDefaultAction.getLabel());
        return this.resolvedDefaultAction;
    }

    @Override
    protected void onPrepare(String patchId, T patch, PatcherAnnotation annotation) throws PatchException {
        if (annotation.getTargetClass() != null) {
            throw PatcherAnnotation.invalidElement("targetClass");
        }
        if (annotation.getStaticConstructorAction() != null) {
            throw PatcherAnnotation.invalidElement("staticConstructorAction");
        }
        if (annotation.getDefaultAction() != null) {
            throw PatcherAnnotation.invalidElement("defaultAction");
        }
        if (annotation.getContentOnly()) {
            throw PatcherAnnotation.invalidElement("contentOnly");
        }
        if (annotation.getRecursive()) {
            throw PatcherAnnotation.invalidElement("recursive");
        }
    }
}

