/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher.core;

import java.util.Locale;
import lanchon.dexpatcher.core.Marker;
import lanchon.dexpatcher.core.PatchException;

public enum Action {
    ADD(Marker.ADD, false),
    EDIT(Marker.EDIT, true),
    REPLACE(Marker.REPLACE, false),
    REMOVE(Marker.REMOVE, true),
    IGNORE(Marker.IGNORE, true),
    WRAP(Marker.WRAP, false),
    PREPEND(Marker.PREPEND, false),
    APPEND(Marker.APPEND, false),
    NONE(null, false);

    private final Marker marker;
    private final String label;
    private final boolean ignoresCode;

    private Action(Marker marker, boolean ignoresCode) {
        this.marker = marker;
        this.label = this.name().toLowerCase(Locale.ROOT);
        this.ignoresCode = ignoresCode;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean ignoresCode() {
        return this.ignoresCode;
    }

    public PatchException invalidAction() {
        return new PatchException("invalid action (" + this.label + ")");
    }
}

