﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Newtonsoft.Json;

namespace DevAudit.AuditLibrary
{
    public enum VulnerabilityReportType
    {
        Bulletin = 0
    }

    public enum VulnerabilityReportCategory
    {
        Software = 0
    }

    [Serializable]
    public struct VulnerabilityCVSS
    {
        public string Score;
        public string Vector;
    }

    public interface IVulnerability
    {
        string Id { get; }

        string Title { get; }

        string Description { get; }

        string Details { get; }

        string[] Versions { get; }
        

        string Reporter { get; }

        VulnerabilityReportType ReportType { get; }

        VulnerabilityReportCategory ReportCategory { get; }

        DateTime Published { get; }

        DateTime Updated { get; }

        string [] CVE { get; }

        VulnerabilityCVSS CVSS { get; }
    
        string[] References { get; }
        
        [JsonIgnore]
        string PackageId { get; }

        [JsonIgnore]
        IPackage Package { get; set; }

        [JsonIgnore]
        bool PackageVersionIsInRange { get; set; }

        [JsonIgnore]
        DataSourceInfo DataSource { get; set; } 
    }
}
