﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Newtonsoft.Json;

namespace DevAudit.AuditLibrary
{
    public class Vulnerability : IVulnerability
    {

        [JsonProperty("id")]
        public string Id { get; set; }

        [JsonProperty("title")]
        public string Title { get; set; }

        [JsonProperty("description")]
        public string Description { get; set; }

        [JsonProperty("details")]
        public string Details { get; set; }

        [JsonProperty("versions")]
        public string[] Versions { get; set; }

        [JsonProperty("references")]
        public string[] References { get; set; }

        [JsonIgnore]
        public string PackageId { get; set; }

        [JsonIgnore]
        public IPackage Package { get; set; }

        [JsonIgnore]
        public bool PackageVersionIsInRange { get; set; }

        [JsonIgnore]
        public string Reporter { get; set; }

        [JsonIgnore]
        public VulnerabilityReportType ReportType { get; set; }

        [JsonIgnore]
        public VulnerabilityReportCategory ReportCategory { get; set; }

        [JsonIgnore]
        public DateTime Published { get; set; }

        [JsonIgnore]
        public DateTime Updated { get; set; }

        [JsonIgnore]
        public string[] CVE { get; set; }

        [JsonIgnore]
        public VulnerabilityCVSS CVSS { get; set; }

        [JsonIgnore]
        public DataSourceInfo DataSource { get; set; }

    }
    


}
