/*  zetaHat.c

This file is part of a program that implements a Software-Defined Radio.

Copyright (C) 2025 Warren Pratt, NR0V

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

The author can be reached by email at

warren@pratt.one

*/

int CzetaRows = 60;
int CzetaCols = 60;
double CzetaGmin = -29.500000;
double CzetaGmax = 30.500000;
double CzetaXimin = -39.500000;
double CzetaXimax = 20.500000;

double CzetaHat [3600] = {
  -2.03586637202129217e-01,  -3.74513652516225259e-01,  -3.10912072833603337e-01,  -2.02514089829728905e-01,
  -1.96721540574476245e-01,  -1.83334244549224173e-01,  -3.15591121929669705e-01,  -4.19011239656620849e-01,
  -3.83225950051984343e-01,  -4.90077276489825908e-01,  -1.23224399520561481e-01,  -2.18995183642650360e-01,
  -2.44499006007930342e-01,  -3.23716509279316556e-01,  -4.14480842106298319e-01,  -3.53906036630249443e-01,
  6.69353908996750818e-02,  -5.20757197350331769e-01,  -2.85217598577517606e-01,  -2.64512279547120921e-01,
  -3.01317005177530628e-01,  -1.39753906243121118e-01,  -1.53146190053132680e-01,  2.06678865974461445e-02,
  7.22624340552971596e-03,  -3.64694169919359060e-02,  -3.86745276452973963e-01,  -1.43847413683609759e-01,
  -3.33795940524580448e-01,  -1.64017344431752504e-01,  -8.98591761906816083e-02,  -5.44390506355757336e-02,
  -3.21820180420339885e-01,  -2.05259883758770016e-02,  -3.61823866242518780e-03,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -3.43026625028106769e-01,  -4.41837767970515549e-01,  -2.44794424708894454e-01,  -4.19242880551506103e-01,
  -2.89056818338569554e-01,  -1.44429672024422973e-01,  -4.43841555719503233e-01,  -2.08065543176464945e-01,
  -4.68782563754421844e-01,  -2.40884015906213500e-01,  -6.41474001868457960e-02,  -2.34966587570113461e-01,
  -2.35708880060973541e-01,  -2.29218577760901376e-01,  -1.55763513226039568e-01,  -4.54936702841693297e-01,
  -1.91060369280391384e-02,  -2.96385986909641908e-01,  -2.56753376378242637e-01,  6.30052915451427276e-02,
  -3.60525495022137488e-01,  -2.90565442231477566e-01,  -4.19539898737542882e-01,  -4.20283869176453551e-01,
  -1.27703135075920210e-01,  -3.31347065563166510e-01,  -2.38767448811413152e-01,  -1.04973848308657414e-01,
  -3.35496018744273206e-01,  -2.06959692612744411e-01,  4.75223854599895260e-02,  -4.05374466338313810e-02,
  -2.45665749878523382e-01,  -1.85356250546644785e-01,  -1.96881995734652815e-01,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -4.05663980874871433e-01,  -5.08596504007602701e-01,  -2.23327336584974501e-01,  -6.09151991097121481e-01,
  -4.61701614400174210e-01,  -5.96564067999124537e-01,  -1.36081351012449364e-01,  -3.32456557404305492e-02,
  -2.69699283466405315e-01,  -4.88832785274213366e-01,  -1.01940224321113493e-01,  -2.70681052608662598e-01,
  -2.81326554708147714e-01,  -4.62526956800600131e-01,  -6.21037715065198892e-01,  -3.09117227409839823e-01,
  -3.02386768799773990e-02,  -4.75591692974957625e-01,  -5.23901978183263117e-01,  -3.80744029512162852e-01,
  -1.77132945934629416e-01,  -3.94807943729320543e-01,  2.96020788550185529e-02,  -2.97631222718801491e-01,
  -4.03583280361576868e-01,  1.19725897568441347e-01,  -2.60698670610781003e-01,  8.10112201961820377e-02,
  -3.60927002636853955e-01,  -1.69194815554610745e-01,  -1.62226620638523250e-01,  1.04862685121180604e-01,
  -3.49399327435537754e-01,  1.68246028348237181e-01,  -1.21608234686013776e-02,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -5.46008135691381513e-01,  -4.20932487567378166e-01,  -1.74037757239389496e-01,  -4.45900069789764986e-01,
  -2.86813956124848835e-01,  -3.93605670202985591e-01,  -2.95337617209159187e-01,  -2.43763908990380085e-01,
  -2.87094225051670149e-01,  -2.61625429212970828e-01,  -1.27249767856424167e-01,  -4.56398477646111578e-01,
  -6.31141210485439919e-01,  -4.66730074622114188e-01,  -7.01967388964013117e-01,  -2.11800988198655338e-01,
  -2.41695210132212235e-01,  -4.13514297328700653e-01,  7.23447999815441389e-02,  -3.05738683056735738e-01,
  -6.55370756102966356e-01,  6.30097586371201196e-02,  -2.30954759138984472e-01,  -1.43524534811897038e-02,
  -4.50243084469947763e-01,  -6.16116122912801156e-01,  -4.67979140963199480e-02,  -5.44951045008942092e-01,
  -4.81006431368447840e-01,  -3.39770792189993287e-01,  5.68677960610191602e-02,  -9.69674941683904001e-02,
  -1.91943309031413378e-01,  7.54481616308360636e-02,  -1.80962342175786217e-01,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -4.30207474526817402e-01,  -3.82935483404385268e-01,  -4.05440701559784289e-01,  -5.40448528084966684e-01,
  -7.36633865372883445e-01,  -4.16280358576189058e-01,  -5.50687956336490703e-01,  -7.84482672271953785e-01,
  -6.81739314130963669e-01,  -6.92645976645394179e-01,  -6.33207200495535388e-02,  -5.99059920455478512e-01,
  -7.05462619710816030e-01,  -1.40388063703966365e-01,  -7.60828578112932696e-01,  -2.43259700793006073e-01,
  -5.40063062750276046e-01,  -1.73478751614518534e-01,  -1.66463565981988970e-01,  -1.21714140776476382e-01,
  -6.43758521710543485e-01,  -5.90881376960995408e-01,  -9.00702797172454717e-01,  -1.20745929226168239e-01,
  -1.61004412504959449e-01,  -4.21451922663160783e-01,  -1.17293806976317153e-01,  -7.38231717379641550e-01,
  -8.61037622448621032e-02,  -1.24329706976649967e-01,  -6.87878304890387149e-01,  -2.75013854102278799e-01,
  -6.08657829896620317e-01,  -1.95179430676514741e-02,  -3.22098674298622267e-01,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -9.78309564979222723e-01,  -5.73804218324510451e-01,  -6.16337594977246939e-01,  -6.52573856809588682e-01,
  -9.81841094555006677e-01,  -9.89789114694680783e-01,  -3.23337837993433075e-01,  -5.88972260767107958e-01,
  -1.09263439225403181e+00,  -9.41969641862428042e-01,  -2.26997410810778899e-01,  -2.65577010654932777e-01,
  -2.37947500733123068e-01,  -5.13705251675084740e-01,  -1.17496561767136243e-01,  -1.52755181611505086e-01,
  -9.80241667139695738e-01,  -5.72992217676003168e-01,  -9.75905652887135044e-01,  -7.53340851451943738e-01,
  -7.11884093415761532e-01,  -1.40669487748549871e-01,  -9.56984165567899892e-01,  -6.65893540430322117e-01,
  -9.26787162149682819e-01,  -1.86166957102581854e-01,  -8.83555630722454355e-01,  -7.11765358630709555e-01,
  -1.59328624186991369e-01,  -2.79516161546319530e-01,  -9.17001572030259754e-02,  -6.99927392834704731e-01,
  7.80176124970044932e-02,  -2.63736192235998201e-01,  -1.13897980934033610e-01,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -4.58251174132302985e-01,  -8.27651255233297967e-01,  -6.97532582165095838e-01,  -7.30937836803348118e-01,
  -5.08200291256772019e-01,  -4.17782947295167961e-01,  -1.10107487175687768e+00,  -3.92775602812572844e-01,
  -5.25394412306004366e-01,  -1.09109774394639447e+00,  -1.18146714618582438e+00,  -8.81054024980158168e-01,
  -1.10779877843047747e+00,  -3.30605582842255996e-01,  -4.19062700313867498e-01,  -9.69052724496046958e-01,
  -9.41736379568535176e-01,  -9.19137719655360730e-01,  -8.02537033257745502e-01,  -9.60426895012608917e-01,
  -7.61597230622857446e-01,  -3.09136044566366786e-01,  -9.44327086096540674e-02,  -2.03258528298724400e-01,
  -9.03316642144642579e-01,  -1.00005014807177517e+00,  -2.27147256602628411e-01,  -1.95646343734641875e-01,
  -1.75215774865480872e-01,  -3.28489435388724882e-01,  -3.57198783236158668e-01,  -3.10716376284873697e-01,
  -2.52750354970300628e-01,  -3.65599404400778982e-01,  -5.80359105752613624e-02,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.23470237835722685e+00,  -9.16346551914667184e-01,  -9.89753622109721620e-01,  -1.20171388353303987e+00,
  -1.03436662381742916e+00,  -1.03892500277584787e+00,  -4.06327734250000516e-01,  -9.75071984754323773e-01,
  -6.60148524095720446e-01,  -6.71135266214319293e-01,  -1.08297829617561026e+00,  -7.71714172216880989e-01,
  -1.01585357828448752e+00,  -6.42457185048168844e-01,  -1.00710614754980021e+00,  -8.83576294396519524e-01,
  -9.36473655737500743e-01,  -1.23681953973992442e+00,  -4.17582967989990173e-01,  -9.97667081219759777e-01,
  -1.13941336399177073e+00,  -9.04600657504889827e-01,  -9.00044600658669092e-01,  -1.07351804836993114e+00,
  -1.00368480892204048e+00,  -8.82459058643937144e-01,  -8.02661054597498369e-01,  -2.53331255935923871e-01,
  -9.87239402632500540e-01,  -1.15968370678822663e+00,  -3.64899213958825186e-01,  -2.81129324628636879e-01,
  -5.54295618250514543e-01,  -1.24403644677204578e-01,  -4.50939577790144375e-01,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -7.16644192555237924e-01,  -1.16969911634946699e+00,  -1.06267906369783516e+00,  -1.22907586382969392e+00,
  -1.51543829870238200e+00,  -1.06382774356608989e+00,  -6.88275081438620817e-01,  -1.23459332755108941e+00,
  -1.02300814526068606e+00,  -1.31210919506976120e+00,  -6.03693242639680716e-01,  -1.18604837404557450e+00,
  -9.31791672529138193e-01,  -9.09508125041009974e-01,  -1.01694635598489946e+00,  -5.11734421167512887e-01,
  -1.03668826442054929e+00,  -9.46148652708034388e-01,  -9.75995555407703330e-01,  -1.00721625826631267e+00,
  -9.25948159322725339e-01,  -4.95163017188046450e-01,  -9.14140779477971233e-01,  -9.23281430926198743e-01,
  -1.14355544623799332e+00,  -9.92850378196018291e-01,  -9.76591734740977380e-01,  -1.01752339855400131e+00,
  -7.34148561614327955e-01,  -1.06720994552417259e+00,  -8.87996303592176850e-01,  -9.93686570834118266e-01,
  -8.55614777808491739e-02,  -1.64153484348257862e-02,  -9.66740698047014735e-02,  -4.69523335743374037e+00,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -9.03119727289825036e-01,  -1.52268078226810255e+00,  -1.58046906322891001e+00,  -1.18823872862376190e+00,
  -1.18952633673543406e+00,  -1.14175250041327248e+00,  -9.60360515380926705e-01,  -1.20816184248514280e+00,
  -1.13445377453675200e+00,  -1.28500911072835411e+00,  -1.03402196613919406e+00,  -1.26828493992170621e+00,
  -9.34888267621509339e-01,  -9.58911147878165337e-01,  -1.08486122934341989e+00,  -1.18456993010818445e+00,
  -1.03676803716716148e+00,  -1.32727892196624153e+00,  -1.39228148676872610e+00,  -8.96819221804580180e-01,
  -1.37144021033432728e+00,  -1.01153714403702000e+00,  -8.90741607358260690e-01,  -8.87810140456340546e-01,
  -1.09437983892681934e+00,  -9.76307967642066621e-01,  -1.03583525137587662e+00,  -1.11480094956126141e+00,
  -1.31878788509640832e+00,  -1.00507783363046355e+00,  -6.07566014320830683e-01,  -9.89004203524131875e-01,
  -1.14371640296255128e+00,  -4.42191065609140121e-01,  6.77810238188832903e-02,  -2.49688278530586089e-01,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.44410981522473891e+00,  -1.09777622116258011e+00,  -1.17559504449178798e+00,  -1.20236809580046167e+00,
  -1.85600540725902885e+00,  -9.45717170769021620e-01,  -1.09520302439535899e+00,  -9.82650673614276049e-01,
  -1.31771109809336506e+00,  -9.96764685904952263e-01,  -1.11470112244976516e+00,  -1.03127996147587675e+00,
  -9.99192045796723827e-01,  -9.98001254299681229e-01,  -8.83338875336172169e-01,  -1.12598162352346343e+00,
  -1.13314614314138762e+00,  -1.01978017083878902e+00,  -1.39955814859240668e+00,  -9.20486260466576001e-01,
  -1.09227865506985178e+00,  -9.53515538338011281e-01,  -1.12418619229905392e+00,  -1.07521266089494061e+00,
  -1.17571726002984422e+00,  -1.00880444669874203e+00,  -9.23848326637915607e-01,  -9.80069277570667197e-01,
  -8.82275777866263988e-01,  -8.82919953145279268e-01,  -9.05077415469414559e-01,  -4.75636835125901936e-01,
  -9.32860539748072481e-01,  -1.11586027621794859e+00,  1.96291731693169283e-02,  3.34217274943639786e-01,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -2.21414750338983080e+00,  -2.24980930591399497e+00,  -1.22962603774134704e+00,  -2.20942412255468223e+00,
  -1.54782627513431503e+00,  -2.17623243619385942e+00,  -2.12426441612679806e+00,  -1.17663438220891647e+00,
  -1.11451612667883770e+00,  -2.20042441344955497e+00,  -1.02649012081534341e+00,  -2.17992831180674873e+00,
  -2.21921107631713888e+00,  -2.17487429441468372e+00,  -2.14020670061804807e+00,  -1.01017348656365491e+00,
  -1.14679279395659073e+00,  -9.00045814154730950e-01,  -1.21640496212086036e+00,  -1.16453064280398744e+00,
  -9.18102395129032911e-01,  -9.04910736653454784e-01,  -9.35406437835217153e-01,  -8.98572135611654832e-01,
  -1.05833234614114824e+00,  -9.27359254659170795e-01,  -9.26813581766552375e-01,  -9.32494603105608277e-01,
  -9.37344925482572089e-01,  -9.37132541785426154e-01,  -1.12550098583593394e+00,  -9.59186509761312256e-01,
  -1.26393766806796126e+00,  -1.24571432151466865e+00,  -3.92228051750754148e-01,  -2.39753468215489041e-01,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -2.32022842130792739e+00,  -2.15343192822075391e+00,  -1.44788840250041928e+00,  -2.39435948222556005e+00,
  -2.34970767062629760e+00,  -2.14522430465220859e+00,  -2.20910044253917448e+00,  -2.30150106058798132e+00,
  -2.20055192804390654e+00,  -2.18949642783847942e+00,  -2.13068841308622670e+00,  -2.13562937296413580e+00,
  -2.16063278375867185e+00,  -2.16253732276251265e+00,  -2.22702749002286060e+00,  -2.15899666777299482e+00,
  -2.20715021468578865e+00,  -2.15739835823265036e+00,  -1.06822805397627407e+00,  -2.15718490475340907e+00,
  -2.24250274146351636e+00,  -2.14060246983051528e+00,  -2.19828688148151885e+00,  -2.14970759212012830e+00,
  -8.95930894473662254e-01,  -9.56319335554949301e-01,  -9.61931923368229858e-01,  -9.03165797872540477e-01,
  -9.23258896207339030e-01,  -9.34036911288597782e-01,  -9.27830645340437021e-01,  -8.88977033191857280e-01,
  -1.29639615709240053e+00,  -9.71721923182277680e-01,  -1.72715818400771381e-01,  -4.57718931859056932e-01,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -2.41097489973598655e+00,  -2.71408072361926100e+00,  -2.15171730726914845e+00,  -2.59921664546940834e+00,
  -2.29239789428981222e+00,  -2.24523684380405042e+00,  -2.16840460957451553e+00,  -2.42901120286567096e+00,
  -2.19267272258299073e+00,  -2.15825260677069375e+00,  -2.22079220085915230e+00,  -2.19458666271132419e+00,
  -2.19604827156939209e+00,  -2.13188263271858336e+00,  -2.15957917097155461e+00,  -2.20718295087804117e+00,
  -2.14643436092307116e+00,  -2.28300233319161006e+00,  -2.20511129794860716e+00,  -2.23732474972647211e+00,
  -2.21210289511989444e+00,  -2.13260324641569676e+00,  -2.13983121719960501e+00,  -2.13176320665843599e+00,
  -2.19988898375502195e+00,  -2.16115844694965142e+00,  -2.17362750438705854e+00,  -2.19088730848580093e+00,
  -2.21103806266353287e+00,  -2.20752865344512506e+00,  -8.93757718002068380e-01,  -9.22674278614298404e-01,
  -9.72382993039457411e-01,  -9.74423313643622224e-01,  -9.77745991731754471e-01,  -3.86973372228818890e-01,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -2.34514992248163612e+00,  -2.34239244375991040e+00,  -2.20535031641060231e+00,  -2.18937247416020098e+00,
  -2.13099613640175800e+00,  -2.37056799011117159e+00,  -2.14512631390479447e+00,  -2.14478993061903100e+00,
  -2.17488910765979826e+00,  -2.13305726591075118e+00,  -2.17794646483161314e+00,  -2.19959346725365723e+00,
  -2.14013940848417450e+00,  -2.18437998953563062e+00,  -2.15287121810403459e+00,  -2.15266646452401211e+00,
  -2.36637337961029726e+00,  -2.18005191583060132e+00,  -2.16426504407623010e+00,  -2.20530446938373137e+00,
  -2.22473434257278280e+00,  -2.18421817397584750e+00,  -2.14815219756341369e+00,  -2.14447575129482093e+00,
  -2.14787479181826191e+00,  -2.13058902085446222e+00,  -2.13824034363792848e+00,  -2.15187530936115712e+00,
  -2.16655113629857077e+00,  -2.15504495156767373e+00,  -2.15415024382749198e+00,  -2.15957829548493807e+00,
  -9.02872093840860646e-01,  -9.18271954033000881e-01,  -9.45965036545576510e-01,  -6.11939302620114978e-01,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -2.39831554413756320e+00,  -2.14811669258283722e+00,  -2.52944477171595050e+00,  -2.42586075225679032e+00,
  -2.35197105182115118e+00,  -2.18838248260898371e+00,  -2.13381517665081821e+00,  -2.13084497947480633e+00,
  -2.17222853709929486e+00,  -2.17146037445237461e+00,  -2.14704368222318909e+00,  -2.17564289444690262e+00,
  -2.13955852341234509e+00,  -2.14127946179393414e+00,  -2.28022784032565973e+00,  -2.13536155768222358e+00,
  -2.14661937563494476e+00,  -2.14513003430811766e+00,  -2.13125440176096070e+00,  -2.14385826465800999e+00,
  -2.17842630366439938e+00,  -2.19611770100740378e+00,  -2.14151880959605290e+00,  -2.13738854127174704e+00,
  -2.23470194698913627e+00,  -2.13917587499667849e+00,  -2.13934279617572365e+00,  -2.16016935820688172e+00,
  -2.17354219860011089e+00,  -2.14141692293505548e+00,  -2.13782934150257464e+00,  -2.20801604354584668e+00,
  -2.15406497241356565e+00,  -9.05324096043551685e-01,  -1.00575454657810615e+00,  -4.73889902332771451e-01,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -3.89127685875566343e+00,  -3.96955161368255594e+00,  -4.01809493322431166e+00,  -4.04505904067297095e+00,
  -3.91438485477371412e+00,  -3.90972127795284274e+00,  -3.94149925836595827e+00,  -3.95100732595248205e+00,
  -3.90399000129258233e+00,  -3.95514858389295165e+00,  -3.92400453429569751e+00,  -3.93916245350105232e+00,
  -3.94835140168886145e+00,  -2.15843364518092340e+00,  -3.89983326631420191e+00,  -2.22628059249309729e+00,
  -2.17317396837313614e+00,  -2.17786720385308952e+00,  -2.19259737301252189e+00,  -2.18925685227577871e+00,
  -2.16416832268473236e+00,  -2.13383316691593050e+00,  -2.14182317111031395e+00,  -2.15981330288264983e+00,
  -2.19567828484866823e+00,  -2.14164694534240541e+00,  -2.13329149379600391e+00,  -2.27241679077867520e+00,
  -2.19112342670729054e+00,  -2.18681171537119390e+00,  -2.13585915730240128e+00,  -2.26789005097751195e+00,
  -2.14269420146462508e+00,  -2.14522127676683727e+00,  -8.94222595091157979e-01,  -3.09586881709224236e-02,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -3.89320032998493337e+00,  -3.97894484153212202e+00,  -3.90331400300916620e+00,  -3.89114542212317538e+00,
  -3.90793694607716446e+00,  -3.91144639800373106e+00,  -3.90101425359726317e+00,  -3.90617492185243442e+00,
  -3.90315562354730039e+00,  -3.90072798841646540e+00,  -3.91799014298433868e+00,  -4.01981580800890725e+00,
  -3.89434880133566574e+00,  -3.91679220064647771e+00,  -3.95130289541396262e+00,  -3.93392931371595145e+00,
  -3.89992438135526864e+00,  -3.99349663746360717e+00,  -3.91669392212704182e+00,  -3.90652929710136698e+00,
  -3.90405686413285880e+00,  -3.91518612334822036e+00,  -2.16151557294707430e+00,  -3.92094475759819039e+00,
  -2.15098457702713697e+00,  -2.14659441398098494e+00,  -2.18103576689835776e+00,  -2.13625630939429456e+00,
  -2.13758995265880625e+00,  -2.18507800743320235e+00,  -2.13393491522376078e+00,  -2.13213652851725488e+00,
  -2.15424504500606417e+00,  -2.14641151331682112e+00,  -8.86470695059124125e-01,  -9.14559455700468815e-01,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -3.89339126966057503e+00,  -3.92848979374259777e+00,  -4.10332979420790522e+00,  -3.98280302515349316e+00,
  -3.91339833154021743e+00,  -3.92884464279264778e+00,  -3.90110909447575605e+00,  -3.99854215288867065e+00,
  -3.89212882556993156e+00,  -3.91240304328765331e+00,  -3.94580797547814743e+00,  -3.92798403302833776e+00,
  -3.92217521401399205e+00,  -3.89153477274840887e+00,  -3.89655760079143754e+00,  -3.90023309424730957e+00,
  -3.92133477897687888e+00,  -3.91646569971066505e+00,  -3.90653330530226484e+00,  -3.92101191353326284e+00,
  -3.89929632101701173e+00,  -3.89705148456233319e+00,  -3.90727706281003861e+00,  -3.90428232949440845e+00,
  -3.89504661602998459e+00,  -3.91111120153244940e+00,  -3.89722712501802793e+00,  -3.94079934137627363e+00,
  -3.91208117430265201e+00,  -3.89198754398445024e+00,  -2.15177791572873112e+00,  -2.15954651276550491e+00,
  -2.13670665012690719e+00,  -2.19897114171490937e+00,  -2.15175449380553196e+00,  -9.91723289099453842e-01,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -3.92844643671696758e+00,  -3.89332055211530426e+00,  -3.91225225804529320e+00,  -3.91518810870420664e+00,
  -3.90240195160924275e+00,  -3.89864690849834439e+00,  -3.91383512058859351e+00,  -3.90814946414763442e+00,
  -3.91939065281054777e+00,  -3.90410201826216818e+00,  -3.91076342662912957e+00,  -3.90672466900439952e+00,
  -3.91648576237094481e+00,  -3.90337471668583014e+00,  -3.89865547661784939e+00,  -3.89368784111816257e+00,
  -3.90498146799847223e+00,  -3.95884305846317952e+00,  -3.89383566338405362e+00,  -3.91021191756797437e+00,
  -3.89176602685684658e+00,  -3.93751404298505747e+00,  -3.97882119504105880e+00,  -3.89848687092434476e+00,
  -3.89281629057341227e+00,  -3.91247865850224574e+00,  -3.90237013331514904e+00,  -3.90221917572475618e+00,
  -3.91689807837160142e+00,  -3.89377062456699097e+00,  -3.89219604579466960e+00,  -2.13633313497032962e+00,
  -2.13353214523184853e+00,  -2.13834809215811639e+00,  -2.13428746974826966e+00,  -9.24875336889416921e-01,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -3.92288674655520131e+00,  -3.90071914121825891e+00,  -3.89325145586123122e+00,  -3.89760255009505041e+00,
  -3.91209045852281001e+00,  -3.92079697810947980e+00,  -3.89879903131989636e+00,  -3.97574079381386047e+00,
  -4.02535081101692960e+00,  -3.94405152611311971e+00,  -3.92180380985832633e+00,  -3.90317823994182245e+00,
  -3.96259409599587187e+00,  -4.00348138909903106e+00,  -3.96800964893842467e+00,  -3.89701245408189223e+00,
  -3.95614614422177091e+00,  -3.89887308015417133e+00,  -3.90226327194256095e+00,  -3.90249072447782819e+00,
  -3.95447061944557765e+00,  -3.89618632533548404e+00,  -3.89222103981421830e+00,  -3.97539821273832983e+00,
  -3.89345868191619271e+00,  -3.94418372748388579e+00,  -3.91973351763018929e+00,  -3.89344384053350190e+00,
  -3.92675150184130217e+00,  -3.89629919755529652e+00,  -3.89578066654904420e+00,  -3.90817780651619540e+00,
  -3.91327165733160687e+00,  -2.16349703950085948e+00,  -2.13284229290711291e+00,  -9.30815021082745719e-01,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -3.90752740267774668e+00,  -3.90640719494137878e+00,  -3.90658142220317428e+00,  -3.95592258167720523e+00,
  -3.89458668261022911e+00,  -3.89936126974746244e+00,  -3.92180705323626277e+00,  -3.89676748846706822e+00,
  -3.89381930754901351e+00,  -3.89464380981244807e+00,  -3.90472270805577404e+00,  -3.90962501924824579e+00,
  -3.91706546249382015e+00,  -3.92174386649551643e+00,  -3.90079059366076830e+00,  -3.90971456185082822e+00,
  -3.89880032765510709e+00,  -3.89730755033850640e+00,  -3.91059480170492169e+00,  -3.91454297479941937e+00,
  -3.89252153399396583e+00,  -3.89683339453334154e+00,  -3.89358607740801377e+00,  -3.91978695411199940e+00,
  -3.91295995475736991e+00,  -3.89118678275728103e+00,  -3.92045740216783134e+00,  -3.89804174891919830e+00,
  -3.90153587760519116e+00,  -3.91439764700030102e+00,  -3.89777904032877975e+00,  -3.90786398411349323e+00,
  -3.91588522416697726e+00,  -3.90652535385563837e+00,  -2.14103558649934866e+00,  -2.14822308882326363e+00,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -6.90330547014431595e+00,  -6.90715941960745106e+00,  -6.91028025263481194e+00,  -6.97510607787187897e+00,
  -6.90419465739991267e+00,  -6.91802370419782875e+00,  -6.96172979019172367e+00,  -6.90252747243968301e+00,
  -6.96359571162381208e+00,  -6.92049050057351600e+00,  -6.92223545450687716e+00,  -6.92996870097226392e+00,
  -6.92205862862647514e+00,  -6.90374367517952336e+00,  -6.90635743128792612e+00,  -3.94139772252161258e+00,
  -3.91471920086002800e+00,  -3.89599586168197209e+00,  -3.95833130863973892e+00,  -3.91250994956689002e+00,
  -3.93347154720467485e+00,  -3.90498685846566929e+00,  -3.90707289072499986e+00,  -3.91181827531769999e+00,
  -3.93724149831423720e+00,  -3.89368810457462278e+00,  -3.90226954797597125e+00,  -3.90863086032607310e+00,
  -3.89261186896806421e+00,  -3.89444631841460076e+00,  -3.92460136870951048e+00,  -3.92343983062314328e+00,
  -3.89204690769315054e+00,  -3.89246685360537015e+00,  -3.90518683426672375e+00,  -2.13917910810203216e+00,
  -8.82940222521890750e-01,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -6.92453876270973367e+00,  -6.90377753105607095e+00,  -6.91490320835942995e+00,  -6.90310177423140292e+00,
  -6.90815859643799079e+00,  -6.90894907963228722e+00,  -6.90878217947895124e+00,  -6.93448815418855169e+00,
  -6.96364529767862628e+00,  -6.96036648178132111e+00,  -6.92895118576246460e+00,  -6.91758553875015725e+00,
  -6.91480205121115254e+00,  -6.91058265859690124e+00,  -6.92882709951765641e+00,  -6.90929030284607926e+00,
  -6.90222769058763141e+00,  -6.90793533435807916e+00,  -6.90137530035294322e+00,  -6.91069023005292404e+00,
  -6.90830324608631496e+00,  -3.92340116063579947e+00,  -3.89436683809935014e+00,  -3.89587185292435123e+00,
  -3.89230942455777429e+00,  -3.91243682395468850e+00,  -3.90073558650050245e+00,  -3.89200405096202795e+00,
  -3.90428644814010672e+00,  -3.90982227511740188e+00,  -3.91687296155158338e+00,  -3.90706653739700149e+00,
  -3.89545235598368045e+00,  -3.90001474685804217e+00,  -3.90112750886654647e+00,  -2.14478392578385257e+00,
  -9.23173642369846892e-01,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -6.92123771446870251e+00,  -6.90417447738833179e+00,  -6.94515258384258782e+00,  -6.90540099055085221e+00,
  -6.90093126510473720e+00,  -6.91873994793513525e+00,  -6.90437655221847724e+00,  -6.91134219329495014e+00,
  -6.93470929485573873e+00,  -6.90723295120739600e+00,  -6.91785731498680789e+00,  -6.90119758352722634e+00,
  -6.91697138143118639e+00,  -6.94081659546700447e+00,  -6.91553260030808481e+00,  -6.93024652462740320e+00,
  -6.91512767474665146e+00,  -6.92486962004984630e+00,  -6.91471480406974948e+00,  -6.90984427585602656e+00,
  -6.93486227281562595e+00,  -6.94001447077350875e+00,  -6.90507031699895357e+00,  -6.90185527111198027e+00,
  -6.94280329563032961e+00,  -6.94599054492865964e+00,  -6.90864847182456288e+00,  -3.91126609802399594e+00,
  -3.90064581280086209e+00,  -3.91656987573009907e+00,  -3.89325404977358769e+00,  -3.89301061597444686e+00,
  -3.89723858974909243e+00,  -3.91756249993555272e+00,  -3.89410886899874864e+00,  -3.89498145469086587e+00,
  -2.13280732712260868e+00,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -6.90531809079295478e+00,  -6.91547359140259665e+00,  -6.90824222758607931e+00,  -6.90906674508336227e+00,
  -6.92912738616346680e+00,  -6.90182265405782935e+00,  -6.93685610769532879e+00,  -6.92470632032631261e+00,
  -6.96066176710234519e+00,  -6.90284665621990445e+00,  -6.92003513044366692e+00,  -6.91591616320292424e+00,
  -6.90237995932514714e+00,  -6.91939129243382567e+00,  -6.98548425745911938e+00,  -6.91889542380735723e+00,
  -6.91113249428584542e+00,  -6.94736693620683532e+00,  -6.90909929268395562e+00,  -6.91927628852462195e+00,
  -6.93657944355788292e+00,  -6.90291012270555981e+00,  -6.93660164934778400e+00,  -6.91689261133366795e+00,
  -6.90280458320145129e+00,  -6.92899573681595982e+00,  -6.90180094245353004e+00,  -6.90686043104754432e+00,
  -6.90570590433619103e+00,  -6.90148810365229348e+00,  -6.90404896544744417e+00,  -6.90827781915728067e+00,
  -3.90476818726618724e+00,  -3.89524751766033850e+00,  -3.90196546546982326e+00,  -3.89208750025559658e+00,
  -2.13599258602894793e+00,  4.12037737759721606e-02,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -6.94374739248130179e+00,  -6.93819697976274519e+00,  -6.91049448381494180e+00,  -6.93156298904440149e+00,
  -6.90984534226381530e+00,  -6.90190718756656718e+00,  -6.91317226927008921e+00,  -6.90635760449199765e+00,
  -6.90033947908102352e+00,  -6.90988424244844524e+00,  -6.96170759431130382e+00,  -6.94106039381997686e+00,
  -6.90140751504273897e+00,  -6.92872681022882109e+00,  -6.90617123737715843e+00,  -6.90715813776191823e+00,
  -6.90850669112977478e+00,  -6.90358025359777638e+00,  -6.95858365940724966e+00,  -6.91720978927095764e+00,
  -6.90343015550450012e+00,  -6.90602538615443873e+00,  -6.91773868070671316e+00,  -6.90143793546156203e+00,
  -6.91174278007362730e+00,  -6.90231839365532540e+00,  -6.90215388856861800e+00,  -6.93032729303785988e+00,
  -6.90095396150499951e+00,  -6.92728290337643493e+00,  -6.90163507905430684e+00,  -6.90133679812084289e+00,
  -6.91386403104635683e+00,  -6.91006523734884670e+00,  -3.89754654670970258e+00,  -3.90172108262381956e+00,
  -3.90245866621201731e+00,  -2.13383556150349474e+00,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -6.93657608539886361e+00,  -6.91285704836863157e+00,  -6.91117798298281194e+00,  -6.90316569088987997e+00,
  -6.90784764541551688e+00,  -6.92305746432737568e+00,  -6.90189991907342648e+00,  -6.90459926624819786e+00,
  -6.91600909263589791e+00,  -6.92604927359402822e+00,  -6.90299965403732951e+00,  -6.90125926566729664e+00,
  -6.90344458389016236e+00,  -6.91901468580440238e+00,  -6.92077290257361444e+00,  -6.92659469843382336e+00,
  -6.90138787343366289e+00,  -6.92776100582623933e+00,  -6.90804454873826224e+00,  -6.90671827801994098e+00,
  -6.90095095424543992e+00,  -6.90199733944876392e+00,  -6.90029168645579194e+00,  -6.90105188307956574e+00,
  -6.90501281914422194e+00,  -6.90352479938255392e+00,  -6.91126569405054880e+00,  -6.90494638999158994e+00,
  -6.91201254078618010e+00,  -6.90146692394740668e+00,  -6.90117658692509472e+00,  -6.90163003326663027e+00,
  -6.90368697076172655e+00,  -6.90282408007923109e+00,  -6.91173644110896124e+00,  -6.90312944667263118e+00,
  -3.90212649474728446e+00,  -3.89573668644672688e+00,  -8.86699986624638892e-01,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -6.90477779722017715e+00,  -6.90125373927193220e+00,  -6.95296541518631628e+00,  -6.90853550518205495e+00,
  -6.90840221775042806e+00,  -6.90334453277800364e+00,  -6.91772002491771154e+00,  -6.90402527946951494e+00,
  -6.94295750194843464e+00,  -6.90483302620595740e+00,  -6.90265518685359503e+00,  -6.92327579521772041e+00,
  -6.90312265830887917e+00,  -6.90369833709955394e+00,  -6.90260111556544320e+00,  -6.90683470327086457e+00,
  -6.90955852158790940e+00,  -6.92050221973063984e+00,  -6.90609304532067814e+00,  -6.90101164242500076e+00,
  -6.90715479202558402e+00,  -6.90331275203463690e+00,  -6.90454251031432076e+00,  -6.91251267654820367e+00,
  -6.90498346559710185e+00,  -6.90716184478112982e+00,  -6.90367097255044726e+00,  -6.91106542220110587e+00,
  -6.90348418514615858e+00,  -6.90063530677933468e+00,  -6.92194585560696130e+00,  -6.90807952516676949e+00,
  -6.91396208924341149e+00,  -6.91498362617981144e+00,  -6.90579604944717484e+00,  -6.90264565392730400e+00,
  -6.90538322824214923e+00,  -3.89804190050908339e+00,  -2.14248132951880210e+00,  7.23354083009378090e-01,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -6.90055550211981394e+00,  -6.91644118813437547e+00,  -6.90242292176143746e+00,  -6.92076000840881722e+00,
  -6.90271680483109584e+00,  -6.91197291985252260e+00,  -6.90643317838741311e+00,  -6.90278650430382701e+00,
  -6.91013348928828464e+00,  -6.90372218812784944e+00,  -6.90368003643080641e+00,  -6.93456264091414010e+00,
  -6.90338018341665460e+00,  -6.90495075229576294e+00,  -6.90904390796895473e+00,  -6.90347622248854442e+00,
  -6.91948061453827634e+00,  -6.90764008831372500e+00,  -6.90456442971446460e+00,  -6.90072742989616117e+00,
  -6.91233569273523329e+00,  -6.90466000171333150e+00,  -6.90376708205566736e+00,  -6.90391147134541328e+00,
  -6.90161695834030553e+00,  -6.90468529897592997e+00,  -6.90897110464030106e+00,  -6.90289584418275659e+00,
  -6.90346730537398656e+00,  -6.90208168249592546e+00,  -6.92183141892397558e+00,  -6.92680482334952696e+00,
  -6.90079682935025662e+00,  -6.90094650776039487e+00,  -6.90841674230961011e+00,  -6.92517718788663927e+00,
  -6.90737685724652462e+00,  -6.91536951787473075e+00,  -3.89260820535829621e+00,  -2.13437113618473351e+00,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -6.90644474944379638e+00,
  -6.90234982685449339e+00,  -6.90725722887147153e+00,  -6.90094747821726973e+00,  -6.90740191379689072e+00,
  -6.91633154162916153e+00,  -6.92567369586384984e+00,  -6.90211495061131419e+00,  -6.90299323816851462e+00,
  -6.90313048080237479e+00,  -6.90099082751336468e+00,  -6.90077040724970736e+00,  -6.90104552534091109e+00,
  -6.90302805420436805e+00,  -6.90341705781373527e+00,  -6.90075603452536246e+00,  -6.90055761423452463e+00,
  -6.90390719108376327e+00,  -6.90791253718290044e+00,  -6.90098418091016885e+00,  -6.90484184293629877e+00,
  -6.90034454034965883e+00,  -6.90068418954811502e+00,  -6.90043133274401299e+00,  -6.90151448738509821e+00,
  -6.90028526883972404e+00,  -6.91256303240346170e+00,  -6.90982565423693185e+00,  -3.89898178542389484e+00,
  -8.83814810544191753e-01,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -6.91950209598397592e+00,  -6.90324313691266145e+00,  -6.90105828526799137e+00,  -6.90462101058939837e+00,
  -6.90409532085652522e+00,  -6.90755539681897535e+00,  -6.90209687091082191e+00,  -6.90403295718748744e+00,
  -6.90088969145293962e+00,  -6.90173528488505461e+00,  -6.90170850953090032e+00,  -6.90438729350658775e+00,
  -6.90610251934289288e+00,  -6.90532396277513261e+00,  -6.90100237068446987e+00,  -6.90311781731404750e+00,
  -6.90150766593605347e+00,  -6.90271390616758396e+00,  -6.91132622012150666e+00,  -6.90369752848203788e+00,
  -6.90259771848733727e+00,  -6.90072272373535878e+00,  -6.90303053312493553e+00,  -6.90270032011343559e+00,
  -3.89271898286531393e+00,  -8.86277868747912811e-01,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -6.90082108231783664e+00,
  -6.90196617108079913e+00,  -6.90337322526344188e+00,  -6.90262542016783964e+00,  -6.90447155174484450e+00,
  -6.90200731639061438e+00,  -6.90332316122887413e+00,  -6.90211940156480264e+00,  -6.90698876359559222e+00,
  -6.90032067463548238e+00,  -6.90353973443349922e+00,  -6.90115930714009362e+00,  -6.90345023736129626e+00,
  -6.91114568545650165e+00,  -6.90092445364002316e+00,  -6.90272193245667154e+00,  -6.90054814794657290e+00,
  -6.90283293610687743e+00,  -6.90030575724163064e+00,  -6.90307408969188252e+00,  -6.90278902785437154e+00,
  -6.90033714138974297e+00,  -3.89137022815722267e+00,  -8.81543554718397848e-01,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -6.91779055186497693e+00,  -6.90047107927685399e+00,  -6.90365171330360372e+00,
  -6.90163796972261068e+00,  -6.90967300399700157e+00,  -6.90789479451722244e+00,  -6.90711085599922647e+00,
  -6.90036571740898186e+00,  -6.90091509988356933e+00,  -6.90187116427471103e+00,  -6.90124498600743852e+00,
  -6.90336853450747689e+00,  -6.90214019682790791e+00,  -6.90197286876638572e+00,  -6.90427891949028893e+00,
  -6.90484382017810017e+00,  -6.91523246192273255e+00,  -6.90754315042094280e+00,  -6.90491450004416052e+00,
  -6.90286346602945677e+00,  -6.90188586842517893e+00,  -3.89416722438406371e+00,  -8.81730921815205293e-01,
  1.51472512085091227e+00,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -6.90204383632760621e+00,
  -6.90051499292634762e+00,  -6.90039023352962744e+00,  -6.90167567301884333e+00,  -6.90080494792416843e+00,
  -6.90058838786608586e+00,  -6.90148572711027519e+00,  -6.90083879548898071e+00,  -6.90128117622071180e+00,
  -6.90038495665206586e+00,  -6.90229927449729974e+00,  -6.90172113514415386e+00,  -6.90155495760824600e+00,
  -6.90084443491126986e+00,  -6.90547100935400238e+00,  -6.90741880220376814e+00,  -6.90305989730014691e+00,
  -6.90080834276351140e+00,  -6.90214340676286575e+00,  -6.90162189095996403e+00,  -6.90318534563004516e+00,
  -2.13270568802622895e+00,  1.54641549269816769e+00,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -6.90143484366372828e+00,  -6.90193122576113627e+00,  -6.90097480144627884e+00,
  -6.90210046257245580e+00,  -6.90622784662784994e+00,  -6.90129226938101947e+00,  -6.90382140328632854e+00,
  -6.90127945167375145e+00,  -6.91548857884495138e+00,  -6.90249603295843617e+00,  -6.90117946813547878e+00,
  -6.90305964627851942e+00,  -6.90087961603743238e+00,  -6.90148253700973768e+00,  -6.90170491118568030e+00,
  -6.91175741807649757e+00,  -6.90063857810296710e+00,  -6.90417806587020699e+00,  -6.90463813405289972e+00,
  -6.90307332468064416e+00,  -2.13092039034652503e+00,  1.54888730977219957e+00,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -3.89214240697338365e+00,
  -6.90105592359360198e+00,  -6.90219645676279558e+00,  -6.90510150701208492e+00,  -6.90363469706492072e+00,
  -6.90261284828250332e+00,  -6.90158775709942773e+00,  -6.90487559077122448e+00,  -6.90822871670200023e+00,
  -6.90062659944385093e+00,  -6.90200806768307196e+00,  -6.90639403865116819e+00,  -6.90041031384832326e+00,
  -6.90403378476255369e+00,  -6.90107415048322270e+00,  -6.90209513226195170e+00,  -6.90533917904730643e+00,
  -6.90085151903714156e+00,  -6.90198183140071109e+00,  -2.13173273746558145e+00,  8.78848528291113373e-01,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -3.89111823498491605e+00,  -3.89376656543541477e+00,  -3.89263546887778933e+00,
  -6.90262294618626893e+00,  -6.90252490131335517e+00,  -6.90348395221841660e+00,  -6.90324836995105162e+00,
  -6.90624977907152360e+00,  -6.90206534415994355e+00,  -6.90361269421882007e+00,  -6.90182117188673772e+00,
  -6.90218747214568396e+00,  -6.90229474608539029e+00,  -6.90157231229607593e+00,  -6.90098299540794269e+00,
  -6.90029718386487900e+00,  -6.90072095870833380e+00,  -6.90047818324185602e+00,  -2.13348329646005963e+00,
  1.54746712617642679e+00,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -2.13307569913682782e+00,  -3.89173006812322475e+00,  -3.89232172745221217e+00,  -6.90067496228219834e+00,
  -6.90057906624861062e+00,  -6.90056512872813688e+00,  -6.90110671309974144e+00,  -6.90055331203121369e+00,
  -6.90106435928636763e+00,  -6.90101498186341544e+00,  -6.90122308890552905e+00,  -6.90038905734061636e+00,
  -6.90543554080614985e+00,  -6.90122619198518894e+00,  -6.90642989596966217e+00,  -6.90561086477799346e+00,
  -2.13159728472088617e+00,  2.63858164074910873e+00,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  8.72025910455911796e-02,  -8.81568725945512943e-01,
  -2.13099317000568611e+00,  -3.89315408995133838e+00,  -3.89221186475209580e+00,  -3.89105010263441642e+00,
  -6.90028663239590223e+00,  -6.90069125807052153e+00,  -6.90037055471808269e+00,  -6.90077233123693823e+00,
  -6.90029861721464322e+00,  -6.90144756090940614e+00,  -6.90080784624241872e+00,  -6.90046984768614458e+00,
  -3.89278683030922767e+00,  -2.13155619940611007e+00,  2.63896522641822973e+00,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  1.54836609615026854e+00,  8.73844205532818413e-02,  -2.13163389778340573e+00,
  -3.89118740904787686e+00,  -3.89189194441345787e+00,  -3.89207162534056916e+00,  -3.89153386365159060e+00,
  -3.89387770890577656e+00,  -3.89110417566769140e+00,  -3.89105946791195567e+00,  -3.89186251766005764e+00,
  -3.89337173927081093e+00,  -3.89535929990407270e+00,  -8.81426202944169734e-01,  3.09775521215370464e+00,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  3.88887237614939796e+00,
  1.54882230975605628e+00,  8.68089500388758706e-02,  -8.81631806715721278e-01,  -2.13113100701382407e+00,
  -2.13215186114407329e+00,  -2.13111826243375457e+00,  -3.89115304247964433e+00,  -3.89454668247251856e+00,
  -3.89200215138533245e+00,  -3.89186960712354679e+00,  -3.89228746219562804e+00,  -8.81774113778367341e-01,
  4.55947752593128719e+00,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  4.23706567952140567e+00,  1.54849419041293035e+00,
  8.72579634835804335e-02,  -8.81488027199110791e-01,  -8.81687201156878264e-01,  -2.13105326114867299e+00,
  -2.13064386439856346e+00,  -2.13057256750824431e+00,  -2.13092001441443468e+00,  -2.13114898085527704e+00,
  8.74793223239882095e-02,  4.85874132776757239e+00,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  6.31985901063702293e+00,  3.09770731779719100e+00,  2.12864893978638792e+00,  8.79416056734799834e-01,
  8.76249083334538353e-02,  8.74851499834654323e-02,  -8.82120874442077652e-01,  -8.82272772798863514e-01,
  -8.81734889789267950e-01,  8.79081059251189734e-01,  6.00608617451095661e+00,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  7.86777944428989606e+00,  3.88911358600899604e+00,
  3.09756865458641695e+00,  2.64015069365424537e+00,  1.54844332963119324e+00,  8.79411996309930166e-01,
  8.72601252497750834e-02,  8.77126382564947377e-02,  1.54879758894467678e+00,  7.19773316778526606e+00,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  8.83784566967942631e+00,  5.99791051558826993e+00,  4.85850016579833444e+00,  3.88935982527050950e+00,
  3.09775310172770890e+00,  2.64002307477591858e+00,  1.54884921811827647e+00,  2.63991087452184914e+00,
  8.40167791960675991e+00,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  8.28297180619730078e+00,  7.16305210198369213e+00,
  6.31972401482355206e+00,  5.65027685617260023e+00,  4.23703685301898769e+00,  3.09778185341782031e+00,
  3.88942394451645912e+00,  9.11936577597190023e+00,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  9.33120233712243419e+00,  8.66038333180112829e+00,  8.08068884525038378e+00,  5.99767025921274843e+00,
  4.40107934926722777e+00,  5.27233980734894825e+00,  9.52332284464030643e+00,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  1.05634228488392914e+01,  1.00436103614847241e+01,
  8.83772531485501744e+00,  6.31987945286940445e+00,  7.16271527735695201e+00,  1.18620381827651187e+01,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  1.61235246454253411e-01,
  1.16885800101061221e+01,  1.06563580001894902e+01,  7.64607059309182802e+00,  8.66067540325788165e+00,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  1.31047274111854470e+01,  1.24963836534997803e+01,  1.02992319271076216e+01,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  8.16574422227778918e+00,  1.39359243109454116e+01,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,  -1.00000000000000005e+300,
};

int CzetaValid [3600] = {
  0,  0,  0,  0,
  0,  0,  0,  0,
  0,  0,  0,  0,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  0,  1,  1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  0,  0,  0,  0,
  0,  0,  0,  0,
  0,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  0,  0,  0,  0,
  0,  0,  0,  0,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  0,  0,  0,  0,
  0,  0,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  0,  0,  0,  0,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  0,  0,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  0,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  0,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  0,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  0,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  0,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  0,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  0,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  1,  1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  1,
  1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  1,  1,
  1,  1,  1,  1,
  1,  1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  1,  1,  1,  1,
  1,  1,  1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  1,  1,
  1,  1,  1,  0,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  0,
  1,  1,  1,  1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  1,  1,  1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  0,  1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,
};
