/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.lang.reflect.Method;
import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.ClassExistsQuery;
import org.anarres.jdiagnostics.ClassMethodExistsCallQuery;
import org.anarres.jdiagnostics.ClassQuery;
import org.anarres.jdiagnostics.JarQuery;
import org.anarres.jdiagnostics.MethodExistsCallQuery;
import org.anarres.jdiagnostics.MethodExistsQuery;
import org.anarres.jdiagnostics.Result;

public class JAXPQuery
extends AbstractQuery {
    public String getName() {
        return "jaxp";
    }

    public void version(Result result, String prefix) {
        new JarQuery("jaxp.jar").call(result, prefix + "jaxpJar/");
        Class<?> c = new ClassExistsQuery("javax.xml.parsers.DocumentBuilder").findClass(result, prefix);
        if (c == null) {
            result.put(prefix + "version", "none");
            return;
        }
        Method m = new MethodExistsQuery(c, "getDOMImplementation", new Class[0]).findMethod(result, prefix);
        if (m == null) {
            result.put(prefix + "version", "1.0.1?");
            return;
        }
        result.put(prefix + "version", ">=1.1");
    }

    public void factory(Result result, String prefix) {
        Object factory = new ClassMethodExistsCallQuery(null, "javax.xml.parsers.DocumentBuilderFactory", "newInstance").invoke(result, prefix);
        if (factory == null) {
            return;
        }
        Object instance = new MethodExistsCallQuery(factory, factory.getClass(), "newDocumentBuilder").invoke(result, prefix + "instance/");
        if (instance == null) {
            return;
        }
        new ClassQuery(instance.getClass()).call(result, prefix + "type/");
    }

    public void call(Result result, String prefix) {
        this.version(result, prefix + "version/");
        this.factory(result, prefix + "factory/");
    }
}

