/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.http.interfaces;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationException;
import org.jboss.invocation.MarshalledValue;
import org.jboss.invocation.http.interfaces.AnyhostVerifier;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityAssociationAuthenticator;

public class Util {
    private static String REQUEST_CONTENT_TYPE = "application/x-java-serialized-object; class=org.jboss.invocation.MarshalledInvocation";
    private static Logger log = Logger.getLogger(class$org$jboss$invocation$http$interfaces$Util == null ? (class$org$jboss$invocation$http$interfaces$Util = Util.class$("org.jboss.invocation.http.interfaces.Util")) : class$org$jboss$invocation$http$interfaces$Util);
    private static Class httpsConnClass;
    static /* synthetic */ Class class$org$jboss$invocation$http$interfaces$Util;

    public static void init() {
        try {
            SetAuthenticator action = new SetAuthenticator();
            AccessController.doPrivileged(action);
        }
        catch (Exception e) {
            log.warn("Failed to install SecurityAssociationAuthenticator", e);
        }
    }

    public static Object invoke(URL externalURL, Invocation mi) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("invoke, externalURL=" + externalURL);
        }
        HttpURLConnection conn = (HttpURLConnection)externalURL.openConnection();
        Util.configureHttpsHostVerifier(conn);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("ContentType", REQUEST_CONTENT_TYPE);
        conn.setRequestMethod("POST");
        OutputStream os = conn.getOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        try {
            oos.writeObject(mi);
            oos.flush();
        }
        catch (ObjectStreamException e) {
            throw new InvocationException(e);
        }
        InputStream is = conn.getInputStream();
        ObjectInputStream ois = new ObjectInputStream(is);
        MarshalledValue mv = (MarshalledValue)ois.readObject();
        ois.read();
        ois.close();
        oos.close();
        Object value = mv.get();
        if (value instanceof Exception) {
            throw (Exception)value;
        }
        return value;
    }

    public static void configureHttpsHostVerifier(HttpURLConnection conn) throws InvocationTargetException, IllegalAccessException {
        boolean isAssignable = httpsConnClass.isAssignableFrom(conn.getClass());
        if (isAssignable && Boolean.getBoolean("org.jboss.security.ignoreHttpsHost")) {
            AnyhostVerifier.setHostnameVerifier(conn);
        }
    }

    public static URL resolveURL(String urlValue) throws MalformedURLException {
        if (urlValue == null) {
            return null;
        }
        URL externalURL = null;
        try {
            externalURL = new URL(urlValue);
        }
        catch (MalformedURLException e) {
            String urlProperty = System.getProperty(urlValue);
            if (urlProperty == null) {
                throw e;
            }
            externalURL = new URL(urlProperty);
        }
        return externalURL;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            SetAuthenticator action = new SetAuthenticator();
            AccessController.doPrivileged(action);
        }
        catch (Exception e) {
            log.warn("Failed to install SecurityAssociationAuthenticator", e);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            httpsConnClass = loader.loadClass("javax.net.ssl.HttpsURLConnection");
            log.debug("httpsConnClass: " + httpsConnClass);
        }
        catch (Exception e) {
            try {
                httpsConnClass = loader.loadClass("com.sun.net.ssl.HttpsURLConnection");
                log.debug("httpsConnClass: " + httpsConnClass);
            }
            catch (Exception e2) {
                log.warn("No HttpsURLConnection seen");
            }
        }
    }

    static class SetAuthenticator
    implements PrivilegedAction {
        SetAuthenticator() {
        }

        public Object run() {
            Authenticator.setDefault((Authenticator)new SecurityAssociationAuthenticator());
            return null;
        }
    }
}

