/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.jboss.logging.Logger;
import org.jboss.mx.metadata.StandardMetaData;

public class StandardMBean
implements DynamicMBean {
    private static final Logger log = Logger.getLogger(class$javax$management$StandardMBean == null ? (class$javax$management$StandardMBean = StandardMBean.class$("javax.management.StandardMBean")) : class$javax$management$StandardMBean);
    private Object implementation;
    private Class mbeanInterface;
    private MBeanInfo cachedMBeanInfo;
    static /* synthetic */ Class class$javax$management$StandardMBean;

    public StandardMBean(Object implementation, Class mbeanInterface) throws NotCompliantMBeanException {
        if (implementation == null) {
            throw new IllegalArgumentException("Null implementation");
        }
        this.init(implementation, mbeanInterface);
    }

    protected StandardMBean(Class mbeanInterface) throws NotCompliantMBeanException {
        this.init(this, mbeanInterface);
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public void setImplementation(Object implementation) throws NotCompliantMBeanException {
        if (implementation == null) {
            throw new IllegalArgumentException("Null implementation");
        }
        this.implementation = implementation;
    }

    public Class getImplementationClass() {
        return this.implementation.getClass();
    }

    public Class getMBeanInterface() {
        return this.mbeanInterface;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        throw new IllegalStateException("Do not invoke directly");
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new IllegalStateException("Do not invoke directly");
    }

    public AttributeList getAttributes(String[] attributes) {
        throw new IllegalStateException("Do not invoke directly");
    }

    public AttributeList setAttributes(AttributeList attributes) {
        throw new IllegalStateException("Do not invoke directly");
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        throw new IllegalStateException("Do not invoke directly");
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = this.getCachedMBeanInfo();
        if (info == null) {
            try {
                info = this.buildMBeanInfo(this.implementation, this.mbeanInterface);
            }
            catch (NotCompliantMBeanException e) {
                log.error("Unexcepted exception", e);
                throw new IllegalStateException("Unexcepted exception " + e.toString());
            }
        }
        return info;
    }

    protected String getClassName(MBeanInfo info) {
        return info.getClassName();
    }

    protected String getDescription(MBeanInfo info) {
        return info.getDescription();
    }

    protected String getDescription(MBeanFeatureInfo info) {
        return info.getDescription();
    }

    protected String getDescription(MBeanAttributeInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanConstructorInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanOperationInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanConstructorInfo info, MBeanParameterInfo param, int sequence) {
        return param.getDescription();
    }

    protected String getDescription(MBeanOperationInfo info, MBeanParameterInfo param, int sequence) {
        return param.getDescription();
    }

    protected String getParameterName(MBeanConstructorInfo info, MBeanParameterInfo param, int sequence) {
        return param.getName();
    }

    protected String getParameterName(MBeanOperationInfo info, MBeanParameterInfo param, int sequence) {
        return param.getName();
    }

    protected int getImpact(MBeanOperationInfo info) {
        return info.getImpact();
    }

    protected MBeanConstructorInfo[] getConstructors(MBeanConstructorInfo[] constructors, Object implementation) {
        if (implementation == this) {
            return constructors;
        }
        return null;
    }

    protected MBeanInfo getCachedMBeanInfo() {
        return this.cachedMBeanInfo;
    }

    protected void cacheMBeanInfo(MBeanInfo info) {
        this.cachedMBeanInfo = info;
    }

    private final void init(Object implementation, Class mbeanInterface) throws NotCompliantMBeanException {
        MBeanInfo info = this.buildMBeanInfo(implementation, mbeanInterface);
        this.cacheMBeanInfo(info);
        this.implementation = implementation;
    }

    private final MBeanInfo buildMBeanInfo(Object implementation, Class mbeanInterface) throws NotCompliantMBeanException {
        String description;
        String name;
        String description2;
        MBeanParameterInfo[] parameters;
        int i;
        StandardMetaData metaData = new StandardMetaData(implementation, mbeanInterface);
        this.mbeanInterface = metaData.getMBeanInterface();
        MBeanInfo info = metaData.build();
        String className = this.getClassName(info);
        String mainDescription = this.getDescription(info);
        MBeanAttributeInfo[] attributes = info.getAttributes();
        MBeanConstructorInfo[] constructors = info.getConstructors();
        MBeanOperationInfo[] operations = info.getOperations();
        MBeanNotificationInfo[] notifications = info.getNotifications();
        for (i = 0; i < attributes.length; ++i) {
            MBeanAttributeInfo attribute = attributes[i];
            String description3 = this.getDescription(attribute);
            attributes[i] = new MBeanAttributeInfo(attribute.getName(), attribute.getType(), description3, attribute.isReadable(), attribute.isWritable(), attribute.isIs());
        }
        constructors = this.getConstructors(constructors, this);
        for (i = 0; i < constructors.length; ++i) {
            MBeanConstructorInfo constructor = constructors[i];
            parameters = constructor.getSignature();
            for (int j = 0; j < parameters.length; ++j) {
                MBeanParameterInfo param = parameters[j];
                description2 = this.getDescription(constructor, param, j);
                name = this.getParameterName(constructor, param, j);
                parameters[j] = new MBeanParameterInfo(name, param.getType(), description2);
            }
            description = this.getDescription(constructor);
            constructors[i] = new MBeanConstructorInfo(constructor.getName(), description, parameters);
        }
        for (i = 0; i < operations.length; ++i) {
            MBeanOperationInfo operation = operations[i];
            parameters = operation.getSignature();
            for (int j = 0; j < parameters.length; ++j) {
                MBeanParameterInfo param = parameters[j];
                description2 = this.getDescription(operation, param, j);
                name = this.getParameterName(operation, param, j);
                parameters[j] = new MBeanParameterInfo(name, param.getType(), description2);
            }
            description = this.getDescription(operation);
            int impact = this.getImpact(operation);
            operations[i] = new MBeanOperationInfo(operation.getName(), description, parameters, operation.getReturnType(), impact);
        }
        info = new MBeanInfo(className, mainDescription, attributes, constructors, operations, notifications);
        return info;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

