/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.QueryEval;
import javax.management.QueryExp;
import org.jboss.mx.util.ObjectNamePatternHelper;
import org.jboss.mx.util.Serialization;

public class ObjectName
implements Serializable,
QueryExp {
    private transient boolean hasPattern = false;
    private transient boolean hasDomainPattern = false;
    private transient boolean hasPropertyPattern = false;
    private transient Hashtable propertiesHash = null;
    private transient String domain = null;
    private transient String kProps = null;
    private transient String ckProps = null;
    private transient int hash;
    private transient ObjectNamePatternHelper.PropertyPattern propertyPattern;
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Hashtable;

    public static ObjectName getInstance(String name) throws MalformedObjectNameException {
        return new ObjectName(name);
    }

    public static ObjectName getInstance(String domain, String key, String value) throws MalformedObjectNameException {
        return new ObjectName(domain, key, value);
    }

    public static ObjectName getInstance(String domain, Hashtable table) throws MalformedObjectNameException {
        return new ObjectName(domain, table);
    }

    public static String quote(String value) {
        if (value == null) {
            throw new NullPointerException("null value");
        }
        StringBuffer buffer = new StringBuffer(value.length() + 10);
        buffer.append('\"');
        char[] chars = value.toCharArray();
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\"': 
                case '*': 
                case '?': 
                case '\\': {
                    buffer.append('\\').append(chars[i]);
                    continue block4;
                }
                case '\n': {
                    buffer.append('\\').append('n');
                    continue block4;
                }
                default: {
                    buffer.append(chars[i]);
                }
            }
        }
        buffer.append('\"');
        return buffer.toString();
    }

    public static String unquote(String value) {
        if (value == null) {
            throw new NullPointerException("null value");
        }
        if (value.length() == 0) {
            throw new IllegalArgumentException("Empty value");
        }
        StringBuffer buffer = new StringBuffer(value.length());
        char[] chars = value.toCharArray();
        boolean inQuote = false;
        boolean escape = false;
        block9: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (escape) {
                switch (c) {
                    case '\"': 
                    case '*': 
                    case '?': 
                    case '\\': {
                        escape = false;
                        buffer.append(c);
                        continue block9;
                    }
                    case 'n': {
                        escape = false;
                        buffer.append('\n');
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException("The value " + value + " contains an invalid escape sequence backslash " + c);
                    }
                }
            }
            if (!inQuote && c == '\"') {
                inQuote = true;
                continue;
            }
            if (inQuote && c == '\"') {
                inQuote = false;
                continue;
            }
            if (inQuote && c == '\\') {
                escape = true;
                continue;
            }
            if (inQuote) {
                switch (c) {
                    case '\"': {
                        throw new IllegalArgumentException("The value " + value + " cannot contain quote inside a quote pair, use backslash quote");
                    }
                    case '*': 
                    case '?': {
                        throw new IllegalArgumentException("The value " + value + " cannot contain " + c + " inside a quote pair, use backslash " + c);
                    }
                    case '\n': {
                        throw new IllegalArgumentException("The value " + value + " cannot contain a new line inside a quote pair, use backslash n");
                    }
                }
                buffer.append(c);
                continue;
            }
            throw new IllegalArgumentException("The value " + value + " is not enclosed in quotes");
        }
        if (inQuote) {
            throw new IllegalArgumentException("Unterminated quote pair, missing quote");
        }
        if (escape) {
            throw new IllegalArgumentException("Unterminated escape, missing one of backslash quote asterisk question mark or n");
        }
        return buffer.toString();
    }

    public ObjectName(String name) throws MalformedObjectNameException {
        this.init(name);
    }

    public ObjectName(String domain, String key, String value) throws MalformedObjectNameException {
        if (null == key) {
            throw new NullPointerException("properties key cannot be null");
        }
        if (null == value) {
            throw new NullPointerException("properties value cannot be null");
        }
        this.initDomain(domain, null);
        Hashtable<String, String> ptable = new Hashtable<String, String>();
        ptable.put(key, value);
        this.initProperties(ptable, null);
        this.kProps = key + "=" + value;
    }

    public ObjectName(String domain, Hashtable table) throws MalformedObjectNameException {
        if (table == null) {
            throw new NullPointerException("null table");
        }
        this.initDomain(domain, null);
        if (table.size() < 1) {
            throw new MalformedObjectNameException("empty table");
        }
        this.initProperties((Hashtable)table.clone(), null);
        this.kProps = this.ckProps;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof ObjectName) {
            ObjectName oname = (ObjectName)object;
            return oname.hash == this.hash && this.domain.equals(oname.domain) && this.ckProps.equals(oname.ckProps);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.domain + ":" + this.kProps;
    }

    public boolean isPattern() {
        return this.hasPattern;
    }

    public String getCanonicalName() {
        return this.domain + ":" + this.ckProps;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getKeyProperty(String property) {
        return (String)this.propertiesHash.get(property);
    }

    public Hashtable getKeyPropertyList() {
        return (Hashtable)this.propertiesHash.clone();
    }

    public String getKeyPropertyListString() {
        return this.kProps;
    }

    public String getCanonicalKeyPropertyListString() {
        return this.ckProps;
    }

    public boolean isPropertyPattern() {
        return this.hasPropertyPattern;
    }

    public boolean isDomainPattern() {
        return this.hasDomainPattern;
    }

    public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        if (name.isPattern()) {
            return false;
        }
        if (this == name) {
            return true;
        }
        if (ObjectNamePatternHelper.patternMatch(name.getDomain(), this.getDomain())) {
            if (this.propertyPattern == null) {
                this.propertyPattern = new ObjectNamePatternHelper.PropertyPattern(this);
            }
            return this.propertyPattern.patternMatch(name);
        }
        return false;
    }

    public void setMBeanServer(MBeanServer server) {
        QueryEval.server.set(server);
    }

    private void init(String name) throws MalformedObjectNameException {
        int domainSep;
        if (name == null) {
            throw new NullPointerException("null name");
        }
        if (name.length() == 0) {
            name = "*:*";
        }
        if (-1 == (domainSep = name.indexOf(58))) {
            throw new MalformedObjectNameException("missing domain");
        }
        this.initDomain(name.substring(0, domainSep), name);
        this.initProperties(name.substring(domainSep + 1), name);
    }

    private void initDomain(String dstring, String name) throws MalformedObjectNameException {
        if (null == dstring) {
            throw new NullPointerException("null domain");
        }
        this.checkIllegalDomain(dstring, name);
        if (dstring.indexOf(42) > -1 || dstring.indexOf(63) > -1) {
            this.hasPattern = true;
            this.hasDomainPattern = true;
        }
        this.domain = dstring;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initProperties(String properties, String name) throws MalformedObjectNameException {
        if (null == properties || properties.length() < 1) {
            throw new MalformedObjectNameException(this.addDebugObjectName(name) + "null or empty properties");
        }
        Hashtable<String, String> ptable = new Hashtable<String, String>();
        char[] chars = properties.toCharArray();
        String key = null;
        Object value = null;
        int start = 0;
        boolean inKey = true;
        boolean inQuote = false;
        boolean escape = false;
        for (int current = 0; current < chars.length; ++current) {
            char c = chars[current];
            if (escape) {
                escape = false;
                continue;
            }
            if (inQuote) {
                if (c == '\"') {
                    inQuote = false;
                    continue;
                }
                if (c != '\\') continue;
                escape = true;
                continue;
            }
            if (inKey) {
                if (c != '=' && c != ',') continue;
                if (current == start) {
                    throw new MalformedObjectNameException(this.addDebugObjectName(name) + "Empty key");
                }
                key = properties.substring(start, current);
                if (c == ',') {
                    if (!key.equals("*")) throw new MalformedObjectNameException(this.addDebugObjectName(name) + "Invalid key/value data " + key);
                    if (this.hasPropertyPattern) {
                        throw new MalformedObjectNameException(this.addDebugObjectName(name) + "A property pattern may only contain one * property");
                    }
                    this.hasPropertyPattern = true;
                    this.hasPattern = true;
                } else {
                    if (ptable.containsKey(key)) {
                        throw new MalformedObjectNameException(this.addDebugObjectName(name) + "Duplicate key " + key);
                    }
                    inKey = false;
                }
                start = current + 1;
                continue;
            }
            if (c == '\"') {
                inQuote = true;
                continue;
            }
            if (c != ',') continue;
            if (current == start) {
                ptable.put(key, "");
            } else {
                ptable.put(key, properties.substring(start, current));
            }
            inKey = true;
            start = current + 1;
        }
        if (inKey) {
            if (start == chars.length) {
                throw new MalformedObjectNameException(this.addDebugObjectName(name) + "An ObjectName cannot end with a comma");
            }
            key = properties.substring(start, chars.length);
            if (!key.equals("*")) throw new MalformedObjectNameException(this.addDebugObjectName(name) + "Invalid key/value data " + key);
            if (this.hasPropertyPattern) {
                throw new MalformedObjectNameException(this.addDebugObjectName(name) + "A property pattern may only contain one * property");
            }
            this.hasPropertyPattern = true;
            this.hasPattern = true;
        }
        if (!inKey) {
            if (start == chars.length) {
                ptable.put(key, "");
            } else {
                ptable.put(key, properties.substring(start, chars.length));
            }
        }
        this.initProperties(ptable, name);
        this.kProps = properties;
    }

    private void initProperties(Hashtable properties, String name) throws MalformedObjectNameException {
        if (null == properties || !this.hasPropertyPattern && properties.size() < 1) {
            throw new MalformedObjectNameException(this.addDebugObjectName(name) + "null or empty properties");
        }
        Iterator<Object> it = properties.keySet().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            String key = null;
            try {
                key = (String)it.next();
            }
            catch (ClassCastException e) {
                throw new MalformedObjectNameException(this.addDebugObjectName(name) + "key is not a string " + key);
            }
            String val = null;
            try {
                val = (String)properties.get(key);
            }
            catch (ClassCastException e) {
                throw new MalformedObjectNameException(this.addDebugObjectName(name) + "value is not a string " + val);
            }
            if (key.equals("*") && val.equals("*")) {
                it.remove();
                this.hasPropertyPattern = true;
                this.hasPattern = true;
                continue;
            }
            if (key.length() == 0) {
                throw new MalformedObjectNameException(this.addDebugObjectName(name) + "key has no length =" + val);
            }
            this.checkIllegalKey(key, name);
            this.checkIllegalValue(val, name);
            list.add(new String(key + "=" + val));
        }
        Collections.sort(list);
        StringBuffer strBuffer = new StringBuffer();
        it = list.iterator();
        while (it.hasNext()) {
            strBuffer.append(it.next());
            if (!it.hasNext()) continue;
            strBuffer.append(',');
        }
        if (this.hasPropertyPattern) {
            if (properties.size() > 0) {
                strBuffer.append(",*");
            } else {
                strBuffer.append("*");
            }
        }
        this.propertiesHash = properties;
        this.ckProps = strBuffer.toString();
        this.hash = this.getCanonicalName().hashCode();
    }

    private void checkIllegalKey(String key, String name) throws MalformedObjectNameException {
        char[] chars = key.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '*': 
                case ',': 
                case ':': 
                case '=': 
                case '?': {
                    throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The key " + key + " cannot contain a " + chars[i] + " character");
                }
                case '\n': {
                    throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The key " + key + " cannot contain a new line character");
                }
            }
        }
    }

    private void checkIllegalValue(String value, String name) throws MalformedObjectNameException {
        char[] chars = value.toCharArray();
        boolean inQuote = false;
        boolean escape = false;
        block12: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (escape) {
                switch (c) {
                    case '\"': 
                    case '*': 
                    case '?': 
                    case '\\': 
                    case 'n': {
                        escape = false;
                        continue block12;
                    }
                    default: {
                        throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The value " + value + " contains an invalid escape sequence backslash " + c);
                    }
                }
            }
            if (!inQuote && c == '\"') {
                inQuote = true;
                continue;
            }
            if (inQuote && c == '\"') {
                inQuote = false;
                continue;
            }
            if (inQuote && c == '\\') {
                escape = true;
                continue;
            }
            if (inQuote) {
                switch (c) {
                    case '\"': {
                        throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The value " + value + " cannot contain quote inside a quote pair, use backslash quote");
                    }
                    case '*': 
                    case '?': {
                        throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The value " + value + " cannot contain " + c + " inside a quote pair, use backslash " + c);
                    }
                    case '\n': {
                        throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The value " + value + " cannot contain a new line inside a quote pair, use backslash n");
                    }
                }
                continue;
            }
            switch (c) {
                case '*': 
                case ',': 
                case ':': 
                case '=': 
                case '?': {
                    throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The value " + value + " cannot contain " + c + " use quote backslash " + c + " quote or ObjectName.quote(String)");
                }
                case '\n': {
                    throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The value " + value + " cannot contain a new line use quote backslash n quote or ObjectName.quote(String)");
                }
            }
        }
        if (inQuote) {
            throw new MalformedObjectNameException(this.addDebugObjectName(name) + "Unterminated quote pair, missing quote");
        }
        if (escape) {
            throw new MalformedObjectNameException(this.addDebugObjectName(name) + "Unterminated escape, missing one of backslash quote asterisk question mark or n");
        }
    }

    private void checkIllegalDomain(String dom, String name) throws MalformedObjectNameException {
        char[] chars = dom.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case ':': {
                    throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The domain " + dom + " cannot contain a : character");
                }
                case '\n': {
                    throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The domain " + dom + " cannot contain a new line character");
                }
            }
        }
    }

    private String addDebugObjectName(String name) {
        if (name == null) {
            return "";
        }
        return name + " is not a valid ObjectName. ";
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        switch (Serialization.version) {
            case 10: {
                ObjectInputStream.GetField getField = ois.readFields();
                try {
                    String name = (String)getField.get("canonicalName", null);
                    if (name == null) {
                        throw new StreamCorruptedException("No canonical name for jmx1.0?");
                    }
                    this.init(name);
                    break;
                }
                catch (MalformedObjectNameException e) {
                    throw new StreamCorruptedException(e.toString());
                }
            }
            default: {
                try {
                    this.init((String)ois.readObject());
                    break;
                }
                catch (MalformedObjectNameException e) {
                    throw new StreamCorruptedException(e.toString());
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        switch (Serialization.version) {
            case 10: {
                ObjectOutputStream.PutField putField = oos.putFields();
                putField.put("domain", this.domain);
                putField.put("propertyList", this.propertiesHash);
                putField.put("propertyListString", this.ckProps);
                putField.put("canonicalName", this.domain + ":" + this.ckProps);
                putField.put("pattern", this.hasPattern);
                putField.put("propertyPattern", this.hasPropertyPattern);
                oos.writeFields();
                break;
            }
            default: {
                oos.writeObject(this.domain + ":" + this.ckProps);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        switch (Serialization.version) {
            case 10: {
                serialVersionUID = -5467795090068647408L;
                serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("domain", class$java$lang$String == null ? (class$java$lang$String = ObjectName.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("propertyList", class$java$util$Hashtable == null ? (class$java$util$Hashtable = ObjectName.class$("java.util.Hashtable")) : class$java$util$Hashtable), new ObjectStreamField("propertyListString", class$java$lang$String == null ? (class$java$lang$String = ObjectName.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("canonicalName", class$java$lang$String == null ? (class$java$lang$String = ObjectName.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("pattern", Boolean.TYPE), new ObjectStreamField("propertyPattern", Boolean.TYPE)};
                break;
            }
            default: {
                serialVersionUID = 1081892073854801359L;
                serialPersistentFields = new ObjectStreamField[0];
            }
        }
    }
}

