/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
import * as coreClient from "@azure/core-client";
import * as Mappers from "../models/mappers.js";
import * as Parameters from "../models/parameters.js";
/** Class containing Service operations. */
export class ServiceImpl {
    client;
    /**
     * Initialize a new instance of the class Service class.
     * @param client Reference to the service client
     */
    constructor(client) {
        this.client = client;
    }
    /**
     * Sets properties for a storage account's Queue service endpoint, including properties for Storage
     * Analytics and CORS (Cross-Origin Resource Sharing) rules
     * @param properties The StorageService properties.
     * @param options The options parameters.
     */
    setProperties(properties, options) {
        return this.client.sendOperationRequest({ properties, options }, setPropertiesOperationSpec);
    }
    /**
     * gets the properties of a storage account's Queue service, including properties for Storage Analytics
     * and CORS (Cross-Origin Resource Sharing) rules.
     * @param options The options parameters.
     */
    getProperties(options) {
        return this.client.sendOperationRequest({ options }, getPropertiesOperationSpec);
    }
    /**
     * Retrieves statistics related to replication for the Queue service. It is only available on the
     * secondary location endpoint when read-access geo-redundant replication is enabled for the storage
     * account.
     * @param options The options parameters.
     */
    getStatistics(options) {
        return this.client.sendOperationRequest({ options }, getStatisticsOperationSpec);
    }
    /**
     * The List Queues Segment operation returns a list of the queues under the specified account
     * @param options The options parameters.
     */
    listQueuesSegment(options) {
        return this.client.sendOperationRequest({ options }, listQueuesSegmentOperationSpec);
    }
}
// Operation Specifications
const xmlSerializer = coreClient.createSerializer(Mappers, /* isXml */ true);
const setPropertiesOperationSpec = {
    path: "/",
    httpMethod: "PUT",
    responses: {
        202: {
            headersMapper: Mappers.ServiceSetPropertiesHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.ServiceSetPropertiesExceptionHeaders
        }
    },
    requestBody: Parameters.properties,
    queryParameters: [
        Parameters.restype,
        Parameters.comp,
        Parameters.timeoutInSeconds
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.contentType,
        Parameters.accept,
        Parameters.version,
        Parameters.requestId
    ],
    isXML: true,
    contentType: "application/xml; charset=utf-8",
    mediaType: "xml",
    serializer: xmlSerializer
};
const getPropertiesOperationSpec = {
    path: "/",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.QueueServiceProperties,
            headersMapper: Mappers.ServiceGetPropertiesHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.ServiceGetPropertiesExceptionHeaders
        }
    },
    queryParameters: [
        Parameters.restype,
        Parameters.comp,
        Parameters.timeoutInSeconds
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.accept1
    ],
    isXML: true,
    serializer: xmlSerializer
};
const getStatisticsOperationSpec = {
    path: "/",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.QueueServiceStatistics,
            headersMapper: Mappers.ServiceGetStatisticsHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.ServiceGetStatisticsExceptionHeaders
        }
    },
    queryParameters: [
        Parameters.restype,
        Parameters.timeoutInSeconds,
        Parameters.comp1
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.accept1
    ],
    isXML: true,
    serializer: xmlSerializer
};
const listQueuesSegmentOperationSpec = {
    path: "/",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.ListQueuesSegmentResponse,
            headersMapper: Mappers.ServiceListQueuesSegmentHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.ServiceListQueuesSegmentExceptionHeaders
        }
    },
    queryParameters: [
        Parameters.timeoutInSeconds,
        Parameters.comp2,
        Parameters.prefix,
        Parameters.marker,
        Parameters.maxPageSize,
        Parameters.include
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.accept1
    ],
    isXML: true,
    serializer: xmlSerializer
};
//# sourceMappingURL=service.js.map