"use strict";
/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.TableImpl = void 0;
const tslib_1 = require("tslib");
const coreClient = tslib_1.__importStar(require("@azure/core-client"));
const Mappers = tslib_1.__importStar(require("../models/mappers.js"));
const Parameters = tslib_1.__importStar(require("../models/parameters.js"));
/** Class containing Table operations. */
class TableImpl {
    client;
    /**
     * Initialize a new instance of the class Table class.
     * @param client Reference to the service client
     */
    constructor(client) {
        this.client = client;
    }
    /**
     * Queries tables under the given account.
     * @param options The options parameters.
     */
    query(options) {
        return this.client.sendOperationRequest({ options }, queryOperationSpec);
    }
    /**
     * Creates a new table under the given account.
     * @param tableProperties The Table properties.
     * @param options The options parameters.
     */
    create(tableProperties, options) {
        return this.client.sendOperationRequest({ tableProperties, options }, createOperationSpec);
    }
    /**
     * Operation permanently deletes the specified table.
     * @param table The name of the table.
     * @param options The options parameters.
     */
    delete(table, options) {
        return this.client.sendOperationRequest({ table, options }, deleteOperationSpec);
    }
    /**
     * Queries entities in a table.
     * @param table The name of the table.
     * @param options The options parameters.
     */
    queryEntities(table, options) {
        return this.client.sendOperationRequest({ table, options }, queryEntitiesOperationSpec);
    }
    /**
     * Queries entities in a table.
     * @param table The name of the table.
     * @param partitionKey The partition key of the entity.
     * @param rowKey The row key of the entity.
     * @param options The options parameters.
     */
    queryEntitiesWithPartitionAndRowKey(table, partitionKey, rowKey, options) {
        return this.client.sendOperationRequest({ table, partitionKey, rowKey, options }, queryEntitiesWithPartitionAndRowKeyOperationSpec);
    }
    /**
     * Update entity in a table.
     * @param table The name of the table.
     * @param partitionKey The partition key of the entity.
     * @param rowKey The row key of the entity.
     * @param options The options parameters.
     */
    updateEntity(table, partitionKey, rowKey, options) {
        return this.client.sendOperationRequest({ table, partitionKey, rowKey, options }, updateEntityOperationSpec);
    }
    /**
     * Merge entity in a table.
     * @param table The name of the table.
     * @param partitionKey The partition key of the entity.
     * @param rowKey The row key of the entity.
     * @param options The options parameters.
     */
    mergeEntity(table, partitionKey, rowKey, options) {
        return this.client.sendOperationRequest({ table, partitionKey, rowKey, options }, mergeEntityOperationSpec);
    }
    /**
     * Deletes the specified entity in a table.
     * @param table The name of the table.
     * @param partitionKey The partition key of the entity.
     * @param rowKey The row key of the entity.
     * @param ifMatch Match condition for an entity to be deleted. If specified and a matching entity is
     *                not found, an error will be raised. To force an unconditional delete, set to the wildcard character
     *                (*).
     * @param options The options parameters.
     */
    deleteEntity(table, partitionKey, rowKey, ifMatch, options) {
        return this.client.sendOperationRequest({ table, partitionKey, rowKey, ifMatch, options }, deleteEntityOperationSpec);
    }
    /**
     * Insert entity in a table.
     * @param table The name of the table.
     * @param options The options parameters.
     */
    insertEntity(table, options) {
        return this.client.sendOperationRequest({ table, options }, insertEntityOperationSpec);
    }
    /**
     * Retrieves details about any stored access policies specified on the table that may be used with
     * Shared Access Signatures.
     * @param table The name of the table.
     * @param options The options parameters.
     */
    getAccessPolicy(table, options) {
        return this.client.sendOperationRequest({ table, options }, getAccessPolicyOperationSpec);
    }
    /**
     * Sets stored access policies for the table that may be used with Shared Access Signatures.
     * @param table The name of the table.
     * @param options The options parameters.
     */
    setAccessPolicy(table, options) {
        return this.client.sendOperationRequest({ table, options }, setAccessPolicyOperationSpec);
    }
}
exports.TableImpl = TableImpl;
// Operation Specifications
const xmlSerializer = coreClient.createSerializer(Mappers, /* isXml */ true);
const serializer = coreClient.createSerializer(Mappers, /* isXml */ false);
const queryOperationSpec = {
    path: "/Tables",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.TableQueryResponse,
            headersMapper: Mappers.TableQueryHeaders
        },
        default: {
            bodyMapper: Mappers.TableServiceError,
            headersMapper: Mappers.TableQueryExceptionHeaders
        }
    },
    queryParameters: [
        Parameters.format,
        Parameters.top,
        Parameters.select,
        Parameters.filter,
        Parameters.nextTableName
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.accept,
        Parameters.version,
        Parameters.requestId,
        Parameters.dataServiceVersion
    ],
    serializer
};
const createOperationSpec = {
    path: "/Tables",
    httpMethod: "POST",
    responses: {
        201: {
            bodyMapper: Mappers.TableResponse,
            headersMapper: Mappers.TableCreateHeaders
        },
        204: {
            headersMapper: Mappers.TableCreateHeaders
        },
        default: {
            bodyMapper: Mappers.TableServiceError,
            headersMapper: Mappers.TableCreateExceptionHeaders
        }
    },
    requestBody: Parameters.tableProperties,
    queryParameters: [Parameters.format],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.accept,
        Parameters.version,
        Parameters.requestId,
        Parameters.dataServiceVersion,
        Parameters.contentType,
        Parameters.responsePreference
    ],
    mediaType: "json",
    serializer
};
const deleteOperationSpec = {
    path: "/Tables('{table}')",
    httpMethod: "DELETE",
    responses: {
        204: {
            headersMapper: Mappers.TableDeleteHeaders
        },
        default: {
            bodyMapper: Mappers.TableServiceError,
            headersMapper: Mappers.TableDeleteExceptionHeaders
        }
    },
    urlParameters: [Parameters.url, Parameters.table],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.accept1
    ],
    serializer
};
const queryEntitiesOperationSpec = {
    path: "/{table}()",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.TableEntityQueryResponse,
            headersMapper: Mappers.TableQueryEntitiesHeaders
        },
        default: {
            bodyMapper: Mappers.TableServiceError,
            headersMapper: Mappers.TableQueryEntitiesExceptionHeaders
        }
    },
    queryParameters: [
        Parameters.format,
        Parameters.top,
        Parameters.select,
        Parameters.filter,
        Parameters.timeout,
        Parameters.nextPartitionKey,
        Parameters.nextRowKey
    ],
    urlParameters: [Parameters.url, Parameters.table],
    headerParameters: [
        Parameters.accept,
        Parameters.version,
        Parameters.requestId,
        Parameters.dataServiceVersion
    ],
    serializer
};
const queryEntitiesWithPartitionAndRowKeyOperationSpec = {
    path: "/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: {
                type: { name: "Dictionary", value: { type: { name: "any" } } }
            },
            headersMapper: Mappers.TableQueryEntitiesWithPartitionAndRowKeyHeaders
        },
        default: {
            bodyMapper: Mappers.TableServiceError,
            headersMapper: Mappers.TableQueryEntitiesWithPartitionAndRowKeyExceptionHeaders
        }
    },
    queryParameters: [
        Parameters.format,
        Parameters.select,
        Parameters.filter,
        Parameters.timeout
    ],
    urlParameters: [
        Parameters.url,
        Parameters.table,
        Parameters.partitionKey,
        Parameters.rowKey
    ],
    headerParameters: [
        Parameters.accept,
        Parameters.version,
        Parameters.requestId,
        Parameters.dataServiceVersion
    ],
    serializer
};
const updateEntityOperationSpec = {
    path: "/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')",
    httpMethod: "PUT",
    responses: {
        204: {
            headersMapper: Mappers.TableUpdateEntityHeaders
        },
        default: {
            bodyMapper: Mappers.TableServiceError,
            headersMapper: Mappers.TableUpdateEntityExceptionHeaders
        }
    },
    requestBody: Parameters.tableEntityProperties,
    queryParameters: [Parameters.format, Parameters.timeout],
    urlParameters: [
        Parameters.url,
        Parameters.table,
        Parameters.partitionKey,
        Parameters.rowKey
    ],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.dataServiceVersion,
        Parameters.accept1,
        Parameters.contentType1,
        Parameters.ifMatch
    ],
    mediaType: "json",
    serializer
};
const mergeEntityOperationSpec = {
    path: "/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')",
    httpMethod: "PATCH",
    responses: {
        204: {
            headersMapper: Mappers.TableMergeEntityHeaders
        },
        default: {
            bodyMapper: Mappers.TableServiceError,
            headersMapper: Mappers.TableMergeEntityExceptionHeaders
        }
    },
    requestBody: Parameters.tableEntityProperties,
    queryParameters: [Parameters.format, Parameters.timeout],
    urlParameters: [
        Parameters.url,
        Parameters.table,
        Parameters.partitionKey,
        Parameters.rowKey
    ],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.dataServiceVersion,
        Parameters.accept1,
        Parameters.contentType1,
        Parameters.ifMatch
    ],
    mediaType: "json",
    serializer
};
const deleteEntityOperationSpec = {
    path: "/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')",
    httpMethod: "DELETE",
    responses: {
        204: {
            headersMapper: Mappers.TableDeleteEntityHeaders
        },
        default: {
            bodyMapper: Mappers.TableServiceError,
            headersMapper: Mappers.TableDeleteEntityExceptionHeaders
        }
    },
    queryParameters: [Parameters.format, Parameters.timeout],
    urlParameters: [
        Parameters.url,
        Parameters.table,
        Parameters.partitionKey,
        Parameters.rowKey
    ],
    headerParameters: [
        Parameters.accept,
        Parameters.version,
        Parameters.requestId,
        Parameters.dataServiceVersion,
        Parameters.ifMatch1
    ],
    serializer
};
const insertEntityOperationSpec = {
    path: "/{table}",
    httpMethod: "POST",
    responses: {
        201: {
            bodyMapper: {
                type: { name: "Dictionary", value: { type: { name: "any" } } }
            },
            headersMapper: Mappers.TableInsertEntityHeaders
        },
        204: {
            headersMapper: Mappers.TableInsertEntityHeaders
        },
        default: {
            bodyMapper: Mappers.TableServiceError,
            headersMapper: Mappers.TableInsertEntityExceptionHeaders
        }
    },
    requestBody: Parameters.tableEntityProperties,
    queryParameters: [Parameters.format, Parameters.timeout],
    urlParameters: [Parameters.url, Parameters.table],
    headerParameters: [
        Parameters.accept,
        Parameters.version,
        Parameters.requestId,
        Parameters.dataServiceVersion,
        Parameters.contentType,
        Parameters.responsePreference
    ],
    mediaType: "json",
    serializer
};
const getAccessPolicyOperationSpec = {
    path: "/{table}",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: {
                type: {
                    name: "Sequence",
                    element: {
                        type: { name: "Composite", className: "SignedIdentifier" }
                    }
                },
                serializedName: "SignedIdentifiers",
                xmlName: "SignedIdentifiers",
                xmlIsWrapped: true,
                xmlElementName: "SignedIdentifier"
            },
            headersMapper: Mappers.TableGetAccessPolicyHeaders
        },
        default: {
            bodyMapper: Mappers.TableServiceError,
            headersMapper: Mappers.TableGetAccessPolicyExceptionHeaders
        }
    },
    queryParameters: [Parameters.timeout, Parameters.comp],
    urlParameters: [Parameters.url, Parameters.table],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.accept2
    ],
    isXML: true,
    serializer: xmlSerializer
};
const setAccessPolicyOperationSpec = {
    path: "/{table}",
    httpMethod: "PUT",
    responses: {
        204: {
            headersMapper: Mappers.TableSetAccessPolicyHeaders
        },
        default: {
            bodyMapper: Mappers.TableServiceError,
            headersMapper: Mappers.TableSetAccessPolicyExceptionHeaders
        }
    },
    requestBody: Parameters.tableAcl,
    queryParameters: [Parameters.timeout, Parameters.comp],
    urlParameters: [Parameters.url, Parameters.table],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.contentType2,
        Parameters.accept3
    ],
    isXML: true,
    contentType: "application/xml; charset=utf-8",
    mediaType: "xml",
    serializer: xmlSerializer
};
//# sourceMappingURL=table.js.map