# Testing Clair

We provide dev tooling in order to quickly get a fully configured Clair and Quay environment stood up locally.
This environment can be used to test and develop Clair's Quay integration.

## Requirements

### Make

Make is used to stand up the local dev environment.
Make is readily available in just about every package manager you can think of.
It's very likely your workstation already has make on it.

### Podman/Docker and Docker Compose

Currently our local dev tooling is supported by docker and docker-compose.
Podman should work fine since v3.0.

Docker version 19.03.11 and docker-compose version 1.28.6 are confirmed working.
Our assumption is most recent versions will not have an issue running the local dev tooling.

See [Get Started with Podman](https://podman.io/get-started).

### Go Toolchain

Go 1.20 or higher is required.

See [Install Golang](https://golang.org/doc/install).

## Starting a cluster

```
git clone git@github.com:quay/clair.git
cd clair
docker-compose up -d
# or: make local-dev
# or: make local-dev-debug
# or: make local-dev-quay
```

After the local development environment successfully starts, the following infrastructure is available to you:

- `localhost:8080`

  Dashboards and debugging services -- See the traefik configs in `local-dev/traefik` for where the various services are served.

- `localhost:6060`

  Clair services.

- Quay (if started)

  Quay will be started in a single node, local storage configuration.
  A random port will be forwarded from localhost, see `podman port` for the mapping.

- PostgreSQL

  PostgreSQL will have a random port forwarded from localhost to the database server.
  See `local-dev/clair/init.sql` for credentials and permissions and `podman port` for the mapping.

### Debugging

With the `local-dev-debug` make target the operator has access to some more useful tools:

| Tool       | Description                     | URL                                                         | Credentials           |
| ---------- | ------------------------------- | ----------------------------------------------------------- | --------------------- |
| pgAdmin    | Postgres administration         | [localhost:8080/pgadmin](http://localhost:8080/pgadmin)     | clair@clair.com:clair |
| jaeger     | Distributed tracing             | [localhost:8080/jaeger](http://localhost:8080/jaeger)       | -                     |
| prometheus | Metrics collection and querying | [localhost:8080/prom](http://localhost:8080/prom)           | -                     |
| pyroscope  | Continuous profiling            | [localhost:8080/pyroscope](http://localhost:8080/pyroscope) | -                     |
| grafana    | Metrics dashboards              | [localhost:8080/grafana](http://localhost:8080/grafana)     | admin:admin           |

## Pushing to the Local Quay

As mentioned above, Quay is forwarded to a random port on the host.
You can connect to the server on that port and create a account.
Creating an account named `admin` will ensure you are a super user.
An email is required, but is not validated.
You'll also need to create a namespace.

To push to Quay, you'll need to exec into the skopeo container:

```shell
docker-compose exec -it skopeo /usr/bin/skopeo copy --dest-creds '<user>:<pass>' --dest-tls-verify=false <src> docker://clair-quay:8080/<namespace>/<repo>:<tag>
```
Note that skopeo expects its image arguments in [`containers-transports(5)`] format.

[`containers-transports(5)`]: https://github.com/containers/image/blob/main/docs/containers-transports.5.md

## Viewing Results

By default, Quay displays security scanner results on the Tags page of the given repository.

## Making changes to configuration

You may want to play with either Clair or Quay's configuration.
If so, the configuration files can be found inside the repository at `local-dev/quay/config.yaml` and `local-dev/clair/config.yaml`.
Any changes to the configs will require a restart of the relevant service.
The quay-specific clair config is autogenerated, see the `Makefile`.

## Tearing it down

```
docker-compose down
```

will rip the entire environment down.


## Troubleshooting

The most common issue encountered when standing up the dev environment is port conflicts.
Make sure that you do not have any other processes listening on any of the ports outlined above.

The second issue you may face is your Docker resource settings being too constrained to support the local dev stack.
This is typically seen on Docker4Mac since a VM is used with a specific set of resources configured.
See [Docker For Mac Manual](https://docs.docker.com/docker-for-mac/) for instructions on how to change these resources.

If `docker-compose` reports errors like `Unsupported config option for services.activemq: 'profiles'`, the `docker-compose` version is too old and you'll need to upgrade.
Consult the relevant documentation for your environment for instructions.

Lastly, you can view traefik's ui at [`localhost:8080/dashboard/`](http://localhost:8080/dashboard/).
