/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.laf;

import java.awt.Color;
import java.awt.Font;
import java.util.MissingResourceException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class MaltegoLAF {
    private static MaltegoLAF _default;

    public static MaltegoLAF getDefault() {
        if (_default == null && (_default = (MaltegoLAF)Lookup.getDefault().lookup(MaltegoLAF.class)) == null) {
            _default = new Resource();
        }
        return _default;
    }

    public abstract String getValue(String var1);

    public abstract Color getColor(String var1);

    public abstract Font getFont(String var1);

    public abstract Integer getInt(String var1);

    public abstract Float getFloat(String var1);

    protected static class Resource
    extends MaltegoLAF {
        protected Resource() {
        }

        @Override
        public String getValue(String string) {
            return NbBundle.getBundle(this.getClass()).getString(string);
        }

        @Override
        public Color getColor(String string) {
            String string2 = this.getValue(string);
            Color color = null;
            if (string2 != null) {
                try {
                    color = Color.decode(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return color;
        }

        @Override
        public Font getFont(String string) {
            String string2 = this.getValue(string);
            Font font = null;
            if (string2 != null) {
                font = Font.decode(string2);
            }
            return font;
        }

        @Override
        public Integer getInt(String string) {
            String string2 = this.getValue(string);
            Integer n = null;
            if (string2 != null) {
                try {
                    n = Integer.decode(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return n;
        }

        @Override
        public Float getFloat(String string) {
            String string2 = this.getValue(string);
            Float f = null;
            if (string2 != null) {
                try {
                    f = Float.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return f;
        }
    }

    public static class Safe
    extends MaltegoLAF {
        private MaltegoLAF _delegate;

        public Safe() {
            this(Safe.getDefault());
        }

        public Safe(MaltegoLAF maltegoLAF) {
            this._delegate = maltegoLAF;
        }

        @Override
        public String getValue(String string) {
            String string2 = null;
            try {
                string2 = this._delegate.getValue(string);
            }
            catch (MissingResourceException missingResourceException) {
                Exceptions.printStackTrace((Throwable)missingResourceException);
            }
            return string2;
        }

        @Override
        public Color getColor(String string) {
            Color color = null;
            try {
                color = this._delegate.getColor(string);
            }
            catch (MissingResourceException missingResourceException) {
                Exceptions.printStackTrace((Throwable)missingResourceException);
            }
            return color != null ? color : Color.RED;
        }

        @Override
        public Font getFont(String string) {
            Font font = null;
            try {
                font = this._delegate.getFont(string);
            }
            catch (MissingResourceException missingResourceException) {
                Exceptions.printStackTrace((Throwable)missingResourceException);
            }
            return font != null ? font : Font.getFont("Dialog");
        }

        @Override
        public Integer getInt(String string) {
            Integer n = null;
            try {
                n = this._delegate.getInt(string);
            }
            catch (MissingResourceException missingResourceException) {
                Exceptions.printStackTrace((Throwable)missingResourceException);
            }
            return n != null ? n : Integer.valueOf(0);
        }

        @Override
        public Float getFloat(String string) {
            Float f = null;
            try {
                f = this._delegate.getFloat(string);
            }
            catch (MissingResourceException missingResourceException) {
                Exceptions.printStackTrace((Throwable)missingResourceException);
            }
            return f != null ? f : Float.valueOf(0.0f);
        }
    }
}

