/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.api;

import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import org.openide.util.Lookup;
import yguard.A.A.D;
import yguard.A.A.K;

public abstract class EntityRegistry
extends SpecRegistry<MaltegoEntitySpec> {
    private static final String REGISTRY_PROVIDER_KEY = "maltego.copy.EntityRegistry";

    public static EntityRegistry getDefault() {
        EntityRegistry entityRegistry = (EntityRegistry)((Object)Lookup.getDefault().lookup(EntityRegistry.class));
        if (entityRegistry == null) {
            entityRegistry = new DefaultEntityRegistry();
        }
        return entityRegistry;
    }

    public static EntityRegistry forGraph(D d) {
        RegistryDataProvider registryDataProvider;
        if (d != null && (registryDataProvider = (RegistryDataProvider)d.G((Object)REGISTRY_PROVIDER_KEY)) != null) {
            return registryDataProvider.getRegistry();
        }
        return null;
    }

    public static void associate(D d, EntityRegistry entityRegistry) {
        RegistryDataProvider registryDataProvider = new RegistryDataProvider(entityRegistry);
        d.A((Object)REGISTRY_PROVIDER_KEY, (K)registryDataProvider);
    }

    public static class Memory
    extends EntityRegistry {
        private static final String DEFAULT_FOLDER = "Miscellaneous";
        private HashMap<String, MaltegoEntitySpec> _items = new HashMap();
        private HashMap<String, String> _folders = new HashMap();

        public Memory() {
        }

        public Memory(MaltegoEntitySpec[] maltegoEntitySpecArray) {
            for (MaltegoEntitySpec maltegoEntitySpec : maltegoEntitySpecArray) {
                this.put(maltegoEntitySpec);
            }
        }

        public MaltegoEntitySpec get(String string) {
            return this._items.get(string);
        }

        public Collection<MaltegoEntitySpec> getAll() {
            return this._items.values();
        }

        public void put(MaltegoEntitySpec maltegoEntitySpec) {
            this.put(maltegoEntitySpec, maltegoEntitySpec.getDefaultCategory());
        }

        public void put(MaltegoEntitySpec maltegoEntitySpec, String string) {
            if (string == null) {
                string = DEFAULT_FOLDER;
            }
            this._items.put(maltegoEntitySpec.getTypeName(), maltegoEntitySpec);
            this._folders.put(maltegoEntitySpec.getTypeName(), string);
            this.fireTypeAdded((TypeSpec)maltegoEntitySpec);
        }

        public void remove(String string) {
            MaltegoEntitySpec maltegoEntitySpec = this.get(string);
            if (maltegoEntitySpec != null) {
                this._items.remove(string);
                this.fireTypeRemoved((TypeSpec)maltegoEntitySpec);
            }
        }

        public boolean contains(String string) {
            return this._items.containsKey(string);
        }

        public String[] allCategories() {
            return this._folders.values().toArray(new String[this._folders.size()]);
        }
    }

    public static class Proxy
    extends EntityRegistry {
        private EntityRegistry[] _registries;

        public Proxy(EntityRegistry ... entityRegistryArray) {
            this._registries = entityRegistryArray;
        }

        public MaltegoEntitySpec get(String string) {
            for (EntityRegistry entityRegistry : this._registries) {
                MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)entityRegistry.get(string);
                if (maltegoEntitySpec == null) continue;
                return maltegoEntitySpec;
            }
            return null;
        }

        public Collection<MaltegoEntitySpec> getAll() {
            HashSet<MaltegoEntitySpec> hashSet = new HashSet<MaltegoEntitySpec>();
            for (EntityRegistry entityRegistry : this._registries) {
                hashSet.addAll(entityRegistry.getAll());
            }
            return hashSet;
        }

        public void put(MaltegoEntitySpec maltegoEntitySpec) {
            throw new UnsupportedOperationException("Object is read-only");
        }

        public void put(MaltegoEntitySpec maltegoEntitySpec, String string) {
            throw new UnsupportedOperationException("Object is read-only");
        }

        public void remove(String string) {
            throw new UnsupportedOperationException("Object is read-only");
        }

        public boolean contains(String string) {
            for (EntityRegistry entityRegistry : this._registries) {
                if (!entityRegistry.contains(string)) continue;
                return true;
            }
            return false;
        }

        public String[] allCategories() {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (EntityRegistry entityRegistry : this._registries) {
                for (String string : entityRegistry.allCategories()) {
                    treeSet.add(string);
                }
            }
            return treeSet.toArray(new String[treeSet.size()]);
        }
    }

    private static class DefaultEntityRegistry
    extends EntityRegistry {
        private DefaultEntityRegistry() {
        }

        public MaltegoEntitySpec get(String string) {
            return null;
        }

        public Collection<MaltegoEntitySpec> getAll() {
            return new ArrayList<MaltegoEntitySpec>();
        }

        public void put(MaltegoEntitySpec maltegoEntitySpec, String string) {
        }

        public void remove(String string) {
        }

        public boolean contains(String string) {
            return false;
        }

        public String[] allCategories() {
            return new String[0];
        }

        public void put(MaltegoEntitySpec maltegoEntitySpec) {
        }
    }

    private static class RegistryDataProvider
    implements K {
        private EntityRegistry _registry;

        public RegistryDataProvider(EntityRegistry entityRegistry) {
            this._registry = entityRegistry;
        }

        public EntityRegistry getRegistry() {
            return this._registry;
        }

        public Object get(Object object) {
            String string = (String)object;
            return this._registry.get(string);
        }

        public int getInt(Object object) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public double getDouble(Object object) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public boolean getBool(Object object) {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

