/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.reporting.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chapter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.imgfactory.ImageFactory;
import com.paterva.maltego.reporting.pdf.DefaultiTextStyle;
import com.paterva.maltego.reporting.pdf.ReportGenerator;
import com.paterva.maltego.reporting.pdf.iTextStyle;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.EntityColorFactory;
import com.paterva.maltego.ui.graph.EntityImageFactory;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import com.paterva.maltego.ui.graph.view2d.Graph2DViewExporter;
import com.paterva.maltego.util.ui.look.ColorUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import yguard.A.A.D;
import yguard.A.A.Y;
import yguard.A.A.Z;
import yguard.A.I.QA;
import yguard.A.I.S;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfReportGenerator
implements ReportGenerator {
    private static final Color UNKNOWN_TYPE_COLOR = Color.LIGHT_GRAY;
    private static iTextStyle _style = new DefaultiTextStyle();
    private static Font _chapterTitleFont = FontFactory.getFont("Helvetica", 18.0f, 1, Color.DARK_GRAY);
    private Document _doc;
    private GraphNodeManager _nodeManager;
    private List<File> _tempFiles;
    private PdfWriter _writer;
    private Map<String, Image> _imagesByType;
    private Map<Object, Image> _imagesByObject;
    private Image _footerImage;
    private S _view;
    private int _chapter;
    private EntityRegistry _registry;

    /*
     * Exception decompiling
     */
    @Override
    public boolean generateReport(File var1_1, S var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Rectangle getPageDrawSize() {
        Rectangle rectangle = this._doc.getPageSize();
        Rectangle rectangle2 = new Rectangle(rectangle.getWidth() - this._doc.leftMargin() - this._doc.rightMargin(), rectangle.getHeight() - this._doc.bottomMargin() - this._doc.topMargin());
        return rectangle2;
    }

    private void addWhiteSpace(float f) throws DocumentException {
        Paragraph paragraph = new Paragraph(" ");
        paragraph.setLeading(0.0f);
        paragraph.setSpacingAfter(f);
        this._doc.add(paragraph);
    }

    private void createTitlePage() throws IOException, DocumentException, BadElementException {
        Font font = FontFactory.getFont("Helvetica", 42.0f, 4, Color.DARK_GRAY);
        Font font2 = FontFactory.getFont("Helvetica", 36.0f, 2, Color.DARK_GRAY);
        this.addWhiteSpace(60.0f);
        PdfPTable pdfPTable = new PdfPTable(3);
        pdfPTable.setWidthPercentage(100.0f);
        pdfPTable.setWidths(new float[]{0.3f, 0.4f, 0.3f});
        pdfPTable.getDefaultCell().setBorder(0);
        pdfPTable.getDefaultCell().setHorizontalAlignment(1);
        pdfPTable.addCell(" ");
        pdfPTable.addCell(this.javaToPdfImage(ImageUtilities.loadImage((String)"com/paterva/maltego/reporting/resources/ReportTitle.png")));
        pdfPTable.completeRow();
        this._doc.add(pdfPTable);
        this.addWhiteSpace(20.0f);
        Paragraph paragraph = new Paragraph("Maltego investigation", font);
        paragraph.setAlignment(1);
        this._doc.add(paragraph);
        this.addWhiteSpace(20.0f);
        DataObject dataObject = (DataObject)GraphEditorRegistry.getDefault().getTopmost().getLookup().lookup(DataObject.class);
        Paragraph paragraph2 = new Paragraph(dataObject.getName(), font2);
        paragraph2.setAlignment(1);
        this._doc.add(paragraph2);
        this._doc.newPage();
    }

    private void createGraphImage() throws DocumentException, BadElementException, IOException {
        Graph2DViewExporter graph2DViewExporter = new Graph2DViewExporter(this._view);
        File file = File.createTempFile("tmp", ".jpg", new File(System.getProperty("java.io.tmpdir")));
        double d = 2.0;
        if (this._view.H().\u00e1() > 200) {
            d = 0.5;
        } else if (this._view.H().\u00e1() > 100) {
            d = 1.0;
        }
        graph2DViewExporter.exportToFile(file, d);
        this._tempFiles.add(file);
        Image image = Image.getInstance(file.getPath());
        image.scaleToFit(this.getPageDrawSize().getWidth(), this.getPageDrawSize().getHeight());
        this._doc.add(image);
        this._doc.newPage();
    }

    private void createRankTables(List<Y> list) throws DocumentException {
        Paragraph paragraph = new Paragraph("Top 10 Entities", _chapterTitleFont);
        Chapter chapter = new Chapter(paragraph, this._chapter++);
        chapter.add(this.createSummaryTable(this._view.H()));
        chapter.add(this.createRankTable(list, Rank.RANK_IN_LINKS, 10));
        chapter.add(this.createRankTable(list, Rank.RANK_OUT_LINKS, 10));
        chapter.add(this.createRankTable(list, Rank.RANK_TOTAL_LINKS, 10));
        this._doc.add(chapter);
    }

    private void createTypeTables(List<Y> list) throws DocumentException {
        Paragraph paragraph = new Paragraph("Entities by Type", _chapterTitleFont);
        Chapter chapter = new Chapter(paragraph, this._chapter++);
        HashMap hashMap = new HashMap();
        for (Y object : list) {
            Object object2;
            MaltegoEntitySpec maltegoEntitySpec = this.getMaltegoEntitySpec(object);
            MaltegoEntity maltegoEntity = this.getMaltegoEntity(object);
            String string = InheritanceHelper.getDisplayValue((SpecRegistry)this._registry, (TypedPropertyBag)maltegoEntity).toString();
            Object object3 = object2 = maltegoEntitySpec != null ? maltegoEntitySpec : maltegoEntity.getTypeName();
            if (!hashMap.containsKey(object2)) {
                hashMap.put((MaltegoEntitySpec)object2, new ArrayList());
            }
            ((List)hashMap.get(object2)).add(string);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            chapter.add(this.createEntityTypeTable(entry.getKey(), (List)entry.getValue()));
        }
        this._doc.add(chapter);
    }

    private void createEntityTables(List<Y> list) throws IOException, DocumentException {
        Paragraph paragraph = new Paragraph("Entity Details", _chapterTitleFont);
        Chapter chapter = new Chapter(paragraph, this._chapter++);
        for (Y y : list) {
            PdfPTable pdfPTable = new PdfPTable(1);
            pdfPTable.setSpacingBefore(10.0f);
            pdfPTable.setSpacingAfter(10.0f);
            pdfPTable.setKeepTogether(false);
            pdfPTable.setExtendLastRow(false);
            pdfPTable.setWidthPercentage(100.0f);
            pdfPTable.getDefaultCell().setPadding(3.0f);
            pdfPTable.getDefaultCell().setBorderColor(Color.LIGHT_GRAY);
            pdfPTable.getDefaultCell().setBorder(13);
            pdfPTable.addCell(this.createNodeHeaderTable(y));
            pdfPTable.getDefaultCell().setBorder(12);
            pdfPTable.addCell(this.createNodePropertiesTable(y));
            pdfPTable.getDefaultCell().setBorder(14);
            pdfPTable.addCell(this.createNodeLinksTable(y));
            chapter.add(pdfPTable);
        }
        this._doc.add(chapter);
    }

    private PdfPTable createSummaryTable(QA qA) throws DocumentException {
        PdfPTable pdfPTable = new PdfPTable(2);
        pdfPTable.setSpacingBefore(20.0f);
        pdfPTable.setWidthPercentage(40.0f);
        pdfPTable.setWidths(new float[]{0.8f, 0.2f});
        pdfPTable.setHorizontalAlignment(0);
        pdfPTable.addCell(_style.getCell("Total number of entities", false));
        pdfPTable.addCell(_style.getCell(qA.\u00e1(), false));
        pdfPTable.addCell(_style.getCell("Total number of entities", false));
        pdfPTable.addCell(_style.getCell(qA.\u00da(), false));
        return pdfPTable;
    }

    private PdfPTable createRankTable(List<Y> list, final Rank rank, int n) throws BadElementException, DocumentException {
        Font font = FontFactory.getFont("Helvetica", 12.0f, 1, Color.DARK_GRAY);
        Collections.sort(list, new Comparator<Y>(){

            @Override
            public int compare(Y y, Y y2) {
                switch (rank) {
                    case RANK_IN_LINKS: {
                        return y2.M().size() - y.M().size();
                    }
                    case RANK_OUT_LINKS: {
                        return y2.G().size() - y.G().size();
                    }
                    case RANK_TOTAL_LINKS: {
                        return y2.I().size() - y.I().size();
                    }
                }
                return PdfReportGenerator.this.getMaltegoEntity(y2).getWeight() - PdfReportGenerator.this.getMaltegoEntity(y).getWeight();
            }
        });
        PdfPTable pdfPTable = new PdfPTable(4);
        pdfPTable.setSpacingBefore(20.0f);
        pdfPTable.setWidthPercentage(100.0f);
        pdfPTable.setWidths(new float[]{0.8f, 3.0f, 4.5f, 1.7f});
        PdfPCell pdfPCell = new PdfPCell();
        pdfPCell.setColspan(4);
        pdfPCell.setHorizontalAlignment(1);
        pdfPCell.setBorder(0);
        pdfPCell.setPaddingBottom(5.0f);
        switch (rank) {
            case RANK_IN_LINKS: {
                pdfPCell.setPhrase(new Paragraph("Ranked by Incoming Links", font));
                break;
            }
            case RANK_OUT_LINKS: {
                pdfPCell.setPhrase(new Paragraph("Ranked by Outgoing Links", font));
                break;
            }
            case RANK_TOTAL_LINKS: {
                pdfPCell.setPhrase(new Paragraph("Ranked by Total Links", font));
                break;
            }
            default: {
                pdfPCell.setPhrase(new Paragraph("Ranked by Weight", font));
            }
        }
        pdfPTable.addCell(pdfPCell);
        pdfPTable.addCell(_style.getCell("Rank", true));
        pdfPTable.addCell(_style.getCell("Type", true));
        pdfPTable.addCell(_style.getCell("Value", true));
        String string = null;
        switch (rank) {
            case RANK_IN_LINKS: {
                string = "Incoming links";
                break;
            }
            case RANK_OUT_LINKS: {
                string = "Outgoing links";
                break;
            }
            case RANK_TOTAL_LINKS: {
                string = "Total links";
                break;
            }
            default: {
                string = "Weight";
            }
        }
        pdfPTable.addCell(_style.getCell(string, true));
        int n2 = 1;
        for (Y y : list) {
            pdfPTable.addCell(_style.getCell(n2++, false));
            MaltegoEntitySpec maltegoEntitySpec = this.getMaltegoEntitySpec(y);
            MaltegoEntity maltegoEntity = this.getMaltegoEntity(y);
            String string2 = maltegoEntitySpec != null ? maltegoEntitySpec.getDisplayName() : maltegoEntity.getTypeName();
            PdfPCell pdfPCell2 = _style.getCell(string2, false);
            pdfPCell2.setBackgroundColor(this.getEntityTypeColor(maltegoEntitySpec));
            pdfPTable.addCell(pdfPCell2);
            pdfPTable.addCell(_style.getCell(InheritanceHelper.getDisplayValue((SpecRegistry)this._registry, (TypedPropertyBag)maltegoEntity), false));
            int n3 = 0;
            switch (rank) {
                case RANK_IN_LINKS: {
                    n3 = y.M().size();
                    break;
                }
                case RANK_OUT_LINKS: {
                    n3 = y.G().size();
                    break;
                }
                case RANK_TOTAL_LINKS: {
                    n3 = y.I().size();
                    break;
                }
                default: {
                    n3 = this.getMaltegoEntity(y).getWeight();
                }
            }
            pdfPTable.addCell(_style.getCell(n3, false));
            if (n2 <= n) continue;
            break;
        }
        return pdfPTable;
    }

    private PdfPTable createEntityTypeTable(Object object, List<String> list) throws DocumentException {
        Object object2;
        PdfPTable pdfPTable = new PdfPTable(2);
        pdfPTable.setSpacingBefore(20.0f);
        pdfPTable.setWidthPercentage(100.0f);
        PdfPCell pdfPCell = _style.getCell(" ", false);
        pdfPTable.getDefaultCell().setBorder(pdfPCell.getBorder());
        pdfPTable.getDefaultCell().setBackgroundColor(pdfPCell.getBackgroundColor());
        String string = null;
        Color color = null;
        if (object instanceof MaltegoEntitySpec) {
            object2 = (MaltegoEntitySpec)object;
            string = object2.getDisplayNamePlural();
            color = this.getEntityTypeColor((MaltegoEntitySpec)object2);
        } else {
            string = object.toString();
            color = this.getEntityTypeColor(null);
        }
        object2 = _style.getCell(string + " (" + list.size() + ")", true);
        ((Rectangle)object2).setBackgroundColor(color);
        ((PdfPCell)object2).setColspan(2);
        pdfPTable.addCell((PdfPCell)object2);
        for (String string2 : list) {
            pdfPTable.addCell(_style.getCell(string2, false));
        }
        pdfPTable.completeRow();
        return pdfPTable;
    }

    private PdfPTable createNodeHeaderTable(Y y) throws BadElementException, IOException, DocumentException {
        int n = 48;
        PdfPTable pdfPTable = new PdfPTable(2);
        pdfPTable.setSpacingBefore(20.0f);
        pdfPTable.setWidthPercentage(100.0f);
        pdfPTable.setWidths(new float[]{0.2f, 0.8f});
        PdfPCell pdfPCell = _style.getCell(this.getEntityImage(y, 48, 48), true);
        pdfPCell.setHorizontalAlignment(1);
        pdfPCell.setRowspan(3);
        pdfPTable.addCell(pdfPCell);
        MaltegoEntity maltegoEntity = this.getMaltegoEntity(y);
        MaltegoEntitySpec maltegoEntitySpec = this.getMaltegoEntitySpec(y);
        String string = maltegoEntitySpec != null ? maltegoEntitySpec.getDisplayName() : maltegoEntity.getTypeName();
        String string2 = maltegoEntitySpec != null ? maltegoEntitySpec.getTypeName() : maltegoEntity.getTypeName();
        Font font = FontFactory.getFont("Helvetica", 12.0f, 0, new Color(0x999999));
        Paragraph paragraph = new Paragraph(string, font);
        pdfPTable.addCell(_style.getCell(paragraph, true));
        font = FontFactory.getFont("Helvetica", 10.0f, 0, new Color(0x999999));
        paragraph = new Paragraph(string2, font);
        pdfPTable.addCell(_style.getCell(paragraph, true));
        font = FontFactory.getFont("Helvetica", 16.0f, 0, new Color(6065035));
        paragraph = new Paragraph(InheritanceHelper.getDisplayValue((SpecRegistry)this._registry, (TypedPropertyBag)maltegoEntity).toString(), font);
        pdfPCell = _style.getCell(paragraph, true);
        pdfPCell.setPaddingBottom(5.0f);
        pdfPTable.addCell(pdfPCell);
        return pdfPTable;
    }

    private PdfPTable createNodePropertiesTable(Y y) throws DocumentException {
        PdfPTable pdfPTable = new PdfPTable(3);
        pdfPTable.setWidthPercentage(95.0f);
        pdfPTable.setWidths(new float[]{0.05f, 0.4f, 0.55f});
        Node node = this._nodeManager.getNode(y);
        for (Node.PropertySet propertySet : node.getPropertySets()) {
            for (Node.Property property : propertySet.getProperties()) {
                String string = property.getName();
                String string2 = property.getDisplayName();
                if (string.equals("maltego.fixed.type") || string.equals("maltego.calculated.value")) continue;
                String string3 = "";
                try {
                    if (property.getValue() != null) {
                        string3 = property.getValue().toString();
                    }
                    PdfPCell pdfPCell = new PdfPCell();
                    pdfPCell.setBorder(0);
                    pdfPTable.addCell(pdfPCell);
                    pdfPTable.addCell(_style.getCell(string2, false));
                    pdfPTable.addCell(_style.getCell(string3, false));
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
        return pdfPTable;
    }

    private PdfPTable createNodeLinksTable(Y y) throws DocumentException, IOException {
        String string;
        MaltegoEntitySpec maltegoEntitySpec;
        MaltegoEntity maltegoEntity;
        Y y2;
        Z z;
        PdfPCell pdfPCell;
        int n = (int)_style.getFontSize(false) + 2;
        if (y.I().size() == 0) {
            return null;
        }
        PdfPTable pdfPTable = new PdfPTable(3);
        pdfPTable.setSpacingBefore(5.0f);
        pdfPTable.setWidthPercentage(100.0f);
        pdfPTable.setWidths(new float[]{0.05f, 0.4f, 0.55f});
        pdfPTable.setHorizontalAlignment(2);
        if (y.M().size() > 0) {
            pdfPCell = _style.getCell("Incoming (" + y.M().size() + ")", true);
            pdfPCell.setColspan(3);
            pdfPTable.addCell(pdfPCell);
            z = y.M();
            while (z.ok()) {
                y2 = z.edge().X();
                pdfPCell = _style.getCell(this.getEntityImage(y2, n, n), false);
                pdfPCell.setHorizontalAlignment(1);
                pdfPTable.addCell(pdfPCell);
                maltegoEntity = this.getMaltegoEntity(y2);
                maltegoEntitySpec = this.getMaltegoEntitySpec(y2);
                string = maltegoEntitySpec != null ? maltegoEntitySpec.getDisplayName() : maltegoEntity.getTypeName();
                pdfPCell = _style.getCell(string, false);
                pdfPCell.setBackgroundColor(this.getEntityTypeColor(maltegoEntitySpec));
                pdfPTable.addCell(pdfPCell);
                pdfPTable.addCell(_style.getCell(InheritanceHelper.getDisplayValue((SpecRegistry)this._registry, (TypedPropertyBag)maltegoEntity), false));
                z.next();
            }
        }
        if (y.G().size() > 0) {
            pdfPCell = _style.getCell("Outgoing (" + y.G().size() + ")", true);
            pdfPCell.setColspan(3);
            pdfPTable.addCell(pdfPCell);
            z = y.G();
            while (z.ok()) {
                y2 = z.edge().V();
                pdfPCell = _style.getCell(this.getEntityImage(y2, n, n), false);
                pdfPCell.setHorizontalAlignment(1);
                pdfPTable.addCell(pdfPCell);
                maltegoEntity = this.getMaltegoEntity(y2);
                maltegoEntitySpec = this.getMaltegoEntitySpec(y2);
                string = maltegoEntitySpec != null ? maltegoEntitySpec.getDisplayName() : maltegoEntity.getTypeName();
                pdfPCell = _style.getCell(string, false);
                pdfPCell.setBackgroundColor(this.getEntityTypeColor(maltegoEntitySpec));
                pdfPTable.addCell(pdfPCell);
                pdfPTable.addCell(_style.getCell(InheritanceHelper.getDisplayValue((SpecRegistry)this._registry, (TypedPropertyBag)maltegoEntity), false));
                z.next();
            }
        }
        return pdfPTable;
    }

    private MaltegoEntity getMaltegoEntity(Y y) {
        return (MaltegoEntity)this._nodeManager.getNode(y).getLookup().lookup(MaltegoEntity.class);
    }

    private MaltegoEntitySpec getMaltegoEntitySpec(Y y) {
        return (MaltegoEntitySpec)this._nodeManager.getNode(y).getLookup().lookup(MaltegoEntitySpec.class);
    }

    private Color getEntityTypeColor(MaltegoEntitySpec maltegoEntitySpec) {
        if (maltegoEntitySpec != null) {
            Color color = EntityColorFactory.getDefault().getTypeColor(maltegoEntitySpec.getTypeName());
            return ColorUtils.getLighter((Color)color, (double)0.75);
        }
        return UNKNOWN_TYPE_COLOR;
    }

    private Image getEntityImage(Y y, int n, int n2) throws IOException, BadElementException {
        MaltegoEntity maltegoEntity = this.getMaltegoEntity(y);
        EntityImageFactory entityImageFactory = EntityImageFactory.forGraph((D)y.H());
        java.awt.Image image = null;
        Object object = InheritanceHelper.getImage((EntityRegistry)this._registry, (MaltegoEntity)maltegoEntity);
        Image image2 = null;
        boolean bl = false;
        if (object == null) {
            bl = true;
        } else if (this._imagesByObject.containsKey(object)) {
            image2 = this._imagesByObject.get(object);
        } else {
            image = ImageFactory.getDefault().getImage(object, -1, -1, null);
            if (image == null) {
                bl = true;
            } else {
                image2 = this.javaToPdfImage(image);
                this._imagesByObject.put(object, image2);
            }
        }
        if (bl) {
            if (this._imagesByType.containsKey(maltegoEntity.getTypeName())) {
                image2 = this._imagesByType.get(maltegoEntity.getTypeName());
            } else {
                image = entityImageFactory.getTypeImage(maltegoEntity.getTypeName(), -1, -1, null);
                image2 = this.javaToPdfImage(image);
                this._imagesByType.put(maltegoEntity.getTypeName(), image2);
            }
        }
        image2.scaleToFit(n, n2);
        return image2;
    }

    private Image javaToPdfImage(java.awt.Image image) throws IOException, BadElementException {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        File file = File.createTempFile("tmp", ".png", new File(System.getProperty("java.io.tmpdir")));
        ImageIO.write((RenderedImage)bufferedImage, "png", file);
        this._tempFiles.add(file);
        Image image2 = Image.getInstance(file.getPath());
        return image2;
    }

    private class EndPage
    extends PdfPageEventHelper {
        private EndPage() {
        }

        public void onEndPage(PdfWriter pdfWriter, Document document) {
            int n = document.getPageNumber();
            if (n == 1) {
                return;
            }
            Rectangle rectangle = document.getPageSize();
            Font font = FontFactory.getFont("Helvetica", 10.0f, 0, Color.LIGHT_GRAY);
            PdfPTable pdfPTable = new PdfPTable(1);
            pdfPTable.setWidthPercentage(100.0f);
            PdfPCell pdfPCell = new PdfPCell(new Paragraph(Integer.toString(n), font));
            pdfPCell.setHorizontalAlignment(1);
            pdfPCell.setBorder(0);
            pdfPCell.setVerticalAlignment(4);
            pdfPTable.addCell(pdfPCell);
            pdfPTable.setTotalWidth(rectangle.getWidth() - document.leftMargin() - document.rightMargin());
            pdfPTable.writeSelectedRows(0, -1, document.leftMargin(), document.bottomMargin() - 10.0f, pdfWriter.getDirectContent());
            pdfPTable = new PdfPTable(2);
            pdfPTable.setWidthPercentage(100.0f);
            try {
                pdfPTable.setWidths(new float[]{0.92f, 0.08f});
            }
            catch (DocumentException documentException) {
                Exceptions.printStackTrace((Throwable)documentException);
            }
            try {
                if (PdfReportGenerator.this._footerImage == null) {
                    PdfReportGenerator.this._footerImage = PdfReportGenerator.this.javaToPdfImage(ImageUtilities.loadImage((String)"com/paterva/maltego/ui/graph/view2d/PrintFooter.png"));
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (BadElementException badElementException) {
                Exceptions.printStackTrace((Throwable)badElementException);
            }
            pdfPCell = new PdfPCell(new Paragraph("Generated with " + System.getProperty("maltego.product-name") + " " + System.getProperty("maltego.displayversion"), font));
            pdfPCell.setHorizontalAlignment(2);
            pdfPCell.setBorder(0);
            pdfPCell.setVerticalAlignment(6);
            pdfPTable.addCell(pdfPCell);
            pdfPCell = new PdfPCell(PdfReportGenerator.this._footerImage);
            pdfPCell.setBorder(0);
            pdfPTable.addCell(pdfPCell);
            pdfPTable.setTotalWidth(rectangle.getWidth() - document.leftMargin() - document.rightMargin());
            pdfPTable.writeSelectedRows(0, -1, document.leftMargin(), document.bottomMargin() - 10.0f, pdfWriter.getDirectContent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Rank {
        RANK_IN_LINKS,
        RANK_OUT_LINKS,
        RANK_TOTAL_LINKS,
        RANK_WEIGHT;

    }
}

