/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout.view;

import com.paterva.maltego.layout.LayoutFactory;
import com.paterva.maltego.layout.view.InteractiveLayoutViewHandler;
import com.paterva.maltego.layout.view.LayoutHandler;
import com.paterva.maltego.layout.view.LayoutViewToolbar;
import com.paterva.maltego.layout.view.OnceOffLayoutViewHandler;
import com.paterva.maltego.ui.graph.view2d.BendClearingMoveMode;
import com.paterva.maltego.ui.graph.view2d.DefaultGraph2DViewAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JComponent;
import yguard.A.A.Y;
import yguard.A.I.QA;
import yguard.A.I.fB;
import yguard.A.I.rA;

public class LayoutViewAdapter
extends DefaultGraph2DViewAdapter {
    protected LayoutViewToolbar _toolbar;
    private OnceOffLayoutViewHandler _onceOffHandler;
    private InteractiveLayoutViewHandler _interactiveHandler;
    private rA _editMode;
    private LayoutFactory.LayoutMode _layoutMode;
    private boolean _layoutAll;
    private boolean _freezeLayout = false;

    public void prepareToShow() {
        super.prepareToShow();
        this.getLayoutHandler().prepareToShow();
    }

    protected void onGraphChanged(QA qA, QA qA2) {
        super.onGraphChanged(qA, qA2);
        this.getOnceOffLayouter().onGraphChanged(qA, qA2);
        this.getInteractiveLayouter().onGraphChanged(qA, qA2);
        this.updateEditMode();
    }

    public void onGraphUpdated(Set<Y> set, boolean bl) {
        this.getLayoutHandler().onGraphUpdated(set);
    }

    public void componentShowing() {
        super.componentShowing();
        this.getOnceOffLayouter().onComponentShowing();
        this.getInteractiveLayouter().onComponentShowing();
        this.updateEditMode();
    }

    public void componentHidden() {
        super.componentHidden();
        this.getOnceOffLayouter().onComponentHidden();
        this.getInteractiveLayouter().onComponentHidden();
    }

    public void componentClosed() {
        super.componentClosed();
        this.getOnceOffLayouter().onComponentClosed();
        this.getInteractiveLayouter().onComponentClosed();
    }

    protected rA createEditMode() {
        this._editMode = super.createEditMode();
        return this._editMode;
    }

    public boolean getLayoutAll() {
        return this._layoutAll;
    }

    public LayoutFactory.LayoutMode getLayoutMode() {
        return this._layoutMode;
    }

    public void setLayoutMode(LayoutFactory.LayoutMode layoutMode, boolean bl, boolean bl2) {
        boolean bl3 = LayoutFactory.isInteractive(layoutMode);
        boolean bl4 = false;
        if (bl2 || layoutMode != this._layoutMode || !bl3 && bl != this._layoutAll) {
            OnceOffLayoutViewHandler onceOffLayoutViewHandler = this.getOnceOffLayouter();
            InteractiveLayoutViewHandler interactiveLayoutViewHandler = this.getInteractiveLayouter();
            if (bl3) {
                onceOffLayoutViewHandler.setLayoutMode(null, true, false);
                interactiveLayoutViewHandler.setLayoutMode(layoutMode);
            } else {
                onceOffLayoutViewHandler.setLayoutMode(layoutMode, bl, bl && !this._freezeLayout);
                interactiveLayoutViewHandler.setLayoutMode(null);
            }
            bl4 = true;
        }
        this._layoutMode = layoutMode;
        this._layoutAll = bl;
        if (bl4) {
            this.updateEditMode();
        }
    }

    private void updateEditMode() {
        if (LayoutFactory.isInteractive(this._layoutMode)) {
            this._editMode.setMoveSelectionMode(this.getInteractiveLayouter().getMoveSelectionMode());
        } else {
            this._editMode.setMoveSelectionMode((fB)new BendClearingMoveMode());
        }
    }

    public JComponent getToolbar() {
        return this.getLayoutToolbar();
    }

    protected LayoutFactory.LayoutMode getDefaultLayoutMode() {
        return LayoutFactory.LayoutMode.BLOCK;
    }

    public LayoutViewToolbar getLayoutToolbar() {
        if (this._toolbar == null) {
            boolean bl = "true".equals(System.getProperty("maltego.hide-mining-layout-buttons", "false"));
            boolean bl2 = !bl;
            LayoutFactory.LayoutMode layoutMode = this.getDefaultLayoutMode();
            this._toolbar = new LayoutViewToolbar(bl);
            this._toolbar.setLayoutMode(layoutMode);
            this._toolbar.setLayoutAll(bl2);
            this._toolbar.setFloatable(false);
            this._toolbar.addPropertyChangeListener(new ToolbarListener());
            this.setLayoutMode(layoutMode, bl2, false);
        }
        return this._toolbar;
    }

    private LayoutHandler getLayoutHandler() {
        if (LayoutFactory.isInteractive(this._layoutMode)) {
            return this.getInteractiveLayouter();
        }
        return this.getOnceOffLayouter();
    }

    private OnceOffLayoutViewHandler getOnceOffLayouter() {
        if (this._onceOffHandler == null) {
            this._onceOffHandler = new OnceOffLayoutViewHandler(this.getView());
        }
        return this._onceOffHandler;
    }

    private InteractiveLayoutViewHandler getInteractiveLayouter() {
        if (this._interactiveHandler == null) {
            this._interactiveHandler = new InteractiveLayoutViewHandler(this.getView());
        }
        return this._interactiveHandler;
    }

    public void setFreezeLayout(boolean bl) {
        this._freezeLayout = bl;
    }

    protected class ToolbarListener
    implements PropertyChangeListener {
        protected ToolbarListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("layoutModeChanged".equals(propertyChangeEvent.getPropertyName()) || "layoutAllOrNewChanged".equals(propertyChangeEvent.getPropertyName())) {
                LayoutViewToolbar layoutViewToolbar = LayoutViewAdapter.this.getLayoutToolbar();
                LayoutFactory.LayoutMode layoutMode = layoutViewToolbar.getLayoutMode();
                boolean bl = layoutViewToolbar.isLayoutAll();
                LayoutViewAdapter.this.setLayoutMode(layoutMode, bl, true);
            }
        }
    }
}

