/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.TransformSettingsWrapper;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.repository.serializer.TransformSettingsSerializer;
import com.paterva.maltego.util.XmlSerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TransformSettingsEntry
extends Entry<TransformSettings> {
    public static final String DefaultFolder = "TransformRepositories";
    public static final String Type = "transformsettings";

    public TransformSettingsEntry(TransformDefinition transformDefinition) {
        super(transformDefinition, "TransformRepositories/" + transformDefinition.getRepositoryName(), transformDefinition.getName() + "." + Type, transformDefinition.getName());
    }

    public TransformSettingsEntry(String string) {
        super(string);
    }

    @Override
    protected TransformSettings read(InputStream inputStream) throws IOException {
        try {
            TransformSettings transformSettings = new TransformSettingsSerializer().read(inputStream);
            TransformSettingsWrapper transformSettingsWrapper = new TransformSettingsWrapper(transformSettings, this.getTypeName());
            return transformSettingsWrapper;
        }
        catch (XmlSerializationException xmlSerializationException) {
            throw new IOException(xmlSerializationException);
        }
    }

    @Override
    protected void write(TransformSettings transformSettings, OutputStream outputStream) throws IOException {
        if (transformSettings instanceof TransformDefinition) {
            TransformDefinition transformDefinition = (TransformDefinition)transformSettings;
            new TransformSettingsSerializer().write(transformDefinition, outputStream, true);
        }
    }
}

