/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.repository.serializer.TransformDefinitionSerializer;
import com.paterva.maltego.util.XmlSerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TransformDefinitionEntry
extends Entry<TransformDefinition> {
    public static final String DefaultFolder = "TransformRepositories";
    public static final String Type = "definition";

    public TransformDefinitionEntry(TransformDefinition transformDefinition) {
        super(transformDefinition, "TransformRepositories/" + transformDefinition.getRepositoryName(), transformDefinition.getName() + "." + Type, transformDefinition.getName());
    }

    public TransformDefinitionEntry(String string) {
        super(string);
    }

    @Override
    protected TransformDefinition read(InputStream inputStream) throws IOException {
        String string = this.getFolder();
        String string2 = string.substring(string.indexOf("/") + 1);
        try {
            TransformDefinition transformDefinition = new TransformDefinitionSerializer().read(inputStream);
            transformDefinition.setRepositoryName(string2);
            return transformDefinition;
        }
        catch (XmlSerializationException xmlSerializationException) {
            throw new IOException(xmlSerializationException);
        }
    }

    @Override
    protected void write(TransformDefinition transformDefinition, OutputStream outputStream) throws IOException {
        new TransformDefinitionSerializer().write(transformDefinition, outputStream, true);
    }
}

