/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.transform.descriptor.Popup;
import com.paterva.maltego.transform.descriptor.Status;
import com.paterva.maltego.transform.descriptor.StatusItem;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.descriptor.Visibility;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.StringUtilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class TransformDefinition
extends TransformDescriptor
implements TransformSettings,
StatusItem {
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_DIRTY = "dirty";
    public static final String PROP_DISCLAIMER_ACCEPTED = "disclaimerAccepted";
    public static final String PROP_INPUT_VISIBILITY_CHANGED = "inputVisibilityChanged";
    public static final String PROP_INPUT_POPUP_CHANGED = "inputPopupChanged";
    private TransformSettings _settings;
    private String _repositoryName;
    private Collection<PropertyChangeListener> _listeners;

    public TransformDefinition(TransformDescriptor transformDescriptor, TransformSettings transformSettings) {
        super(transformDescriptor);
        this._settings = transformSettings;
    }

    @Override
    public boolean isEnabled() {
        return this._settings.isEnabled();
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.isEnabled() != bl) {
            this._settings.setEnabled(bl);
            this.firePropertyChange(PROP_ENABLED, !bl, bl);
        }
    }

    @Override
    public boolean isDisclaimerAccepted() {
        return this._settings.isDisclaimerAccepted();
    }

    @Override
    public void setDisclaimerAccepted(boolean bl) {
        if (this.isDisclaimerAccepted() != bl) {
            this._settings.setDisclaimerAccepted(bl);
            this.firePropertyChange(PROP_DISCLAIMER_ACCEPTED, !bl, bl);
        }
    }

    public Object getValue(PropertyDescriptor propertyDescriptor) {
        DisplayDescriptor displayDescriptor;
        Object object = this._settings.getValue(propertyDescriptor);
        if (object == null && (displayDescriptor = this.getProperties().get(propertyDescriptor.getName())) != null) {
            return displayDescriptor.getDefaultValue();
        }
        return object;
    }

    public void setValue(PropertyDescriptor propertyDescriptor, Object object) {
        Object object2 = this.getValue(propertyDescriptor);
        if (object != object2) {
            this._settings.setValue(propertyDescriptor, object);
            this.firePropertyChange(propertyDescriptor.getName(), object2, object);
        }
    }

    @Override
    public Popup getPopup(PropertyDescriptor propertyDescriptor) {
        DisplayDescriptor displayDescriptor;
        Popup popup = this._settings.getPopup(propertyDescriptor);
        if (popup == Popup.NotSet && (displayDescriptor = this.getProperties().get(propertyDescriptor.getName())) != null) {
            if (displayDescriptor.isPopup()) {
                return Popup.Yes;
            }
            if (!displayDescriptor.isNullable() && this.isNull(this.getValue((PropertyDescriptor)displayDescriptor))) {
                return Popup.Yes;
            }
            return Popup.No;
        }
        return popup;
    }

    private boolean showPopup(PropertyDescriptor propertyDescriptor) {
        Popup popup = this._settings.getPopup(propertyDescriptor);
        if (popup == Popup.Yes) {
            return true;
        }
        DisplayDescriptor displayDescriptor = this.getProperties().get(propertyDescriptor.getName());
        if (displayDescriptor != null) {
            if (displayDescriptor.isPopup()) {
                return true;
            }
            return !displayDescriptor.isNullable() && this.isNull(this.getValue((PropertyDescriptor)displayDescriptor));
        }
        return true;
    }

    public DisplayDescriptorCollection getPopupProperties() {
        DisplayDescriptorList displayDescriptorList = new DisplayDescriptorList();
        for (DisplayDescriptor displayDescriptor : this.getProperties()) {
            if (!this.showPopup((PropertyDescriptor)displayDescriptor)) continue;
            displayDescriptorList.add((Object)displayDescriptor);
        }
        return displayDescriptorList;
    }

    @Override
    public void setPopup(PropertyDescriptor propertyDescriptor, Popup popup) {
        Popup popup2 = this.getPopup(propertyDescriptor);
        if (popup != popup2) {
            this._settings.setPopup(propertyDescriptor, popup);
            this.firePropertyChange(PROP_INPUT_POPUP_CHANGED, null, null);
        }
    }

    @Override
    public boolean showHelp() {
        return this._settings.showHelp();
    }

    @Override
    public void setShowHelp(boolean bl) {
        this._settings.setShowHelp(bl);
    }

    @Override
    public Visibility getVisibility(PropertyDescriptor propertyDescriptor) {
        Visibility visibility = this._settings.getVisibility(propertyDescriptor);
        return visibility;
    }

    @Override
    public void setVisibility(PropertyDescriptor propertyDescriptor, Visibility visibility) {
        Visibility visibility2 = this.getVisibility(propertyDescriptor);
        if (visibility != visibility2) {
            this._settings.setVisibility(propertyDescriptor, visibility);
            this.firePropertyChange(PROP_INPUT_VISIBILITY_CHANGED, null, null);
        }
    }

    @Override
    public Status getStatus() {
        if (!this.isEnabled()) {
            return Status.Disabled;
        }
        if (!StringUtilities.isNullOrEmpty((String)this.getDisclaimer()) && !this.isDisclaimerAccepted()) {
            return Status.RequiresDisclaimerAccept;
        }
        return Status.Ok;
    }

    public String getRepositoryName() {
        return this._repositoryName;
    }

    public void setRepositoryName(String string) {
        this._repositoryName = string;
    }

    @Override
    public int hashCode() {
        int n = 7;
        n = 97 * n + super.hashCode();
        n = 97 * n + (this._repositoryName != null ? this._repositoryName.hashCode() : 0);
        return n;
    }

    public boolean equals(TransformDefinition transformDefinition) {
        if (transformDefinition == null) {
            return false;
        }
        return super.equals(transformDefinition) && transformDefinition._repositoryName.equals(this._repositoryName);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof TransformDefinition) {
            return this.equals((TransformDefinition)object);
        }
        return false;
    }

    @Override
    public boolean isDirty() {
        return this._settings.isDirty();
    }

    @Override
    public void markClean() {
        boolean bl = this.isDirty();
        this._settings.markClean();
        boolean bl2 = this.isDirty();
        if (bl != bl2) {
            this.firePropertyChange(PROP_DIRTY, bl, bl2);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._listeners == null) {
            this._listeners = Collections.synchronizedCollection(new LinkedList());
        }
        this._listeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._listeners != null) {
            this._listeners.remove(propertyChangeListener);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._listeners != null) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            for (PropertyChangeListener propertyChangeListener : this._listeners) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    private boolean isNull(Object object) {
        if (object instanceof String) {
            return StringUtilities.isNullOrEmpty((String)((String)object));
        }
        return object == null;
    }
}

