/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.core.IDESettings;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.CloneableTopComponent;

public class HtmlBrowserComponent
extends CloneableTopComponent
implements PropertyChangeListener {
    static final long serialVersionUID = 2912844785502987960L;
    private HtmlBrowser browserComponent;
    private HtmlBrowser.Factory browserFactory;
    private String urlToLoad;
    private boolean enableHome = true;
    private boolean enableLocation = true;
    private boolean statusVisible = false;
    private boolean toolbarVisible = true;

    public HtmlBrowserComponent() {
        this(true, false);
    }

    public HtmlBrowserComponent(boolean toolbar, boolean statusLine) {
        this(IDESettings.getWWWBrowser(), toolbar, statusLine);
    }

    private HtmlBrowserComponent(boolean toolbar, boolean statusLine, URL url) {
        this(IDESettings.getWWWBrowser(), toolbar, statusLine);
        this.urlToLoad = null == url ? null : url.toExternalForm();
    }

    public HtmlBrowserComponent(HtmlBrowser.Factory fact, boolean toolbar, boolean statusLine) {
        this.setName("");
        this.setLayout(new BorderLayout());
        this.browserFactory = fact;
        this.setToolTipText(NbBundle.getBundle(HtmlBrowser.class).getString("HINT_WebBrowser"));
        this.setName(NbBundle.getMessage(HtmlBrowserComponent.class, (String)"Title_WebBrowser"));
        this.setDisplayName(NbBundle.getMessage(HtmlBrowserComponent.class, (String)"Title_WebBrowser"));
    }

    public int getPersistenceType() {
        return 1;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("statusMessage".equals(e.getPropertyName())) {
            StatusDisplayer.getDefault().setStatusText(this.browserComponent.getBrowserImpl().getStatusMessage());
            return;
        }
        if ("title".equals(e.getPropertyName())) {
            String title = this.browserComponent.getBrowserImpl().getTitle();
            if (title == null || title.length() < 1) {
                return;
            }
            this.setToolTipText(title);
        }
    }

    public void open() {
        if (null != this.browserComponent && this.browserComponent.getBrowserComponent() == null) {
            return;
        }
        super.open();
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new BrowserReplacer(this);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.setStatusLineVisible(in.readBoolean());
        this.setToolbarVisible(in.readBoolean());
        this.browserComponent.setURL((URL)in.readObject());
    }

    protected CloneableTopComponent createClonedObject() {
        HtmlBrowserComponent bc = new HtmlBrowserComponent(this.browserFactory, this.isToolbarVisible(), this.isStatusLineVisible());
        bc.setURL(this.getDocumentURL());
        return bc;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HtmlBrowserComponent.class);
    }

    protected void componentActivated() {
        Component c;
        HtmlBrowser.Impl impl;
        if (null == this.browserComponent) {
            this.browserComponent = new HtmlBrowser(this.browserFactory, this.toolbarVisible, this.statusVisible);
            this.add((Component)this.browserComponent, "Center");
            this.browserComponent.getBrowserImpl().addPropertyChangeListener((PropertyChangeListener)this);
            if (this.browserComponent.getBrowserComponent() != null) {
                this.putClientProperty("InternalBrowser", Boolean.TRUE);
            }
        }
        if (null != this.browserComponent && null != (impl = this.browserComponent.getBrowserImpl()) && null != (c = impl.getComponent())) {
            c.requestFocusInWindow();
        }
        super.componentActivated();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HtmlBrowserComponent.this.setEnableHome(HtmlBrowserComponent.this.enableHome);
                HtmlBrowserComponent.this.setEnableLocation(HtmlBrowserComponent.this.enableLocation);
                HtmlBrowserComponent.this.setToolbarVisible(HtmlBrowserComponent.this.toolbarVisible);
                HtmlBrowserComponent.this.setStatusLineVisible(HtmlBrowserComponent.this.statusVisible);
                if (null != HtmlBrowserComponent.this.urlToLoad) {
                    HtmlBrowserComponent.this.setURL(HtmlBrowserComponent.this.urlToLoad);
                }
                HtmlBrowserComponent.this.urlToLoad = null;
            }
        });
    }

    protected void componentClosed() {
        if (null != this.browserComponent) {
            this.toolbarVisible = this.isToolbarVisible();
            this.statusVisible = this.isStatusLineVisible();
            URL url = this.browserComponent.getBrowserImpl().getURL();
            this.urlToLoad = null == url ? null : url.toExternalForm();
            this.browserComponent.getBrowserImpl().removePropertyChangeListener((PropertyChangeListener)this);
            this.browserComponent.getBrowserImpl().dispose();
        }
        this.removeAll();
        this.browserComponent = null;
    }

    protected void componentOpened() {
    }

    public Image getIcon() {
        return new ImageIcon(HtmlBrowser.class.getResource("/org/openide/resources/html/htmlView.gif")).getImage();
    }

    public void setURL(String str) {
        if (null == this.browserComponent) {
            this.urlToLoad = str;
            return;
        }
        this.browserComponent.setURL(str);
    }

    public void setURL(URL url) {
        if (null == this.browserComponent) {
            this.urlToLoad = null == url ? null : url.toExternalForm();
            return;
        }
        this.browserComponent.setURL(url);
    }

    public final URL getDocumentURL() {
        if (null == this.browserComponent) {
            URL url = null;
            if (null != this.urlToLoad) {
                try {
                    url = new URL(this.urlToLoad);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return url;
        }
        return this.browserComponent.getDocumentURL();
    }

    public final void setEnableHome(boolean b) {
        if (null == this.browserComponent) {
            this.enableHome = b;
            return;
        }
        this.browserComponent.setEnableHome(b);
    }

    public final void setEnableLocation(boolean b) {
        if (null == this.browserComponent) {
            this.enableLocation = b;
            return;
        }
        this.browserComponent.setEnableLocation(b);
    }

    public boolean isStatusLineVisible() {
        if (null == this.browserComponent) {
            return this.statusVisible;
        }
        return this.browserComponent.isStatusLineVisible();
    }

    public void setStatusLineVisible(boolean v) {
        if (null == this.browserComponent) {
            this.statusVisible = v;
            return;
        }
        this.browserComponent.setStatusLineVisible(v);
    }

    public boolean isToolbarVisible() {
        if (null == this.browserComponent) {
            return this.toolbarVisible;
        }
        return this.browserComponent.isToolbarVisible();
    }

    public void setToolbarVisible(boolean v) {
        if (null == this.browserComponent) {
            this.toolbarVisible = v;
            return;
        }
        this.browserComponent.setToolbarVisible(v);
    }

    protected String preferredID() {
        return "HtmlBrowserComponent";
    }

    void setURLAndOpen(URL url) {
        if (null == this.browserComponent) {
            this.browserComponent = new HtmlBrowser(this.browserFactory, this.toolbarVisible, this.statusVisible);
            this.add((Component)this.browserComponent, "Center");
            this.browserComponent.getBrowserImpl().addPropertyChangeListener((PropertyChangeListener)this);
            if (this.browserComponent.getBrowserComponent() != null) {
                this.putClientProperty("InternalBrowser", Boolean.TRUE);
            }
        }
        this.browserComponent.setURL(url);
        if (null != this.browserComponent.getBrowserComponent()) {
            this.open();
            this.requestActive();
        }
    }

    public static final class BrowserReplacer
    implements Externalizable {
        static final long serialVersionUID = 5915713034827048413L;
        private transient HtmlBrowserComponent bComp = null;
        transient boolean statLine;
        transient boolean toolbar;
        transient URL url;

        public BrowserReplacer() {
        }

        public BrowserReplacer(HtmlBrowserComponent comp) {
            this.bComp = comp;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeBoolean(this.bComp.isStatusLineVisible());
            out.writeBoolean(this.bComp.isToolbarVisible());
            out.writeObject(this.bComp.getDocumentURL());
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.statLine = in.readBoolean();
            this.toolbar = in.readBoolean();
            this.url = (URL)in.readObject();
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                if ("http".equals(this.url.getProtocol()) && InetAddress.getByName(this.url.getHost()).equals(InetAddress.getLocalHost())) {
                    this.url.openStream();
                }
            }
            catch (UnknownHostException exc) {
            }
            catch (SecurityException exc) {
            }
            catch (NullPointerException exc) {
            }
            catch (IOException exc) {
                return null;
            }
            catch (Exception exc) {
                Logger.getLogger(HtmlBrowserComponent.class.getName()).log(Level.WARNING, null, exc);
            }
            this.bComp = new HtmlBrowserComponent(this.statLine, this.toolbar, this.url);
            return this.bComp;
        }
    }
}

