/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import org.openide.util.Lookup;

public abstract class MachineIDProvider {
    private static MachineIDProvider _provider;

    public static synchronized MachineIDProvider getDefault() {
        if (_provider == null) {
            MachineIDProvider machineIDProvider = (MachineIDProvider)Lookup.getDefault().lookup(MachineIDProvider.class);
            if (machineIDProvider == null) {
                machineIDProvider = new TrivialMachineIDProvider();
            }
            _provider = new Cached(machineIDProvider, 600);
        }
        return _provider;
    }

    public String getUniqueID() {
        String[] stringArray = this.getIDCandidates();
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public abstract String[] getIDCandidates();

    private static class Cached
    extends MachineIDProvider {
        private long _lastUpdate = 0L;
        private MachineIDProvider _delegate;
        private int _refreshPeriod;
        private String[] _ids;

        public Cached(MachineIDProvider machineIDProvider, int n) {
            this._delegate = machineIDProvider;
            this._refreshPeriod = n;
        }

        @Override
        public synchronized String[] getIDCandidates() {
            long l = System.currentTimeMillis();
            if (l - this._lastUpdate > (long)(this._refreshPeriod * 1000)) {
                this._lastUpdate = l;
                this._ids = this._delegate.getIDCandidates();
            }
            return this._ids;
        }
    }

    private static class TrivialMachineIDProvider
    extends MachineIDProvider {
        private TrivialMachineIDProvider() {
        }

        @Override
        public String[] getIDCandidates() {
            throw new UnsupportedOperationException("No MachineIDProvider registered.");
        }
    }
}

