/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import com.paterva.maltego.util.FileUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.openide.util.Lookup;

public abstract class FileStore {
    private static FileStore _instance;

    public static FileStore getDefault() {
        if (_instance == null && (_instance = (FileStore)Lookup.getDefault().lookup(FileStore.class)) == null) {
            _instance = new DefaultFileStore();
            _instance.clear();
        }
        return _instance;
    }

    public abstract int add(File var1) throws IOException;

    public abstract int add(InputStream var1, String var2) throws IOException;

    public abstract File get(int var1) throws FileNotFoundException;

    public abstract long getSize(int var1);

    public abstract void remove(int var1);

    public abstract void clear();

    public abstract String getRelativePath(int var1) throws FileNotFoundException;

    public static class DefaultFileStore
    extends FileStore {
        private Map<Integer, File> _files;
        private String _tempDir = FileUtilities.getMaltegoTempDir() + "Files" + File.separatorChar;
        private int _counter = 0;

        public DefaultFileStore() {
            this._files = new HashMap<Integer, File>();
        }

        @Override
        public int add(File file) throws IOException {
            File file2 = this.getUniqueTempPath(file.getName());
            FileUtilities.copyFile(file, file2);
            this._files.put(++this._counter, file2);
            return this._counter;
        }

        @Override
        public int add(InputStream inputStream, String string) throws IOException {
            File file = this.getUniqueTempPath(string);
            FileUtilities.writeTo(inputStream, file);
            this._files.put(++this._counter, file);
            return this._counter;
        }

        private File getUniqueTempPath(String string) {
            File file = null;
            int n = 0;
            do {
                String string2 = this._tempDir;
                if (n > 0) {
                    string2 = string2 + Integer.toString(n) + File.separatorChar;
                }
                this.ensureDirExists(string2);
                file = new File(string2, string);
                ++n;
            } while (file.exists());
            return file;
        }

        private void ensureDirExists(String string) {
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
        }

        @Override
        public File get(int n) throws FileNotFoundException {
            return this._files.get(n);
        }

        @Override
        public long getSize(int n) {
            return this._files.get(n).length();
        }

        @Override
        public void remove(int n) {
            Integer n2 = n;
            this._files.get(n2).delete();
            this._files.remove(n2);
        }

        @Override
        public final void clear() {
            File file = new File(this._tempDir);
            FileUtilities.delete(file);
        }

        @Override
        public String getRelativePath(int n) throws FileNotFoundException {
            return this.get(n).getAbsolutePath().substring(this._tempDir.length());
        }
    }
}

