/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.modules.flamingo;

import com.pinkmatter.modules.flamingo.ActionItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

class ActionItems {
    private ActionItems() {
    }

    public static List<? extends ActionItem> forPath(String string) {
        ArrayList<ActionItem> arrayList = new ArrayList<ActionItem>();
        Map<String, FileObject> map = ActionItems.createFileObjectMap(string);
        TreeMap<String, ActionItem> treeMap = new TreeMap<String, ActionItem>();
        Collection collection = Lookups.forPath((String)string).lookupResult(Object.class).allItems();
        for (Lookup.Item item : collection) {
            ActionItems.connectToParent((Lookup.Item<Object>)item, string, treeMap, map);
            String string2 = ActionItems.getRootName(ActionItems.makeRelative(item.getId(), string));
            ActionItem actionItem = (ActionItem)treeMap.get(string2);
            if (arrayList.contains(actionItem)) continue;
            arrayList.add(actionItem);
        }
        return arrayList;
    }

    private static Map<String, FileObject> createFileObjectMap(String string) {
        FileObject fileObject = FileUtil.getConfigRoot();
        FileObject fileObject2 = fileObject.getFileObject(string);
        TreeMap<String, FileObject> treeMap = new TreeMap<String, FileObject>();
        if (fileObject2 != null) {
            for (FileObject fileObject3 : fileObject2.getChildren()) {
                ActionItems.addToMap("", fileObject3, treeMap);
            }
        }
        return treeMap;
    }

    private static void addToMap(String string, FileObject fileObject, Map<String, FileObject> map) {
        String string2 = "";
        if (string.length() > 0) {
            string2 = string2 + string + "/";
        }
        string2 = string2 + fileObject.getName();
        map.put(string2, fileObject);
        for (FileObject fileObject2 : fileObject.getChildren()) {
            ActionItems.addToMap(string2, fileObject2, map);
        }
    }

    private static void connectToParent(Lookup.Item<Object> item, String string, Map<String, ActionItem> map, Map<String, FileObject> map2) {
        String string2;
        String string3 = ActionItems.makeRelative(item.getId(), string);
        ActionItem actionItem = ActionItems.getOrCreateActionItem(item, string3, map, map2);
        if (actionItem != null && (string2 = ActionItems.getParentName(string3)) != null) {
            ActionItem actionItem2 = ActionItems.getOrCreateFolderItem(string2, map, map2);
            actionItem2.addChild(actionItem);
        }
    }

    private static String getRootName(String string) {
        int n = string.indexOf(47);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    private static String getParentName(String string) {
        int n = string.lastIndexOf(47);
        if (n > 0) {
            String string2 = string.substring(0, n);
            return string2;
        }
        return null;
    }

    private static ActionItem getOrCreateFolderItem(String string, Map<String, ActionItem> map, Map<String, FileObject> map2) {
        ActionItem actionItem = map.get(string);
        if (actionItem == null) {
            actionItem = new ActionItem.Compound();
            map.put(string, actionItem);
            ActionItems.addProperties(actionItem, map2.get(string));
            actionItem.setText(map2.get(string).getName());
            String string2 = ActionItems.getParentName(string);
            if (string2 != null) {
                ActionItem actionItem2 = ActionItems.getOrCreateFolderItem(string2, map, map2);
                actionItem2.addChild(actionItem);
            }
        }
        return actionItem;
    }

    private static ActionItem getOrCreateActionItem(Lookup.Item<Object> item, String string, Map<String, ActionItem> map, Map<String, FileObject> map2) {
        ActionItem actionItem = map.get(string);
        if (actionItem == null) {
            if (Action.class.isAssignableFrom(item.getType())) {
                Action action = (Action)item.getInstance();
                if (action != null) {
                    actionItem = ActionItem.leaf(action);
                }
            } else if (JSeparator.class.isAssignableFrom(item.getType())) {
                actionItem = ActionItem.separator();
                actionItem.setText(map2.get(string).getName());
            } else if (JComponent.class.isAssignableFrom(item.getType())) {
                JComponent jComponent = (JComponent)item.getInstance();
                if (jComponent != null) {
                    actionItem = ActionItem.component(jComponent);
                }
            } else {
                System.out.println("Unknown item: " + item.getType());
            }
            if (actionItem != null) {
                ActionItems.addProperties(actionItem, map2.get(string));
                map.put(string, actionItem);
            }
        }
        return actionItem;
    }

    private static void addProperties(ActionItem actionItem, FileObject fileObject) {
        Enumeration enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if ("originalFile".equals(string) || "position".equals(string)) continue;
            Object object = fileObject.getAttribute(string);
            actionItem.putValue(string, object);
        }
    }

    private static String makeRelative(String string, String string2) {
        String string3 = string.substring(string2.length(), string.length());
        if (string3.startsWith("/")) {
            string3 = string3.substring(1, string3.length());
        }
        return string3;
    }
}

