/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.WeakHashMap;

public class HighlightFactory {
    private static final Color DEFAULT_HIGHLIGHT_COLOR = new Color(254, 240, 175, 160);
    private static Map<Color, BufferedImage> templates = new WeakHashMap<Color, BufferedImage>();

    private static BufferedImage getHightlightTemplate(Color color) {
        if (!templates.containsKey(color)) {
            BufferedImage bufferedImage = new BufferedImage(100, 100, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Color color2 = new Color(color.getRGB() & 0xFFFFFF, true);
            graphics2D.setPaint(new RadialGradientPaint(50.0f, 50.0f, 50.0f, new float[]{0.0f, 1.0f}, new Color[]{color, color2}));
            graphics2D.fillRect(0, 0, 100, 100);
            graphics2D.dispose();
            templates.put(color, bufferedImage);
        }
        return templates.get(color);
    }

    public static BufferedImage createHighlight(int n, int n2) {
        return HighlightFactory.createHighlight(DEFAULT_HIGHLIGHT_COLOR, n, n2);
    }

    public static BufferedImage createHighlight(Color color, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(HighlightFactory.getHightlightTemplate(color), 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

