/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.util.EnumSet;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.officelaf.OfficeLookAndFeelHelper;
import org.officelaf.OfficeRootPaneUI;
import org.openide.ErrorManager;
import org.openide.modules.ModuleInstall;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall {
    private static final Logger LOG = Logger.getLogger(Installer.class.getName());
    private static final Color GRAY_76 = new Color(76, 76, 76);

    public void restored() {
        System.setProperty("apple.laf.useScreenMenuBar", "false");
        this.installLaf();
    }

    private void installLaf() {
        try {
            System.setProperty("netbeans.exception.report.min.level", "99999");
            System.setProperty("netbeans.winsys.status_line.path", "LookAndFeel/org-officelaf-StatusBar.instance");
            Laf laf = Laf.get(System.getProperty("os.name"));
            LOG.info("LAF: " + (Object)((Object)laf));
            LookAndFeel lookAndFeel = laf.createLafInstance();
            if (lookAndFeel != null) {
                Frame[] frameArray;
                UIManager.setLookAndFeel(lookAndFeel);
                for (Frame frame : frameArray = Frame.getFrames()) {
                    SwingUtilities.updateComponentTreeUI(frame);
                }
            } else {
                LOG.info("No LAF for " + System.getProperty("os.name"));
                OfficeLookAndFeelHelper officeLookAndFeelHelper = new OfficeLookAndFeelHelper();
                UIManager.getDefaults().putDefaults(officeLookAndFeelHelper.getClassDefaults());
                UIManager.getDefaults().putDefaults(officeLookAndFeelHelper.getComponentDefaults());
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
                    JPanel jPanel = new JPanel(new BorderLayout()){

                        @Override
                        public void add(Component component, Object object) {
                            super.add(component, object);
                            if (object == "Center") {
                                component.setBackground(GRAY_76);
                                if (component instanceof JPanel) {
                                    JPanel jPanel = (JPanel)component;
                                    jPanel.setBorder(BorderFactory.createEmptyBorder());
                                }
                            }
                        }
                    };
                    jFrame.setContentPane(jPanel);
                }
            });
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
                    if (6 == jFrame.getExtendedState()) {
                        OfficeRootPaneUI.updateMaximizedBounds(jFrame);
                        if (jFrame.getMaximizedBounds() != null) {
                            jFrame.setExtendedState(0);
                            jFrame.setExtendedState(6);
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    static enum Laf {
        WINDOWS("windows", "org.officelaf.OfficeWindowsLookAndFeel"),
        LINUX("linux", "org.officelaf.OfficeMetalLookAndFeel"),
        MAC("mac os x", "org.officelaf.OfficeAquaLookAndFeel"),
        DEFAULT("default", null);

        private String osName;
        private String lafName;

        private Laf(String string2, String string3) {
            this.osName = string2;
            this.lafName = string3;
        }

        public static Laf get(String string) {
            for (Laf laf : EnumSet.allOf(Laf.class)) {
                if (string.toLowerCase().indexOf(laf.getOsName().toLowerCase()) != 0) continue;
                return laf;
            }
            return DEFAULT;
        }

        public String getOsName() {
            return this.osName;
        }

        public String getLafName() {
            return this.lafName;
        }

        public LookAndFeel createLafInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            if (this.lafName == null) {
                return null;
            }
            Class<?> clazz = Class.forName(this.lafName);
            return (LookAndFeel)clazz.newInstance();
        }

        public String toString() {
            return this.osName + ": " + this.lafName;
        }
    }
}

