/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import yguard.A.A.C;
import yguard.A.A.D;
import yguard.A.A.E;
import yguard.A.A.H;
import yguard.A.A.Z;
import yguard.A.A._;
import yguard.A.I.;
import yguard.A.I.DC;
import yguard.A.I.EA;
import yguard.A.I.QA;
import yguard.A.I.W;
import yguard.A.I.Y;
import yguard.A.I.dA;
import yguard.A.I.fB;
import yguard.A.I.o;

public class LinkHighlighter
extends fB {
    private yguard.A.A.Y _lastHoveredNode;
    private Color _highlightColorChild;
    private Color _highlightColorParent;
    private dA _highlightType = dA.I;
    private E _lastSelection;
    private MyListener _selectionListener = new MyListener();
    private static final int MAX_NODES = 50;
    private Rectangle2D _dirtyArea = null;

    public LinkHighlighter() {
        MaltegoLAF.Safe safe = new MaltegoLAF.Safe();
        this._highlightColorChild = safe.getColor("graph-link-highlight-child-color");
        this._highlightColorParent = safe.getColor("graph-link-highlight-parent-color");
    }

    private boolean highlightOnHover() {
        return true;
    }

    private boolean highlightOnSelect() {
        return true;
    }

    private boolean highlightOnHover(yguard.A.A.Y y) {
        if (this._lastSelection == null) {
            return true;
        }
        return !this.highlightOnSelect() || this._lastSelection.size() > 50 || !this.view.H().g(y);
    }

    protected void setSelectedNodes(E e) {
        if (this.highlightOnSelect()) {
            E e2;
            if (this._lastSelection != null && this._lastSelection.size() <= 50) {
                this._lastSelection.toFirst();
                e2 = this._lastSelection;
                while (e2.ok()) {
                    this.markEdges(e2.node().I(), null, null);
                    e2.next();
                }
            }
            if (e != null && e.size() <= 50) {
                e.toFirst();
                e2 = e;
                while (e2.ok()) {
                    this.markEdges(e2.node().M(), this._highlightColorParent, this._highlightType);
                    this.markEdges(e2.node().G(), this._highlightColorChild, this._highlightType);
                    e2.next();
                }
            }
            this._lastSelection = e;
        }
    }

    protected void setHoveredEdge(H h) {
    }

    protected void setHoveredNode(yguard.A.A.Y y) {
        if (this.highlightOnHover() && this._lastHoveredNode != y) {
            if (this._lastHoveredNode != null && this.highlightOnHover(this._lastHoveredNode)) {
                this.markEdges(this._lastHoveredNode.I(), null, null);
                if (this._lastSelection != null && this.highlightOnSelect()) {
                    this.setSelectedNodes(this._lastSelection);
                }
            }
            if (y != null && this.highlightOnHover(y)) {
                this.markEdges(y.M(), this._highlightColorParent, this._highlightType);
                this.markEdges(y.G(), this._highlightColorChild, this._highlightType);
            }
            this._lastHoveredNode = y;
        }
    }

    private void markEdges(Z z, Color color, dA dA2) {
        QA qA = this.view.H();
        z.toFirst();
        while (z.ok()) {
            MaltegoLink maltegoLink = MaltegoGraphManager.getWrapper((D)qA).link(z.edge());
            o o2 = qA.X(z.edge());
            Color color2 = color != null ? color : maltegoLink.getColor();
            o2.setLineColor(color2);
            o2.setLineType(dA2 != null ? dA2 : dA.A((int)maltegoLink.getThickness(), (byte)((byte)maltegoLink.getStyle())));
            EA eA2 = o2.getLabel();
            if (eA2 != null) {
                eA2.setTextColor(color2);
            }
            .A a2 = qA.f(z.edge().X());
            .A a3 = qA.f(z.edge().V());
            this.addDirtyArea(new Rectangle2D.Double(a2.getX() - 1.0, a2.getY() - 1.0, a2.getWidth() + 2.0, a2.getHeight() + 2.0));
            this.addDirtyArea(new Rectangle2D.Double(a3.getX() - 1.0, a3.getY() - 1.0, a3.getWidth() + 2.0, a3.getHeight() + 2.0));
            z.next();
        }
    }

    public void mouseMoved(double d2, double d3) {
        super.mouseMoved(d2, d3);
        DC dC = this.getHitInfo(d2, d3);
        if (dC != null) {
            if (dC.B()) {
                this.setHoveredNode(dC.V());
            } else if (dC.X()) {
                this.setHoveredEdge(dC.T());
            } else {
                this.setHoveredEdge(null);
                this.setHoveredNode(null);
            }
        } else {
            this.setHoveredEdge(null);
            this.setHoveredNode(null);
        }
        this.repaint();
    }

    public void disconnect(QA qA) {
        qA.B((Y)this._selectionListener);
        qA.B((_)this._selectionListener);
    }

    public void connect(QA qA) {
        qA.A((Y)this._selectionListener);
        qA.A((_)this._selectionListener);
    }

    private void repaint() {
        if (this._dirtyArea != null) {
            this.view.C(this._dirtyArea);
            this._dirtyArea = null;
        }
    }

    private void addDirtyArea(Rectangle2D rectangle2D) {
        if (this._dirtyArea == null) {
            this._dirtyArea = rectangle2D.getBounds2D();
        } else {
            this._dirtyArea.add(rectangle2D);
        }
    }

    protected DC getHitInfo(double d2, double d3) {
        return new DC(this.getGraph2D(), d2, d3, true, 4, 5, -1, -1, -1, -1, -1);
    }

    private class MyListener
    extends W._D {
        private int _eventDepth = 0;
        private boolean _inDeleteTransaction = false;

        private MyListener() {
        }

        protected void updateSelectionState(QA qA) {
            if (!this._inDeleteTransaction) {
                this.smartUpdateSelectionState(qA);
            }
        }

        public void onGraphEvent(C c2) {
            this.handle(c2);
            super.onGraphEvent(c2);
        }

        private void handle(C c2) {
            switch (c2.C()) {
                case 5: {
                    if (this._eventDepth <= 0) break;
                    this._inDeleteTransaction = true;
                    break;
                }
                case 3: {
                    if (this._eventDepth <= 0) break;
                    this._inDeleteTransaction = true;
                    break;
                }
                case 12: {
                    ++this._eventDepth;
                    break;
                }
                case 13: {
                    --this._eventDepth;
                    if (this._eventDepth > 0 || !this._inDeleteTransaction) break;
                    this._eventDepth = 0;
                    this._inDeleteTransaction = false;
                    this.updateSelectionState((QA)c2.B());
                }
            }
        }

        protected void smartUpdateSelectionState(QA qA) {
            LinkHighlighter.this.setSelectedNodes(qA.\u011c());
            LinkHighlighter.this.repaint();
        }
    }
}

