/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.ListMap;
import com.paterva.maltego.util.MachineIDProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;

final class License {
    public static final String MODE_WITH_API_KEYS = "withApiKeys";
    public static final String MODE_NO_API_KEYS = "noApiKeys";
    private String _firstName;
    private String _lastName;
    private String _country;
    private String _emailAddress;
    private String[] _mac;
    private String _action;
    private String _msg;
    private Date _notValidBefore;
    private Date _notValidAfter;
    private String _maltegoVersion;
    private String _licenseKey;
    private Map<String, String> _apiKeys;
    private static final String COMPONENT_B = "S0dQUUtWV04=";
    private static final String COMPONENT_A = "T0NDSUxLR1FDQ0l";
    private static final String COMPONENT_D = "0dGQ05IRxBXQE1A";
    private static final String COMPONENT_C = "Q1FIW0pLR1";
    private static final String COMPONENT_F = "FMT0BGQ1FIRxAbDQ";
    private static final String COMPONENT_E = "Q0VIW0hLR";

    public String getFirstName() {
        return this._firstName;
    }

    public String getLastName() {
        return this._lastName;
    }

    public Date getValidFrom() {
        return this._notValidBefore;
    }

    public Date getValidTo() {
        return this._notValidAfter;
    }

    public String getFullName() {
        String string = this.getFirstName();
        if (string == null) {
            string = "";
        }
        string = string.trim();
        if (this.getLastName() != null) {
            string = string + " " + this.getLastName().trim();
        }
        return string;
    }

    public String getCountry() {
        return this._country;
    }

    public String getEmailAddress() {
        return this._emailAddress;
    }

    public Map<String, String> getApiKeys() {
        return this._apiKeys;
    }

    public String getMessage() {
        return this._msg;
    }

    public String getMaltegoVersion() {
        return this._maltegoVersion;
    }

    public String getLicenseKey() {
        return this._licenseKey;
    }

    private License() {
    }

    public static License read() throws ParsingException, IOException {
        String string = License.loadLicense();
        String string2 = License.decrypt(string);
        return License.parse(string2);
    }

    static boolean validate() {
        try {
            License license = License.read();
            return license.isValid();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean intersect(String[] stringArray, String[] stringArray2) {
        for (String string : stringArray) {
            if (!License.contains(stringArray2, string)) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        boolean bl = License.isApiMode();
        if (bl && !this.getMaltegoVersion().startsWith("3")) {
            return false;
        }
        if (!bl && !this.getMaltegoVersion().startsWith("1")) {
            return false;
        }
        Date date = new Date();
        String[] stringArray = MachineIDProvider.getDefault().getIDCandidates();
        if (stringArray.length == 0) {
            return false;
        }
        if (!License.intersect(stringArray, this._mac)) {
            return false;
        }
        if (date.after(this._notValidAfter)) {
            return false;
        }
        return !date.before(this._notValidBefore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadLicense() throws IOException {
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            bufferedReader = new BufferedReader(new FileReader(new File(FileUtilities.getAllUsersSettings(), License.getFilename())));
            while (bufferedReader.ready()) {
                stringBuffer.append(bufferedReader.readLine());
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return stringBuffer.toString();
    }

    private static boolean isApiMode() {
        String string = System.getProperty("maltego.license_mode");
        return !MODE_NO_API_KEYS.equals(string);
    }

    private static int getKeyVectorPair() {
        if (License.isApiMode()) {
            return 1;
        }
        return 2;
    }

    private static String decrypt(String string) throws IOException {
        try {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byte[] byArray = bASE64Decoder.decodeBuffer(string);
            String string2 = License.getKey();
            String string3 = License.getVector();
            switch (License.getKeyVectorPair()) {
                case 2: {
                    string2 = License.getKey2();
                    string3 = License.getVector2();
                    break;
                }
                case 3: {
                    string2 = License.getKey3();
                    string3 = License.getVector3();
                }
            }
            SecretKeySpec secretKeySpec = new SecretKeySpec(string2.getBytes("UTF-8"), "DESede");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(string3.getBytes("UTF-8"));
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            byte[] byArray2 = cipher.doFinal(byArray);
            return new String(byArray2);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IOException(illegalBlockSizeException.getMessage(), illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new IOException(badPaddingException.getMessage(), badPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException(invalidKeyException.getMessage(), invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IOException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new IOException(noSuchPaddingException.getMessage(), noSuchPaddingException);
        }
    }

    private static License parse(String string) throws ParsingException {
        try {
            License license = new License();
            license._firstName = License.getParsedValueBetween("fname", string);
            license._lastName = License.getParsedValueBetween("lname", string);
            license._country = License.getParsedValueBetween("country", string, true);
            license._emailAddress = License.getParsedValueBetween("email_address", string);
            String string2 = License.getParsedValueBetween("mac", string);
            license._mac = string2.split("\\,");
            if (license._mac.length == 0) {
                throw new ParsingException("No mac list found");
            }
            license._apiKeys = License.parseApiKeys(License.getParsedValueBetween("api_key", string));
            license._action = License.getParsedValueBetween("action", string);
            license._msg = License.getParsedValueBetween("mesg", string);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss");
            license._notValidAfter = simpleDateFormat.parse(License.getParsedValueBetween("not_valid_after", string));
            license._notValidBefore = simpleDateFormat.parse(License.getParsedValueBetween("not_valid_before", string));
            license._maltegoVersion = License.getParsedValueBetween("version", string);
            license._licenseKey = License.getParsedValueBetween("lic_key", string);
            return license;
        }
        catch (ParseException parseException) {
            throw new ParsingException(parseException.getMessage());
        }
    }

    private static Map<String, String> parseApiKeys(String string) throws ParsingException {
        int n = string.indexOf(64);
        if (n < 0) {
            throw new ParsingException(string + " is not a valid API key reference");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        ListMap listMap = new ListMap();
        listMap.put((Object)string3, (Object)string2);
        return listMap;
    }

    private static String getParsedValueBetween(String string, String string2) throws ParsingException {
        return License.getParsedValueBetween(string, string2, false);
    }

    private static String getParsedValueBetween(String string, String string2, boolean bl) throws ParsingException {
        String string3 = "<" + string + ">";
        String string4 = "</" + string + ">";
        int n = string2.indexOf(string3) + string3.length();
        int n2 = string2.indexOf(string4, n);
        if (n < 0 || n2 < 0 || n2 < n) {
            if (bl) {
                return "";
            }
            throw new ParsingException("Error : " + string3 + "could not be parsed from \n" + string2);
        }
        return string2.substring(n, n2);
    }

    public static String getFilename() {
        String string = "MaltegoLicense.lic";
        switch (License.getKeyVectorPair()) {
            case 2: {
                string = "CaseFileLicense.lic";
                break;
            }
            case 3: {
                string = "Lightstone.lic";
            }
        }
        return string;
    }

    private static String getVector() {
        String string = "T0NDSUxLR1FDQ0lVQ1ZNTFFK" + COMPONENT_B.substring(0, 8);
        String string2 = string.substring(4, 6) + "ND" + (char)(string.charAt(string.length() - 1) - 2) + (char)(string.charAt(string.length() - 1) - 2) + "lQ" + COMPONENT_B.substring(8, COMPONENT_B.length());
        int n = 34;
        return License.decodeObfuscation(string2, n);
    }

    private static String getKey() {
        String string = "T0NDSUxLR1FDQ0lVQ1ZNTFFK" + COMPONENT_B.substring(0, 8);
        int n = 34;
        return License.decodeObfuscation(string, n);
    }

    private static String getVector2() {
        String string = "Q1FIW0pLR1BGS0dRS0dMT" + COMPONENT_D.substring(0, 14);
        String string2 = string.substring(32, 35) + "N" + string.charAt(20) + (char)(string.charAt(1) - '\u0001') + (char)(string.length() * 3 + 3) + string.charAt(string.length() - COMPONENT_C.length() - 1) + "V0" + string.charAt(13) / 12 + "=";
        int n = 34;
        return License.decodeObfuscation(string2, n);
    }

    private static String getKey2() {
        String string = "Q1FIW0pLR1BGS0dRS0dMT" + COMPONENT_D.substring(0, 11);
        int n = 34;
        return License.decodeObfuscation(string, n);
    }

    private static String getVector3() {
        String string = "Q0VIW0hLRxdGS0dRSx" + COMPONENT_F.substring(0, 14);
        String string2 = "Q" + Integer.toHexString(string.indexOf(65) * 8 - 15).toUpperCase() + string.substring(19, 21).replace('M', 'N') + string.substring(5, 8).replace(String.valueOf('h'), "").toLowerCase() + COMPONENT_F.substring(14) + Integer.toHexString(Integer.parseInt(string.substring(25, 27), 16) - 1).toUpperCase() + '=' + "";
        int n = 34;
        return License.decodeObfuscation(string2, n);
    }

    private static String getKey3() {
        String string = "Q0VIW0hLRxdGS0dRSx" + COMPONENT_F.substring(0, 14);
        int n = 34;
        return License.decodeObfuscation(string, n);
    }

    private static String decodeObfuscation(String string, int n) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        try {
            string2 = new String(bASE64Decoder.decodeBuffer(string));
        }
        catch (Exception exception) {
            return null;
        }
        stringBuilder = new StringBuilder();
        for (int i = 0; i < string2.length(); ++i) {
            stringBuilder.append((char)(string2.charAt(i) ^ n));
        }
        return stringBuilder.toString();
    }

    public static class ParsingException
    extends Exception {
        public ParsingException() {
        }

        public ParsingException(String string) {
            super(string);
        }
    }
}

