/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.ui.graph.view2d.ExportCookie;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import yguard.A.H.A;
import yguard.A.H.B;
import yguard.A.H.C;
import yguard.A.H.G;
import yguard.A.H.J;
import yguard.A.H.R;
import yguard.A.I.QA;
import yguard.A.I.S;
import yguard.A.I.vA;

public class Graph2DViewExporter
implements ExportCookie {
    S _view;
    Map<String, String> _fileTypes;

    public Graph2DViewExporter(S s) {
        this._view = s;
        this._fileTypes = new HashMap<String, String>();
        this._fileTypes.put("gif", "Graphics Interchange Format (*.gif)");
        this._fileTypes.put("jpg", "Joint Photographic Experts Group (*.jpg)");
        this._fileTypes.put("png", "Portable Network Graphics (*.png)");
        this._fileTypes.put("bmp", "Windows & OS/2 bitmap (*.bmp)");
    }

    @Override
    public Map<String, String> getFileTypes() {
        return this._fileTypes;
    }

    @Override
    public void exportToFile(File file, double d2) throws IOException {
        String string = file.getPath();
        C c2 = null;
        if (string.endsWith(".gif")) {
            c2 = new C();
        } else if (string.endsWith(".jpg")) {
            c2 = new R();
            ((R)c2).A(0.9f);
        } else {
            c2 = this.createOutputHandler(string.substring(string.lastIndexOf(46) + 1));
        }
        if (c2 == null) {
            throw new IOException("Unable to export the graph. The given file format is not supported.");
        }
        this.exportGraphToImageFileFormat(this._view.H(), (J)c2, string, d2);
    }

    J createOutputHandler(String string) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix(string);
        ImageWriter imageWriter = iterator.hasNext() ? iterator.next() : null;
        return imageWriter == null ? null : new A(imageWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportGraphToImageFileFormat(QA qA, J j2, String string, double d2) throws IOException {
        S s = this.replaceCurrentWithExportView(qA, j2);
        this.configureExportView((S)qA.\u0106(), d2);
        try {
            this.writeGraphToFile(qA, (G)j2, string);
        }
        finally {
            this.restoreOriginalView(qA, s);
        }
    }

    void writeGraphToFile(QA qA, G g, String string) throws IOException {
        g.write(qA, string);
    }

    S replaceCurrentWithExportView(QA qA, J j2) {
        S s = (S)qA.\u0106();
        S s2 = j2.C(qA);
        s2.B(s.\u00e1());
        qA.A((vA)s2);
        return s;
    }

    void restoreOriginalView(QA qA, S s) {
        qA.C(qA.\u0106());
        qA.A((vA)s);
    }

    void configureExportView(S s, double d2) {
        B b = new B();
        b.A(s.H());
        b.B(B.C);
        b.A(B.E);
        b.A(d2);
        b.A(s);
    }
}

