/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityStringConverter;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.GraphWrapper;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.actions.PlaceLabelsAction;
import com.paterva.maltego.ui.graph.nodes.AddAttachmentsAction;
import com.paterva.maltego.ui.graph.nodes.GraphNode;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import com.paterva.maltego.util.FileUtilities;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import yguard.A.A.D;
import yguard.A.A.G;
import yguard.A.A.Y;
import yguard.A.I.DC;
import yguard.A.I.QA;
import yguard.A.I.S;

class Graph2DViewDropSupport
implements DropTargetListener {
    private S _view;
    private long _lastLicenseCheck = 0L;
    private static final int MinutesBetweenChecks = 30;
    private static final int MillisBetweenChecks = 1800000;
    private Collection<MaltegoEntity> _entities;
    private Map<MaltegoEntity, File> _attachments;

    public Graph2DViewDropSupport(S s) {
        this._view = s;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.onDragOver(dropTargetDragEvent);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.onDragOver(dropTargetDragEvent);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this.onDragOver(dropTargetDragEvent);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this._entities != null) {
            this.removeTempEntities();
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.onDrop(dropTargetDropEvent);
    }

    private void onDragOver(DropTargetDragEvent dropTargetDragEvent) {
        Object object;
        Transferable transferable = dropTargetDragEvent.getTransferable();
        Node node = NodeTransfer.node((Transferable)transferable, (int)1);
        boolean bl = false;
        Collection<MaltegoEntity> collection = null;
        if (node != null) {
            if (this._entities == null && (object = this.createEntity(node)) != null) {
                collection = new ArrayList<MaltegoEntity>();
                collection.add((MaltegoEntity)object);
            }
        } else if (this.hasHitNode(this.getHitInfo(dropTargetDragEvent.getLocation()))) {
            boolean bl2 = false;
            if (this._entities != null) {
                this.removeTempEntities();
                bl2 = true;
            }
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                if (this.getFiles(transferable) != null) {
                    if (bl2) {
                        StatusDisplayer.getDefault().setStatusText("Drop to attach files...");
                    }
                    bl = true;
                }
            } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                if (bl2) {
                    StatusDisplayer.getDefault().setStatusText("Drop to append note...");
                }
                bl = true;
            }
        } else if (this._entities == null || this._entities.isEmpty()) {
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                collection = this.stringFlavorToEntities(transferable);
            } else if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                collection = this.filesFlavorToEntities(transferable);
            }
            if (collection != null) {
                StatusDisplayer.getDefault().setStatusText("Drop to create new entities...");
            }
        }
        if (collection != null) {
            object = (GraphNode)GraphNodeManager.getInstance((D)this._view.H()).getNode();
            ((GraphNode)((Object)object)).addEntities(collection);
            this._entities = collection;
        }
        if (this._entities != null && !this._entities.isEmpty()) {
            bl = true;
            this.updatePositions(dropTargetDragEvent.getLocation());
        }
        if (bl) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    private void onDrop(DropTargetDropEvent dropTargetDropEvent) {
        if (!this.validateLicense()) {
            if (this._entities != null) {
                this.removeTempEntities();
            }
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"You have to activate Maltego before you can create a graph!", 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        dropTargetDropEvent.acceptDrop(3);
        if (this._entities != null) {
            Object object;
            StatusDisplayer.getDefault().setStatusText(this._entities.size() + " entities created");
            if (this._attachments != null) {
                object = (AddAttachmentsAction)SystemAction.get(AddAttachmentsAction.class);
                ((AddAttachmentsAction)((Object)object)).perform(this._attachments);
            }
            this._entities = null;
            this._attachments = null;
            object = (PlaceLabelsAction)SystemAction.get(PlaceLabelsAction.class);
            if (object != null) {
                ((PlaceLabelsAction)object).perform(this._view.H(), null);
            }
        } else {
            MaltegoEntity maltegoEntity = null;
            DC dC = this.getHitInfo(dropTargetDropEvent.getLocation());
            if (dC.B()) {
                maltegoEntity = this.nodeToEntity(dC.V());
            }
            if (maltegoEntity != null) {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    this.appendNote(transferable, maltegoEntity);
                    StatusDisplayer.getDefault().setStatusText("Note added");
                } else if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    int n = this.dropFiles(transferable, maltegoEntity);
                    StatusDisplayer.getDefault().setStatusText(n + " files attached");
                }
            }
        }
        GraphEditorRegistry.getDefault().getTopmost().requestActive();
    }

    private void updatePositions(Point point) {
        QA qA = this._view.H();
        GraphWrapper graphWrapper = MaltegoGraphManager.getWrapper((D)qA);
        graphWrapper.beginUpdate();
        double d2 = this._view.D(point.x);
        double d3 = this._view.C(point.y);
        Point2D.Double[] doubleArray = this.calculatePositions(this._entities.size(), d2, d3);
        int n = 0;
        for (MaltegoEntity maltegoEntity : this._entities) {
            Y y = graphWrapper.node(maltegoEntity);
            qA.D(y, doubleArray[n].x, doubleArray[n].y);
            ++n;
        }
        graphWrapper.endUpdate();
        this._view.I();
    }

    private Collection<MaltegoEntity> stringFlavorToEntities(Transferable transferable) {
        Collection collection = null;
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            EntityStringConverter entityStringConverter = (EntityStringConverter)Lookup.getDefault().lookup(EntityStringConverter.class);
            collection = entityStringConverter.convert(string);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Exceptions.printStackTrace((Throwable)unsupportedFlavorException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return collection;
    }

    private Collection<MaltegoEntity> filesFlavorToEntities(Transferable transferable) {
        ArrayList<MaltegoEntity> arrayList = null;
        try {
            List<File> list = this.getFiles(transferable);
            if (list != null) {
                arrayList = new ArrayList<MaltegoEntity>(list.size());
                this._attachments = new HashMap<MaltegoEntity, File>(list.size());
                for (File file : list) {
                    MaltegoEntity maltegoEntity = this.createDocumentEntity(file);
                    arrayList.add(maltegoEntity);
                    this._attachments.put(maltegoEntity, file);
                }
                return arrayList;
            }
        }
        catch (TypeInstantiationException typeInstantiationException) {
            Exceptions.printStackTrace((Throwable)typeInstantiationException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    private MaltegoEntity createDocumentEntity(File file) throws IOException, TypeInstantiationException {
        MaltegoEntity maltegoEntity = (MaltegoEntity)EntityFactory.getDefault().createInstance("maltego.File", false);
        PropertyDescriptor propertyDescriptor = maltegoEntity.getProperties().get("description");
        if (propertyDescriptor == null) {
            propertyDescriptor = new DisplayDescriptor(String.class, "description", "Description");
            maltegoEntity.addProperty(propertyDescriptor);
            maltegoEntity.setValueProperty(propertyDescriptor);
            maltegoEntity.setDisplayValueProperty(propertyDescriptor);
        }
        maltegoEntity.setValue(propertyDescriptor, (Object)file.getName());
        maltegoEntity.setNotes(file.getCanonicalPath());
        return maltegoEntity;
    }

    private boolean hasHitNode(DC dC) {
        if (dC.B()) {
            if (this._entities == null || this._entities.isEmpty()) {
                return true;
            }
            QA qA = this._view.H();
            GraphWrapper graphWrapper = MaltegoGraphManager.getWrapper((D)qA);
            G g = dC.L();
            while (g.ok()) {
                Object object = g.current();
                if (object instanceof Y) {
                    Y y = (Y)object;
                    boolean bl = false;
                    for (MaltegoEntity maltegoEntity : this._entities) {
                        if (!y.equals(graphWrapper.node(maltegoEntity))) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        return true;
                    }
                }
                g.next();
            }
        }
        return false;
    }

    private void removeTempEntities() {
        GraphWrapper graphWrapper = MaltegoGraphManager.getWrapper((D)this._view.H());
        graphWrapper.beginUpdate();
        for (MaltegoEntity maltegoEntity : this._entities) {
            graphWrapper.remove(maltegoEntity);
        }
        graphWrapper.endUpdate();
        this._entities = null;
        this._attachments = null;
    }

    private void appendNote(Transferable transferable, MaltegoEntity maltegoEntity) {
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            String string2 = maltegoEntity.getNotes();
            string2 = string2 == null || string2.isEmpty() ? string : string2 + "\n" + string;
            maltegoEntity.setNotes(string2);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Exceptions.printStackTrace((Throwable)unsupportedFlavorException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private int dropFiles(Transferable transferable, MaltegoEntity maltegoEntity) {
        List<File> list = this.getFiles(transferable);
        if (list != null) {
            AddAttachmentsAction addAttachmentsAction = (AddAttachmentsAction)SystemAction.get(AddAttachmentsAction.class);
            addAttachmentsAction.perform(maltegoEntity, list);
            return list.size();
        }
        return 0;
    }

    private boolean validateLicense() {
        return true;
    }

    private MaltegoEntity nodeToEntity(Y y) {
        GraphWrapper graphWrapper = MaltegoGraphManager.getWrapper((D)this._view.H());
        return graphWrapper.entity(y);
    }

    private DC getHitInfo(Point point) {
        DC dC = new DC(this._view, this._view.D(point.x), this._view.C(point.y), false);
        return dC;
    }

    private MaltegoEntity createEntity(Node node) {
        MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)node.getLookup().lookup(MaltegoEntitySpec.class);
        MaltegoEntity maltegoEntity = null;
        try {
            maltegoEntity = EntityFactory.forGraph((D)this._view.H()).createInstance(maltegoEntitySpec, true);
        }
        catch (TypeInstantiationException typeInstantiationException) {
            Exceptions.printStackTrace((Throwable)typeInstantiationException);
        }
        return maltegoEntity;
    }

    private List<File> getFiles(Transferable transferable) {
        try {
            List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            list = FileUtilities.removeDirectories((List)list);
            if (list != null && !list.isEmpty()) {
                return list;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Exceptions.printStackTrace((Throwable)unsupportedFlavorException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    private Point2D.Double[] calculatePositions(int n, double d2, double d3) {
        int n2 = 120;
        int n3 = (int)Math.ceil(Math.sqrt(n));
        int n4 = 0;
        Point2D.Double[] doubleArray = new Point2D.Double[n];
        double d4 = d2;
        double d5 = d3;
        for (int i = 0; i < n3; ++i) {
            d4 = d2;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (n4 < doubleArray.length) {
                    doubleArray[n4] = new Point2D.Double(d4, d5);
                }
                ++n4;
                d4 += 120.0;
            }
            d5 += 120.0;
        }
        return doubleArray;
    }
}

