/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.EntityImageFactory;
import com.paterva.maltego.ui.graph.actions.EditNodeAction;
import com.paterva.maltego.ui.graph.clipboard.EntityListCopyAction;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.data.GraphDataUtils;
import com.paterva.maltego.ui.graph.nodes.EntityProperties;
import com.paterva.maltego.ui.graph.nodes.GraphNode;
import com.paterva.maltego.ui.graph.nodes.NodeToEntityConverter;
import com.paterva.maltego.ui.graph.nodes.NodeToEntitySpecConverter;
import com.paterva.maltego.ui.graph.nodes.SpecActionsMenuAction;
import com.paterva.maltego.util.ImageCallback;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Action;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import yguard.A.A.D;
import yguard.A.A.Y;

class EntityNode
extends AbstractNode
implements ImageCallback {
    private PropertyChangeListener _entityListener;
    private Action[] _actions;

    public EntityNode(Y y, NodeToEntityConverter nodeToEntityConverter) {
        this(y, nodeToEntityConverter, new InstanceContent());
    }

    private EntityNode(Y y, NodeToEntityConverter nodeToEntityConverter, final InstanceContent instanceContent) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        instanceContent.add((Object)y);
        instanceContent.add((Object)y, (InstanceContent.Convertor)nodeToEntityConverter);
        instanceContent.add((Object)this, (InstanceContent.Convertor)NodeToEntitySpecConverter.instance());
        this._entityListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("properties".equals(propertyChangeEvent.getPropertyName())) {
                    EntityNode.this.refreshProperties();
                } else if ("value".equals(propertyChangeEvent.getPropertyName())) {
                    EntityNode.this.firePropertyChange("maltego.calculated.value", null, null);
                } else if ("displayValue".equals(propertyChangeEvent.getPropertyName())) {
                    EntityNode.this.fireDisplayNameChange(null, null);
                } else if (!"image".equals(propertyChangeEvent.getPropertyName())) {
                    if ("type".equals(propertyChangeEvent.getPropertyName())) {
                        instanceContent.remove((Object)EntityNode.this, (InstanceContent.Convertor)NodeToEntitySpecConverter.instance());
                        instanceContent.add((Object)EntityNode.this, (InstanceContent.Convertor)NodeToEntitySpecConverter.instance());
                        EntityNode.this.refreshProperties();
                    } else if ("notesChanged".equals(propertyChangeEvent.getPropertyName()) || "showNotesChanged".equals(propertyChangeEvent.getPropertyName()) || "bookmarkChanged".equals(propertyChangeEvent.getPropertyName())) {
                        EntityNode.this.markGraphDirty();
                    }
                }
            }
        };
        MaltegoEntity maltegoEntity = nodeToEntityConverter.getGraph().entity(y);
        if (maltegoEntity == null) {
            System.out.println("NULL entity for graph" + Integer.toHexString(System.identityHashCode(nodeToEntityConverter.getGraph().getGraph())));
        }
        assert (maltegoEntity != null);
        MaltegoEntity maltegoEntity2 = (MaltegoEntity)this.getLookup().lookup(MaltegoEntity.class);
        assert (maltegoEntity == maltegoEntity2);
        maltegoEntity2.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._entityListener, (Object)maltegoEntity2));
        maltegoEntity2.addBookmarkListener(WeakListeners.propertyChange((PropertyChangeListener)this._entityListener, (Object)maltegoEntity2));
        maltegoEntity2.addNotesListener(WeakListeners.propertyChange((PropertyChangeListener)this._entityListener, (Object)maltegoEntity2));
    }

    public Image getIcon(int n) {
        D d2 = this.getGraph();
        return EntityImageFactory.forGraph(d2).getImage(this.getEntity(), -1, this.getSize(n), this);
    }

    private D getGraph() {
        Y y = (Y)this.getLookup().lookup(Y.class);
        return y.H();
    }

    private EntityRegistry getRegistry() {
        D d2 = this.getGraph();
        return EntityRegistry.forGraph((D)d2);
    }

    private int getSize(int n) {
        if (n == 1 || n == 3) {
            return 16;
        }
        return 32;
    }

    public String getDisplayName() {
        return InheritanceHelper.getDisplayString((SpecRegistry)this.getRegistry(), (TypedPropertyBag)this.getEntity());
    }

    private MaltegoEntity getEntity() {
        return (MaltegoEntity)this.getLookup().lookup(MaltegoEntity.class);
    }

    private MaltegoEntitySpec getEntitySpec() {
        return (MaltegoEntitySpec)this.getLookup().lookup(MaltegoEntitySpec.class);
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        super.destroy();
        this.findGraphNode().remove((Node)this);
    }

    public Transferable clipboardCut() throws IOException {
        return super.clipboardCut();
    }

    public Action getPreferredAction() {
        SystemAction systemAction = SystemAction.get(EditNodeAction.class);
        return systemAction;
    }

    public Transferable clipboardCopy() throws IOException {
        return super.clipboardCopy();
    }

    GraphNode findGraphNode() {
        Node node;
        for (node = this.getParentNode(); node != null && !(node instanceof GraphNode); node = node.getParentNode()) {
        }
        if (node instanceof GraphNode) {
            return (GraphNode)node;
        }
        return null;
    }

    public Action[] getActions(boolean bl) {
        if (this._actions == null) {
            ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>();
            Lookup lookup = Lookups.forPath((String)"Maltego/ContextActions/Entity");
            arrayList.addAll(lookup.lookupAll(Action.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(SpecActionsMenuAction.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(CopyAction.class));
            arrayList.add(SystemAction.get(EntityListCopyAction.class));
            arrayList.add(SystemAction.get(CutAction.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(DeleteAction.class));
            this._actions = arrayList.toArray(new Action[arrayList.size()]);
        }
        return this._actions;
    }

    protected Sheet createSheet() {
        MaltegoEntity maltegoEntity = this.getEntity();
        MaltegoEntitySpec maltegoEntitySpec = this.getEntitySpec();
        return EntityProperties.createSheet((Node)this, maltegoEntity, maltegoEntitySpec);
    }

    private void refreshProperties() {
        this.setSheet(this.createSheet());
    }

    private static String toString(Sheet sheet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Node.PropertySet propertySet : sheet.toArray()) {
            stringBuffer.append("set ");
            stringBuffer.append(propertySet.getName());
            stringBuffer.append("\n");
            for (Node.Property property : propertySet.getProperties()) {
                stringBuffer.append("       ");
                stringBuffer.append(property.getName());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public void imageReady(Object object, Object object2) {
    }

    public void imageFailed(Object object, Exception exception) {
    }

    public boolean needAwtThread() {
        return true;
    }

    public String toString() {
        return InheritanceHelper.getDisplayValue((SpecRegistry)this.getRegistry(), (TypedPropertyBag)this.getEntity()).toString();
    }

    private void markGraphDirty() {
        GraphDataObject graphDataObject = GraphDataUtils.getGraphDataObject(this.getGraph());
        if (graphDataObject != null) {
            graphDataObject.setModified(true);
        }
    }
}

