/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.actions.NewGraphAction;
import com.paterva.maltego.ui.graph.nodes.GraphFilterNode;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import com.paterva.maltego.ui.graph.view2d.layout.MaltegoLayouter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import yguard.A.G.l;
import yguard.A.I.BA;
import yguard.A.I.S;

public abstract class CopyToNewGraphAction
extends NodeAction {
    protected void performAction(Node[] nodeArray) {
        Node[] nodeArray2 = this.getOriginalNodes(this.getActivatedNodes());
        this.copyToNewGraph(GraphNodeManager.getEntityNodes(nodeArray2));
    }

    protected boolean enable(Node[] nodeArray) {
        Node[] nodeArray2 = GraphNodeManager.getEntityNodes(this.getActivatedNodes());
        return nodeArray2 != null && nodeArray2.length > 0;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private void copyToNewGraph(Node[] nodeArray) {
        GraphEditorRegistry.getDefault().addPropertyChangeListener(new OpenHandler(nodeArray));
        ((NewGraphAction)SystemAction.get(NewGraphAction.class)).performAction();
    }

    private Node[] getOriginalNodes(Node[] nodeArray) {
        ArrayList<Node> arrayList = new ArrayList<Node>(nodeArray.length);
        for (Node node : nodeArray) {
            if (node instanceof GraphFilterNode) {
                GraphFilterNode graphFilterNode = (GraphFilterNode)node;
                arrayList.add(graphFilterNode.getOriginal());
                continue;
            }
            arrayList.add(node);
        }
        return arrayList.toArray(new Node[0]);
    }

    protected abstract boolean performCopy(ExplorerManager var1, Node[] var2);

    private static ExplorerManager findExplorer() {
        return CopyToNewGraphAction.findExplorer(GraphEditorRegistry.getDefault().getTopmost());
    }

    private static ExplorerManager findExplorer(TopComponent topComponent) {
        if (topComponent == null) {
            return null;
        }
        if (topComponent instanceof ExplorerManager.Provider) {
            return ((ExplorerManager.Provider)topComponent).getExplorerManager();
        }
        return (ExplorerManager)topComponent.getLookup().lookup(ExplorerManager.class);
    }

    private void RelayoutNewGraph() {
        new BA(7).doLayout(this.getTopGraph2DView(), (l)new MaltegoLayouter());
    }

    private S getTopGraph2DView() {
        JComponent jComponent;
        GraphViewCookie graphViewCookie;
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != null && (graphViewCookie = (GraphViewCookie)topComponent.getLookup().lookup(GraphViewCookie.class)) != null && (jComponent = graphViewCookie.getGraphView().getViewControl()) instanceof S) {
            return (S)jComponent;
        }
        return null;
    }

    private class CopyHandler
    implements PropertyChangeListener {
        private ExplorerManager _explorer;
        private Node[] _nodes;

        public CopyHandler(Node[] nodeArray, ExplorerManager explorerManager) {
            this._explorer = explorerManager;
            this._nodes = nodeArray;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("exploredContext".equals(propertyChangeEvent.getPropertyName())) {
                this._explorer.removePropertyChangeListener((PropertyChangeListener)this);
                if (CopyToNewGraphAction.this.performCopy(this._explorer, this._nodes)) {
                    CopyToNewGraphAction.this.RelayoutNewGraph();
                }
            }
        }
    }

    private class OpenHandler
    implements PropertyChangeListener {
        private Node[] _nodes;

        public OpenHandler(Node[] nodeArray) {
            this._nodes = nodeArray;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("topmost".equals(propertyChangeEvent.getPropertyName())) {
                GraphEditorRegistry.getDefault().removePropertyChangeListener(this);
                ExplorerManager explorerManager = CopyToNewGraphAction.findExplorer();
                if (explorerManager != null) {
                    if (!CopyToNewGraphAction.this.performCopy(explorerManager, this._nodes)) {
                        explorerManager.addPropertyChangeListener((PropertyChangeListener)new CopyHandler(this._nodes, explorerManager));
                    } else {
                        CopyToNewGraphAction.this.RelayoutNewGraph();
                    }
                }
            }
        }
    }
}

