/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.ui.graph.EntityImageFactory;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import yguard.A.A.D;

public class ChangeTypePanel
extends JPanel {
    private D _graph;
    private JList _specList;

    public ChangeTypePanel(D d2) {
        this._graph = d2;
        this.initComponents();
        this._specList.setCellRenderer(new SpecListCellRenderer());
        this._specList.setListData(this.getSortedSpecs().toArray());
    }

    public MaltegoEntitySpec getEntitySpec() {
        return (MaltegoEntitySpec)this._specList.getSelectedValue();
    }

    public void setEntitySpec(MaltegoEntitySpec maltegoEntitySpec) {
        int n = 0;
        if (maltegoEntitySpec != null) {
            ListModel listModel = this._specList.getModel();
            for (int i = 0; i < listModel.getSize(); ++i) {
                Object e = listModel.getElementAt(0);
                if (!maltegoEntitySpec.equals(e)) continue;
                n = i;
                break;
            }
        }
        this._specList.setSelectedIndex(n);
    }

    private List<MaltegoEntitySpec> getSortedSpecs() {
        ArrayList<MaltegoEntitySpec> arrayList = new ArrayList<MaltegoEntitySpec>(EntityRegistry.forGraph((D)this._graph).getAllVisible());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)iterator.next();
            if (maltegoEntitySpec.isToolboxItem()) continue;
            iterator.remove();
        }
        Collections.sort(arrayList, new Comparator<MaltegoEntitySpec>(){

            @Override
            public int compare(MaltegoEntitySpec maltegoEntitySpec, MaltegoEntitySpec maltegoEntitySpec2) {
                return maltegoEntitySpec.getDisplayName().compareTo(maltegoEntitySpec2.getDisplayName());
            }
        });
        return arrayList;
    }

    private void initComponents() {
        JScrollPane jScrollPane = new JScrollPane();
        this._specList = new JList();
        this._specList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        jScrollPane.setViewportView(this._specList);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(jScrollPane, -2, 261, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(jScrollPane, -1, 278, Short.MAX_VALUE).addContainerGap()));
    }

    private class SpecListCellRenderer
    extends DefaultListCellRenderer {
        private SpecListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Icon icon;
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)object;
            if (maltegoEntitySpec != null && (icon = EntityImageFactory.forGraph(ChangeTypePanel.this._graph).getSmallTypeIcon(maltegoEntitySpec.getTypeName(), null)) != null) {
                this.setIcon(icon);
            }
            return component;
        }
    }
}

