/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.typing.editing.propertygrid.editors.ComboBoxPropertyEditor;
import com.paterva.maltego.typing.editors.OptionItemCollection;
import com.paterva.maltego.ui.graph.BookmarkFactory;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import org.openide.explorer.propertysheet.InplaceEditor;

public class BookmarkPropertyEditor
extends ComboBoxPropertyEditor {
    public BookmarkPropertyEditor(OptionItemCollection optionItemCollection) {
        super(optionItemCollection);
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        super.paintValue(graphics, rectangle);
        int n = 0;
        this.getBookmarkIcon((Integer)this.getValue(), rectangle.height).paintIcon(null, graphics, rectangle.x, n);
    }

    private Icon getBookmarkIcon(Integer n, int n2) {
        return BookmarkFactory.getDefault().getIcon(n, n2);
    }

    public InplaceEditor createEditor() {
        InplaceEditor inplaceEditor = super.createEditor();
        JComponent jComponent = inplaceEditor.getComponent();
        if (jComponent instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)jComponent;
            jComboBox.setRenderer(new BookmarkListCellRenderer());
        }
        return inplaceEditor;
    }

    private class BookmarkListCellRenderer
    extends DefaultListCellRenderer {
        private BookmarkListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            OptionItemCollection.OptionItem optionItem;
            Object object2;
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof OptionItemCollection.OptionItem && ((object2 = (optionItem = (OptionItemCollection.OptionItem)object).getValue()) == null || object2 instanceof Integer)) {
                this.setIcon(BookmarkPropertyEditor.this.getBookmarkIcon((Integer)object2, 16));
                this.setText("");
            }
            return component;
        }
    }
}

