/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.entity.manager.palette.PaletteSupport;
import com.paterva.maltego.ui.graph.CopyFactories;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphViewManager;
import com.paterva.maltego.ui.graph.ViewCallback;
import com.paterva.maltego.ui.graph.ViewControlAdapter;
import com.paterva.maltego.ui.graph.ViewDescriptor;
import com.paterva.maltego.ui.graph.clipboard.MergeGraphPasteAction;
import com.paterva.maltego.ui.graph.impl.DefaultGraphViewManager;
import com.paterva.maltego.ui.graph.impl.GraphViewUpdateManager;
import com.paterva.maltego.ui.graph.impl.ViewPanel;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.jdesktop.swingx.painter.BusyPainter;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.spi.palette.PaletteController;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.SaveCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import yguard.A.A.D;
import yguard.A.A.Y;
import yguard.A.D.q;
import yguard.A.I.H;
import yguard.A.I.QA;

class GraphViewElement
implements MultiViewElement,
GraphViewUpdateManager.ViewUpdateCallback,
PropertyChangeListener {
    private GraphViewPanel _viewPanel = new GraphViewPanel();
    private DataObject _dobj;
    private ViewControlAdapter _adapter;
    private MultiViewElementCallback _multiviewCB;
    private Lookup _lookup;
    private static final String CONTROL_VIEW = "ControlView";
    private static final String PROGRESS_VIEW = "ProgressView";
    private final ExplorerManager _explorer;
    private D _modelGraph;
    private GraphViewUpdateManager _updater;
    private q._E _copyFactory;
    private ViewDescriptor _descriptor;
    private boolean _preparingView = false;
    private JToggleButton _freezeButton;

    public GraphViewElement(DataObject dataObject, ViewControlAdapter viewControlAdapter) {
        this._dobj = dataObject;
        this._adapter = viewControlAdapter;
        this._viewPanel.addMainView(this.getControlAdapter().getViewControl(), CONTROL_VIEW);
        this._viewPanel.addMainView(new ProgressView(), PROGRESS_VIEW);
        this._explorer = new ExplorerManager();
    }

    protected ViewControlAdapter getControlAdapter() {
        return this._adapter;
    }

    public DataObject getDataObject() {
        return this._dobj;
    }

    public JComponent getVisualRepresentation() {
        return this._viewPanel;
    }

    public JComponent getToolbarRepresentation() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(Box.createHorizontalStrut(10));
        this._freezeButton = null;
        if ("false".equals(System.getProperty("maltego.hide-freeze-button", "false"))) {
            this._freezeButton = new JToggleButton(this.updater().getToggleFreezeAction());
            this._freezeButton.setIcon(ImageUtilities.loadImageIcon((String)"com/paterva/maltego/ui/graph/impl/FreezeBlue.png", (boolean)false));
            this._freezeButton.setSelectedIcon(ImageUtilities.loadImageIcon((String)"com/paterva/maltego/ui/graph/impl/FreezeRed.png", (boolean)false));
            this._freezeButton.setSelected(!this.updater().isUpdateViewOnModelChange());
            jToolBar.add(this._freezeButton);
            jToolBar.add(this.updater().getUpdateViewAction());
        }
        jToolBar.addSeparator();
        JComponent jComponent = this.getControlAdapter().getToolbar();
        if (jComponent != null) {
            jToolBar.add(jComponent);
        }
        return jToolBar;
    }

    public Action[] getActions() {
        if (this._multiviewCB != null) {
            return this._multiviewCB.createDefaultActions();
        }
        return new Action[0];
    }

    public Lookup getLookup() {
        if (this._lookup == null) {
            PaletteController paletteController = null;
            if (this._descriptor.showPalette()) {
                paletteController = PaletteSupport.createPalette();
            }
            ActionMap actionMap = this._viewPanel.getActionMap();
            JComponent jComponent = this.getControlAdapter().getViewControl();
            GraphViewElement.attachActions(jComponent.getActionMap(), actionMap);
            actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this._explorer));
            actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this._explorer));
            actionMap.put("maltego.paste", (Action)SystemAction.get(MergeGraphPasteAction.class));
            actionMap.put("delete", new MultiSelectDeleteAction(ExplorerUtils.actionDelete((ExplorerManager)this._explorer, (boolean)true)));
            this.addInput(KeyStroke.getKeyStroke("control pressed C"), "copy-to-clipboard");
            this.addInput(KeyStroke.getKeyStroke("control pressed X"), "cut-to-clipboard");
            this.addInput(KeyStroke.getKeyStroke("control pressed V"), "maltego.paste");
            this.addInput(KeyStroke.getKeyStroke("DELETE"), "delete");
            Lookup lookup = ExplorerUtils.createLookup((ExplorerManager)this._explorer, (ActionMap)actionMap);
            Lookup lookup2 = paletteController != null ? Lookups.fixed((Object[])new Object[]{paletteController, this._explorer}) : Lookups.fixed((Object[])new Object[]{this._explorer});
            Lookup lookup3 = this.getControlAdapter().getLookup();
            this._lookup = lookup3 != Lookup.EMPTY ? new ProxyLookup(new Lookup[]{lookup2, lookup, this._dobj.getNodeDelegate().getLookup(), lookup3}) : new ProxyLookup(new Lookup[]{lookup2, lookup, this._dobj.getNodeDelegate().getLookup()});
        }
        return this._lookup;
    }

    private void addInput(KeyStroke keyStroke, Object object) {
        if (this._viewPanel != null) {
            this._viewPanel.getInputMap(1).put(keyStroke, object);
        }
        if (this._adapter != null) {
            this._adapter.addInput(keyStroke, object);
        }
    }

    private static void showInputs(InputMap inputMap) {
        for (KeyStroke keyStroke : inputMap.keys()) {
            System.out.println("key=" + keyStroke + " -> " + inputMap.get(keyStroke));
        }
    }

    private static void attachActions(ActionMap actionMap, ActionMap actionMap2) {
        Object[] objectArray = actionMap.keys();
        if (objectArray != null) {
            for (Object object : objectArray) {
                actionMap2.put(object, actionMap.get(object));
            }
        }
    }

    public void componentOpened() {
        this.startLoadModelGraph();
        this.getControlAdapter().componentOpened();
    }

    protected D createViewGraph(D d2) {
        H h = H.F((D)d2);
        D d3 = h.A(this.getCopyFactory(), this._descriptor.createViewFilter(), false, false);
        DefaultGraphViewManager defaultGraphViewManager = (DefaultGraphViewManager)Lookup.getDefault().lookup(GraphViewManager.class);
        defaultGraphViewManager.associateViewGraph(d2, d3, this._descriptor.getName());
        return d3;
    }

    private void modelGraphLoadedImpl(D d2) {
        this._modelGraph = d2;
        D d3 = this.createViewGraph(d2);
        this.updater().setGraphs(d2, d3);
        this._explorer.setRootContext(GraphNodeManager.getInstance(d3).getNode());
        this._explorer.getExploredContext().getChildren().getNodes();
        this.getControlAdapter().componentOpened();
        this.getControlAdapter().setGraph(d3);
    }

    protected D getModelGraph() {
        return this._modelGraph;
    }

    protected D getViewGraph() {
        return this.getControlAdapter().getGraph();
    }

    private GraphViewUpdateManager updater() {
        if (this._updater == null) {
            this._updater = new GraphViewUpdateManager(this);
            this._updater.addPropertyChangeListener(this);
        }
        return this._updater;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("freezeChanged".equals(propertyChangeEvent.getPropertyName())) {
            System.out.println("PROP_FREEZE_CHANGED");
            System.out.println("_freezeButton = " + this._freezeButton);
            System.out.println("_updater = " + this._updater);
            if (this._freezeButton != null && this._updater != null) {
                this._freezeButton.setSelected(!this._updater.isUpdateViewOnModelChange());
            }
        }
    }

    private static String toString(Iterable iterable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (Object t : iterable) {
            stringBuffer.append(t.toString());
            stringBuffer.append(";");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentClosed() {
        try {
            if (this._explorer != null) {
                this._explorer.setSelectedNodes(new Node[0]);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            Exceptions.printStackTrace((Throwable)propertyVetoException);
        }
        finally {
            this.updater().viewClosed();
            this.getControlAdapter().componentClosed();
        }
    }

    public void componentShowing() {
        if (this._modelGraph != null && !this._preparingView) {
            this._preparingView = true;
            this.startProgress();
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    GraphViewElement.this.getControlAdapter().prepareToShow();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GraphViewElement.this.progressComplete();
                            GraphViewElement.this._preparingView = false;
                            GraphViewElement.this.updater().viewShowing();
                            GraphViewElement.this.getControlAdapter().componentShowing();
                        }
                    });
                }
            });
        } else if (this._modelGraph != null) {
            this.updater().viewShowing();
            this.getControlAdapter().componentShowing();
        }
    }

    public void componentHidden() {
        this.updater().viewHidden();
        this.getControlAdapter().componentHidden();
    }

    public void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this._explorer, (boolean)true);
        this.getControlAdapter().componentActivated();
    }

    public void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this._explorer, (boolean)false);
        this.getControlAdapter().componentDeactivated();
    }

    public UndoRedo getUndoRedo() {
        return UndoRedo.NONE;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this._multiviewCB = multiViewElementCallback;
        this.getControlAdapter().setViewCallback(new ViewElementCallback());
    }

    public CloseOperationState canCloseElement() {
        if (this._dobj.isModified()) {
            return MultiViewFactory.createUnsafeCloseState((String)"dirty", (Action)new ProceedAction(), (Action)new DiscardAction());
        }
        return CloseOperationState.STATE_OK;
    }

    private void startLoadModelGraph() {
        final GraphCookie graphCookie = (GraphCookie)this.getDataObject().getLookup().lookup(GraphCookie.class);
        if (graphCookie != null) {
            this.startProgress();
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    final D d2 = graphCookie.getGraph();
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                if (d2 != null) {
                                    GraphViewElement.this.modelGraphLoadedImpl(d2);
                                }
                            }
                            finally {
                                GraphViewElement.this.progressComplete();
                            }
                            GraphViewElement.this.componentShowing();
                        }
                    });
                }
            });
        }
    }

    private void startProgress() {
        this._viewPanel.selectMainView(PROGRESS_VIEW);
    }

    private void progressComplete() {
        this._viewPanel.selectMainView(CONTROL_VIEW);
    }

    void init(ViewDescriptor viewDescriptor) {
        this._descriptor = viewDescriptor;
        this._copyFactory = viewDescriptor.createCopyFactory();
    }

    protected q._E getCopyFactory() {
        if (this._copyFactory == null) {
            this._copyFactory = this._descriptor.createCopyFactory();
            if (this._copyFactory == null) {
                this._copyFactory = CopyFactories.create(false);
            }
        }
        return this._copyFactory;
    }

    @Override
    public void updateStarted() {
    }

    @Override
    public void performUpdate(Set<Y> set, boolean bl) {
        this.getControlAdapter().onGraphUpdated(set, bl);
    }

    @Override
    public void updateCompleted() {
    }

    private static final class ProgressView
    extends JPanel {
        public ProgressView() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            JXBusyLabel jXBusyLabel = new JXBusyLabel(new Dimension(100, 100));
            BusyPainter busyPainter = new BusyPainter(100);
            busyPainter.setTrailLength(5);
            busyPainter.setPoints(10);
            busyPainter.setPointShape((Shape)new RoundRectangle2D.Float(10.0f, 10.0f, 50.0f, 20.0f, 20.0f, 20.0f));
            busyPainter.setFrame(1);
            jXBusyLabel.setPreferredSize(new Dimension(100, 100));
            jXBusyLabel.setIcon((Icon)new EmptyIcon(100, 100));
            jXBusyLabel.setBusyPainter(busyPainter);
            jXBusyLabel.setBusy(true);
            jXBusyLabel.setHorizontalAlignment(0);
            jPanel.add((Component)jXBusyLabel, "Center");
            jPanel.setAlignmentY(0.5f);
            this.add((Component)jPanel, "Center");
        }
    }

    private final class ViewElementCallback
    implements ViewCallback {
        private ViewElementCallback() {
        }

        @Override
        public ViewDescriptor getDescriptor() {
            return GraphViewElement.this._descriptor;
        }

        @Override
        public q._E getCopyFactory() {
            return GraphViewElement.this.getCopyFactory();
        }

        @Override
        public TopComponent getTopComponent() {
            return GraphViewElement.this._multiviewCB.getTopComponent();
        }

        @Override
        public void showSideBar(Component component, String string) {
            GraphViewElement.this._viewPanel.addSideBar(component, string);
        }

        @Override
        public void hideSideBar(String string) {
            GraphViewElement.this._viewPanel.removeSideBar(string);
        }
    }

    private class DiscardAction
    extends AbstractAction {
        private DiscardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                GraphViewElement.this._dobj.setModified(false);
                GraphViewElement.this._dobj.setValid(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                ErrorManager.getDefault().notify((Throwable)propertyVetoException);
            }
        }
    }

    private class ProceedAction
    extends AbstractAction {
        private ProceedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                SaveCookie saveCookie = (SaveCookie)GraphViewElement.this._dobj.getCookie(SaveCookie.class);
                saveCookie.save();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }

        @Override
        public boolean isEnabled() {
            return GraphViewElement.this._dobj.isModified();
        }
    }

    private class MultiSelectDeleteAction
    extends AbstractAction {
        private Action _delegate;

        public MultiSelectDeleteAction(Action action) {
            this._delegate = action;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            QA qA = (QA)GraphViewElement.this.getViewGraph();
            qA.\u00e3();
            boolean bl = false;
            this._delegate.actionPerformed(actionEvent);
            qA.\u00d0();
            if (bl) {
                qA.\u011b();
            }
        }
    }

    private class GraphViewPanel
    extends ViewPanel
    implements ExplorerManager.Provider {
        private GraphViewPanel() {
        }

        public ExplorerManager getExplorerManager() {
            return GraphViewElement.this._explorer;
        }
    }
}

