/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.find;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.MaltegoGraph;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.ViewControlAdapter;
import com.paterva.maltego.ui.graph.find.FindBar;
import com.paterva.maltego.ui.graph.find.SearchProvider;
import com.paterva.maltego.util.ListMap;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import org.openide.util.NbPreferences;
import yguard.A.A.D;

public class ShowFindBarAction
extends AbstractAction {
    public static final String PROP_ENTITY_TYPE = "type";
    public static final String PROP_DISPLAY_INFO = "displayInfo";
    public static final String PROP_NOTES = "notes";
    public static final String PROP_ALL_PROPS = "allProperties";
    public static final String PROP_BOOKMARK = "bookmark";
    public static final String PROP_ZOOM_TO_RESULT = "zoomToResult";
    private ViewControlAdapter _control;
    private FindBar _findBar;
    private SearchProvider _cb;

    public ShowFindBarAction(ViewControlAdapter viewControlAdapter, SearchProvider searchProvider) {
        this._control = viewControlAdapter;
        this._cb = searchProvider;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        FindBar findBar = this.getFindBar();
        MaltegoEntitySpec[] maltegoEntitySpecArray = ShowFindBarAction.getEntities(this._control.getGraph());
        Arrays.sort(maltegoEntitySpecArray, new SpecComparator());
        Object[] objectArray = new Object[maltegoEntitySpecArray.length + 1];
        objectArray[0] = "All";
        System.arraycopy(maltegoEntitySpecArray, 0, objectArray, 1, maltegoEntitySpecArray.length);
        findBar.setOptions(objectArray);
        this.loadPreferences();
        this._control.getViewCallback().showSideBar(findBar, "south");
    }

    private synchronized FindBar getFindBar() {
        if (this._findBar == null) {
            this._findBar = new FindBar(new FindAction(), new CloseAction());
        }
        return this._findBar;
    }

    private static MaltegoEntitySpec[] getEntities(D d2) {
        EntityRegistry entityRegistry = EntityRegistry.forGraph((D)d2);
        if (entityRegistry == null) {
            return new MaltegoEntitySpec[0];
        }
        Collection collection = entityRegistry.getAllVisible();
        return collection.toArray(new MaltegoEntitySpec[collection.size()]);
    }

    private static MaltegoEntitySpec[] getUniqueEntities(D d2) {
        EntityRegistry entityRegistry = EntityRegistry.forGraph((D)d2);
        if (entityRegistry == null) {
            return new MaltegoEntitySpec[0];
        }
        MaltegoGraph maltegoGraph = MaltegoGraphManager.get((D)d2);
        HashSet<String> hashSet = new HashSet<String>();
        for (MaltegoEntity maltegoEntity : maltegoGraph.entities()) {
            hashSet.add(maltegoEntity.getTypeName());
        }
        MaltegoEntitySpec[] maltegoEntitySpecArray = new MaltegoEntitySpec[hashSet.size()];
        int n = 0;
        for (String string : hashSet) {
            maltegoEntitySpecArray[n] = (MaltegoEntitySpec)entityRegistry.get(string);
            ++n;
        }
        return maltegoEntitySpecArray;
    }

    private void loadPreferences() {
        this._findBar.setIncludeDisplayInfo(NbPreferences.forModule(FindBar.class).getBoolean(PROP_DISPLAY_INFO, false));
        this._findBar.setIncludeNotes(NbPreferences.forModule(FindBar.class).getBoolean(PROP_NOTES, false));
        this._findBar.setIncludeFields(NbPreferences.forModule(FindBar.class).getBoolean(PROP_ALL_PROPS, false));
        this._findBar.setBookmarkResults(NbPreferences.forModule(FindBar.class).getBoolean(PROP_BOOKMARK, false));
        this._findBar.setZoomToResult(NbPreferences.forModule(FindBar.class).getBoolean(PROP_ZOOM_TO_RESULT, true));
    }

    private void savePreferences() {
        NbPreferences.forModule(FindBar.class).putBoolean(PROP_DISPLAY_INFO, this._findBar.isIncludeDisplayInfo());
        NbPreferences.forModule(FindBar.class).putBoolean(PROP_NOTES, this._findBar.isIncludeNotes());
        NbPreferences.forModule(FindBar.class).putBoolean(PROP_ALL_PROPS, this._findBar.isIncludeFields());
        NbPreferences.forModule(FindBar.class).putBoolean(PROP_BOOKMARK, this._findBar.isBookmarkResults());
        NbPreferences.forModule(FindBar.class).putBoolean(PROP_ZOOM_TO_RESULT, this._findBar.isZoomToResult());
    }

    private class CloseAction
    extends AbstractAction {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ShowFindBarAction.this._control.getViewCallback().hideSideBar("south");
            ShowFindBarAction.this.savePreferences();
            ShowFindBarAction.this._findBar = null;
        }
    }

    private final class SpecComparator
    implements Comparator<MaltegoEntitySpec> {
        private SpecComparator() {
        }

        @Override
        public int compare(MaltegoEntitySpec maltegoEntitySpec, MaltegoEntitySpec maltegoEntitySpec2) {
            return maltegoEntitySpec.getDisplayName().compareTo(maltegoEntitySpec2.getDisplayName());
        }
    }

    private class FindAction
    extends AbstractAction {
        private FindAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ShowFindBarAction.this._findBar != null) {
                MaltegoEntitySpec maltegoEntitySpec = null;
                Object object = ShowFindBarAction.this._findBar.getSelectedOption();
                if (object instanceof MaltegoEntitySpec) {
                    maltegoEntitySpec = (MaltegoEntitySpec)object;
                }
                ShowFindBarAction.this.savePreferences();
                ListMap listMap = new ListMap();
                listMap.put((Object)ShowFindBarAction.PROP_ENTITY_TYPE, (Object)maltegoEntitySpec);
                listMap.put((Object)ShowFindBarAction.PROP_DISPLAY_INFO, (Object)ShowFindBarAction.this._findBar.isIncludeDisplayInfo());
                listMap.put((Object)ShowFindBarAction.PROP_NOTES, (Object)ShowFindBarAction.this._findBar.isIncludeNotes());
                listMap.put((Object)ShowFindBarAction.PROP_ALL_PROPS, (Object)ShowFindBarAction.this._findBar.isIncludeFields());
                listMap.put((Object)ShowFindBarAction.PROP_BOOKMARK, (Object)ShowFindBarAction.this._findBar.isBookmarkResults());
                listMap.put((Object)ShowFindBarAction.PROP_ZOOM_TO_RESULT, (Object)ShowFindBarAction.this._findBar.isZoomToResult());
                ShowFindBarAction.this._cb.search(ShowFindBarAction.this._findBar.getSearchText(), (Map<String, Object>)listMap);
            }
        }
    }
}

