/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.data;

import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.graph.DefaultMaltegoGraphCopyFactory;
import com.paterva.maltego.graph.GraphWrapper;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.data.GraphEditorSupport;
import com.paterva.maltego.util.ui.ProductRestrictions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import yguard.A.A.D;
import yguard.A.A.Z;
import yguard.A.D.q;
import yguard.A.I.QA;
import yguard.A.I.w;

public abstract class GraphDataObject
extends MultiDataObject
implements GraphCookie {
    private D _graph;
    private SaveCookie _saveCookie;
    private PropertyChangeListener _listener;
    private String _password;

    public GraphDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException, IOException {
        super(fileObject, multiFileLoader);
        GraphEditorSupport graphEditorSupport = new GraphEditorSupport(this.getPrimaryEntry());
        this._saveCookie = new SaveCookieImpl(graphEditorSupport);
        this.getCookieSet().add((Node.Cookie)graphEditorSupport);
    }

    protected Node createNodeDelegate() {
        return new DataNode((DataObject)this, Children.LEAF, this.getLookup());
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    @Override
    public synchronized D getGraph() {
        if (this._graph == null) {
            try {
                this._graph = this.loadGraph();
                GraphWrapper graphWrapper = MaltegoGraphManager.getWrapper((D)this._graph);
                this.ensureAllEdgesHaveLinks(graphWrapper);
                MaltegoGraphManager.markClean((D)this._graph);
                this.initGraph(graphWrapper);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this._graph;
    }

    public abstract String getDefaultExtension();

    public abstract String getFileDescription();

    @Override
    public void setGraph(D d2) {
        this._graph = d2;
        this.initGraph(MaltegoGraphManager.getWrapper((D)this._graph));
    }

    private void initGraph(GraphWrapper graphWrapper) {
        this._graph.A((q._E)new DefaultMaltegoGraphCopyFactory((q._E)new w(), false));
        this._listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl;
                if (MaltegoGraphManager.PROP_DIRTY.equals(propertyChangeEvent.getPropertyName()) && (bl = ((Boolean)propertyChangeEvent.getNewValue()).booleanValue())) {
                    GraphDataObject.this.setModified(true);
                }
            }
        };
        graphWrapper.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._listener, (Object)graphWrapper));
    }

    public void setModified(boolean bl) {
        if (ProductRestrictions.isGraphSaveEnabled()) {
            super.setModified(bl);
            if (bl) {
                this.addSaveCookie();
            } else {
                this.removeSaveCookie();
            }
        }
    }

    private void addSaveCookie() {
        if (this.getCookie(SaveCookie.class) == null) {
            this.getCookieSet().add((Node.Cookie)this._saveCookie);
        }
    }

    private void removeSaveCookie() {
        SaveCookie saveCookie = (SaveCookie)this.getCookie(SaveCookie.class);
        if (saveCookie != null) {
            this.getCookieSet().remove((Node.Cookie)saveCookie);
            MaltegoGraphManager.markClean((D)this.getGraph());
        }
    }

    protected abstract D loadGraph() throws IOException;

    public abstract void saveGraph(D var1, OutputStream var2, ProgressHandle var3, AtomicBoolean var4) throws IOException;

    public abstract void saveGraph(D var1, ZipFile var2, ZipParameters var3, ProgressHandle var4, AtomicBoolean var5) throws IOException;

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String string) {
        this._password = string;
    }

    private void ensureAllEdgesHaveLinks(GraphWrapper graphWrapper) {
        if (graphWrapper.getGraph() instanceof QA) {
            QA qA = (QA)graphWrapper.getGraph();
            Z z = qA.\u00c9();
            while (z.ok()) {
                if (graphWrapper.link(z.edge()) == null) {
                    MaltegoLink maltegoLink = LinkFactory.createInstance((MaltegoLinkSpec)MaltegoLinkSpec.getManualSpec());
                    graphWrapper.set(z.edge(), maltegoLink);
                    maltegoLink.setColor(MaltegoLinkSpec.LINK_COLOR_TRANSFORM);
                }
                z.next();
            }
        }
    }

    private class SaveCookieImpl
    implements SaveCookie {
        private GraphEditorSupport _editor;

        public SaveCookieImpl(GraphEditorSupport graphEditorSupport) {
            this._editor = graphEditorSupport;
        }

        public void save() throws IOException {
            if (GraphDataObject.this.isModified()) {
                System.out.println("Saving from thread " + Thread.currentThread().getName());
                this._editor.save();
            }
        }

        public String toString() {
            return GraphDataObject.this.getPrimaryFile().getName();
        }
    }
}

