/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.clipboard;

import com.paterva.maltego.archive.mtz.graph.MaltegoGraphIO;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.EntityStringConverter;
import com.paterva.maltego.graph.MaltegoGraph;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.serializer.AttachmentsPathRegistry;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.ui.graph.CopyFactories;
import com.paterva.maltego.ui.graph.clipboard.GraphML;
import com.paterva.maltego.ui.graph.nodes.GraphNode;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import com.paterva.maltego.util.FileStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.openide.util.Lookup;
import yguard.A.A.D;
import yguard.A.A.E;
import yguard.A.A.Z;
import yguard.A.D.q;
import yguard.A.I.;
import yguard.A.I.QA;
import yguard.A.I.o;

public class GraphMLConverter {
    public static GraphML convert(QA qA, E e, Z z) throws IOException {
        QA qA2 = new QA();
        .A a2 = qA.\u0110();
        o o2 = qA.\u0116();
        q._E _E2 = CopyFactories.create(a2, o2, true);
        q q2 = new q(_E2);
        q2.A((D)qA, e, z, (D)qA2);
        return GraphMLConverter.convert(qA2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphML convert(QA qA) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        GraphML graphML = null;
        try {
            Set<Attachments> set = GraphMLConverter.getAttachments((D)qA);
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            for (Attachments attachments : set) {
                for (Attachment attachment : attachments) {
                    int n = attachment.getId();
                    String string = FileStore.getDefault().getRelativePath(n);
                    hashMap.put(n, string);
                }
            }
            AttachmentsPathRegistry.lock();
            AttachmentsPathRegistry.setPaths(hashMap);
            byteArrayOutputStream = new ByteArrayOutputStream();
            MaltegoGraphIO.write((D)qA, (OutputStream)byteArrayOutputStream);
            graphML = new GraphML(byteArrayOutputStream.toString("UTF-8"));
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            AttachmentsPathRegistry.unlock();
        }
        return graphML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QA convert(GraphML graphML) throws IOException {
        InputStream inputStream = null;
        QA qA = null;
        try {
            inputStream = new ByteArrayInputStream(graphML.getText().getBytes("UTF-8"));
            qA = (QA)MaltegoGraphIO.read((InputStream)inputStream, (EntityFactory)EntityFactory.getDefault());
            EntityRegistry.associate((D)qA, (EntityRegistry)EntityRegistry.getDefault());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return qA;
    }

    public static GraphML convert(String string) throws IOException {
        GraphML graphML = null;
        if (string.matches("(?msd)^(<\\?xml[^<]*\\?>)?\\s*<graphml.*</graphml>\\s*$")) {
            graphML = new GraphML(string);
        } else {
            EntityStringConverter entityStringConverter = (EntityStringConverter)Lookup.getDefault().lookup(EntityStringConverter.class);
            Collection collection = entityStringConverter.convert(string);
            QA qA = new QA();
            EntityRegistry.associate((D)qA, (EntityRegistry)EntityRegistry.getDefault());
            GraphNode graphNode = (GraphNode)GraphNodeManager.getInstance((D)qA).getNode();
            graphNode.addEntities(collection);
            graphML = GraphMLConverter.convert(qA);
        }
        return graphML;
    }

    private static Set<Attachments> getAttachments(D d2) {
        MaltegoGraph maltegoGraph = MaltegoGraphManager.get((D)d2);
        HashSet<Attachments> hashSet = new HashSet<Attachments>();
        for (MaltegoEntity maltegoEntity : maltegoGraph.entities()) {
            GraphMLConverter.appendAttachments((MaltegoPart)maltegoEntity, hashSet);
        }
        for (MaltegoEntity maltegoEntity : maltegoGraph.links()) {
            GraphMLConverter.appendAttachments((MaltegoPart)maltegoEntity, hashSet);
        }
        return hashSet;
    }

    private static void appendAttachments(MaltegoPart maltegoPart, Set<Attachments> set) {
        PropertyDescriptorCollection propertyDescriptorCollection = maltegoPart.getProperties();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorCollection) {
            Object object;
            if (!Attachments.class.equals((Object)propertyDescriptor.getType()) || !((object = maltegoPart.getValue(propertyDescriptor)) instanceof Attachments)) continue;
            set.add((Attachments)object);
        }
    }
}

