/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public abstract class CookieAction<T>
extends SystemAction
implements PropertyChangeListener {
    private TopComponent.Registry _topComponents;
    private Class<T> _cookieClass;

    public CookieAction(Class<T> clazz) {
        this(TopComponent.getRegistry(), clazz);
    }

    public CookieAction(TopComponent.Registry registry, Class<T> clazz) {
        this._topComponents = registry;
        this._cookieClass = clazz;
        this._topComponents.addPropertyChangeListener((PropertyChangeListener)this);
        this.checkEnabled(this._topComponents.getActivated());
    }

    private void checkEnabled(TopComponent topComponent) {
        this.setEnabled(this.getCookie(topComponent) != null);
    }

    private T getCookie(TopComponent topComponent) {
        if (topComponent != null) {
            return (T)topComponent.getLookup().lookup(this._cookieClass);
        }
        return null;
    }

    protected T getCookie() {
        return this.getCookie(this._topComponents.getActivated());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            this.checkEnabled((TopComponent)propertyChangeEvent.getNewValue());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TopComponent topComponent = this._topComponents.getActivated();
        T t = this.getCookie(topComponent);
        if (t != null) {
            this.performAction(t);
        }
    }

    protected abstract void performAction(T var1);

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

