/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.GraphWrapper;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.actions.EditorAction;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import yguard.A.A.D;
import yguard.A.A.X;
import yguard.A.A.Y;
import yguard.A.F.B;

public class AddCommonSiblingsAction
extends EditorAction {
    public String getName() {
        return "Add Similar Siblings";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/SelectChildren.png";
    }

    @Override
    protected void performAction(ExplorerManager explorerManager) throws PropertyVetoException {
        Node[] nodeArray = explorerManager.getSelectedNodes();
        if (nodeArray == null || GraphNodeManager.getEntityNodes(nodeArray).length == 0) {
            return;
        }
        HashSet<Y> hashSet = new HashSet<Y>();
        for (Node node : nodeArray) {
            Y y = (Y)node.getLookup().lookup(Y.class);
            if (y == null) continue;
            hashSet.add(y);
            hashSet.addAll((Collection<Y>)this.getCommonSiblings(y));
        }
        explorerManager.setSelectedNodes(this.toNodeArray(hashSet));
    }

    private X getCommonSiblings(Y y) {
        D d = y.H();
        X x = B.C((D)d, (X)new X(y), (int)1);
        X x2 = B.A((D)d, (X)x, (int)1);
        this.filterCommonEntities(y, x2);
        return x2;
    }

    private void filterCommonEntities(Y y, X x) {
        D d = y.H();
        GraphWrapper graphWrapper = MaltegoGraphManager.getWrapper((D)d);
        MaltegoEntity maltegoEntity = graphWrapper.entity(y);
        Iterator iterator = x.iterator();
        while (iterator.hasNext()) {
            MaltegoEntity maltegoEntity2 = graphWrapper.entity((Y)iterator.next());
            if (this.isSameSpec(maltegoEntity, maltegoEntity2)) continue;
            iterator.remove();
        }
    }

    private Node[] toNodeArray(Collection<Y> collection) {
        if (collection.size() > 0) {
            GraphNodeManager graphNodeManager = GraphNodeManager.getInstance(collection.iterator().next().H());
            return graphNodeManager.getNodes(new X(collection.iterator()).t()).toArray(new Node[0]);
        }
        return null;
    }

    private boolean isSameSpec(MaltegoEntity maltegoEntity, MaltegoEntity maltegoEntity2) {
        return maltegoEntity.getTypeName().equals(maltegoEntity2.getTypeName());
    }

    @Override
    protected boolean isEnabled(ExplorerManager explorerManager) {
        return explorerManager != null && GraphNodeManager.getEntityNodes(explorerManager.getSelectedNodes()).length > 0;
    }
}

