/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.editing.propertygrid.PropertyDescriptorProperty;
import com.paterva.maltego.util.ImageFileFilter;
import com.paterva.maltego.util.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

class ImageFileProperty
extends PropertyDescriptorProperty {
    private File _lastFile;

    public ImageFileProperty(DisplayDescriptor displayDescriptor, DataSource dataSource) {
        super(File.class, (PropertyDescriptor)displayDescriptor, dataSource);
        this.setValue("canEditAsText", Boolean.FALSE);
        this.setValue("filter", new ImageFileFilter());
        this.updateImage((Image)this.getDataSource().getValue((PropertyDescriptor)displayDescriptor));
    }

    @Override
    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this._lastFile;
    }

    @Override
    public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this._lastFile = (File)object;
        if (this._lastFile != null) {
            if (!this._lastFile.isDirectory()) {
                try {
                    this.updateImage(this.loadImage(this._lastFile));
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(iOException);
                }
            }
        } else {
            this.updateImage(null);
        }
    }

    private void updateImage(Image image) {
        ImageIcon imageIcon;
        String string;
        this.getDataSource().setValue(this.getPropertyDescriptor(), (Object)image);
        if (image == null) {
            string = "(none)";
            imageIcon = new ImageIcon();
        } else {
            string = "(" + image.getWidth(null) + "x" + image.getHeight(null) + ")";
            imageIcon = new ImageIcon(ImageUtils.smartSize((BufferedImage)ImageUtils.createBufferedImage((Image)image), (double)16.0));
        }
        this.setValue("htmlDisplayValue", string);
        this.setValue("valueIcon", imageIcon);
    }

    private BufferedImage loadImage(File file) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(file);
        return bufferedImage;
    }
}

