/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing;

import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.editing.AddPropertyForm;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.Comparator;
import org.openide.WizardDescriptor;

public class AddPropertyFormController
extends ValidatingController<AddPropertyForm> {
    public static final String UNIQUE_NAME = "uniqueName";
    public static final String TYPE_DESCRIPTOR = "typeDescriptor";
    public static final String DISPLAY_NAME = "displayName";
    public static final String IS_EDIT_MODE = "isEditMode";

    protected String getFirstError(AddPropertyForm addPropertyForm) {
        String string = addPropertyForm.getDisplayName();
        if (string.trim().length() == 0) {
            return "Display name is required";
        }
        String string2 = addPropertyForm.getUniqueName();
        if ((string2 = string2.trim()).length() == 0) {
            return "Unique type name is required";
        }
        if (!this.checkChars(string2)) {
            return "Only alphabetic characters, full stops and digits are allowed in the unique type name.";
        }
        if (addPropertyForm.getDataType() == null) {
            return "Data type is required";
        }
        return null;
    }

    protected AddPropertyForm createComponent() {
        final AddPropertyForm addPropertyForm = new AddPropertyForm();
        addPropertyForm.addChangeListener(this.changeListener());
        addPropertyForm.addDisplayNameFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string;
                if (!AddPropertyFormController.this.isEditMode() && (string = addPropertyForm.getUniqueName()).trim().length() == 0) {
                    addPropertyForm.setUniqueName(AddPropertyFormController.this.createID(addPropertyForm.getDisplayName()));
                }
            }
        });
        return addPropertyForm;
    }

    protected boolean isEditMode() {
        return this.getDescriptor().getProperty(IS_EDIT_MODE) == Boolean.TRUE;
    }

    private String createID(String string) {
        string = string.replaceAll(" ", "");
        string = string.toLowerCase();
        return "properties." + string;
    }

    private boolean checkChars(String string) {
        for (char c : string.toCharArray()) {
            if (Character.isLetter(c) || c == '.' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    protected void readSettings(WizardDescriptor wizardDescriptor) {
        AddPropertyForm addPropertyForm = (AddPropertyForm)this.component();
        TypeDescriptor[] typeDescriptorArray = TypeRegistry.getDefault().getTypes();
        Arrays.sort(typeDescriptorArray, new Comparator<TypeDescriptor>(){

            @Override
            public int compare(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
                return typeDescriptor.getTypeName().compareToIgnoreCase(typeDescriptor2.getTypeName());
            }
        });
        addPropertyForm.setDataTypes(typeDescriptorArray);
        addPropertyForm.setDataType((TypeDescriptor)wizardDescriptor.getProperty(TYPE_DESCRIPTOR));
        addPropertyForm.setDisplayName((String)wizardDescriptor.getProperty(DISPLAY_NAME));
        addPropertyForm.setUniqueName((String)wizardDescriptor.getProperty(UNIQUE_NAME));
    }

    protected void storeSettings(WizardDescriptor wizardDescriptor) {
        AddPropertyForm addPropertyForm = (AddPropertyForm)this.component();
        wizardDescriptor.putProperty(UNIQUE_NAME, (Object)addPropertyForm.getUniqueName());
        wizardDescriptor.putProperty(TYPE_DESCRIPTOR, (Object)addPropertyForm.getDataType());
        wizardDescriptor.putProperty(DISPLAY_NAME, (Object)addPropertyForm.getDisplayName());
    }
}

